<?php

namespace App\Models;

use App\Enums\StatusEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaterialNote extends Model
{
    /** @use HasFactory<\Database\Factories\MaterialNoteFactory> */
    use HasFactory;

    protected $fillable = [
        'material_id',
        'title',
        'description',
        'type',
        'icon',
        'file',
        'status',
    ];

    protected $casts = [
        'status' => StatusEnum::class,

    ];

    public function material()
    {
        $this->belongsTo(Material::class);
    }
}
