<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_levels', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('level_id'); // level_id as UNSIGNED BIGINT
            $table->string('title'); // title as VARCHAR
            $table->text('description')->nullable(); // description as TEXT, nullable
            $table->timestamps(); // created_at and updated_at

            // Foreign key constraint
            // $table->foreign('level_id')->references('id')->on('levels');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_levels');
    }
};
