<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lecture_questions', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('lecture_id'); // lecture_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('student_id'); // student_id as UNSIGNED BIGINT

            $table->text('question'); // question as TEXT
            $table->text('answer')->nullable(); // answer as TEXT, nullable

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraints
            $table->foreign('lecture_id')->references('id')->on('lectures')->onDelete('cascade');
            $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lecture_questions');
    }
};
