<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_notes', function (Blueprint $table) {
            $table->id(); // id INT AUTO_INCREMENT PRIMARY KEY
            $table->unsignedBigInteger('course_id'); // course_id as UNSIGNED BIGINT
            $table->unsignedBigInteger('course_section_id'); // course_section_id as UNSIGNED BIGINT

            $table->string('type'); // type as VARCHAR
            $table->longText('content'); // content as TEXT
            $table->string('image')->nullable(); // image as STRING, nullable

            $table->timestamps(); // created_at and updated_at

            // Foreign key constraints
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('course_section_id')->references('id')->on('course_sections');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_notes');
    }
};
