import { sortModifiers, IMPORTANT_MODIFIER } from './modifier-utils.mjs';

var SPLIT_CLASSES_REGEX = /\s+/;
function mergeClassList(classList, configUtils) {
  var splitModifiers = configUtils.splitModifiers,
      getClassGroupId = configUtils.getClassGroupId,
      getConflictingClassGroupIds = configUtils.getConflictingClassGroupIds;
  /**
   * Set of classGroupIds in following format:
   * `{importantModifier}{variantModifiers}{classGroupId}`
   * @example 'float'
   * @example 'hover:focus:bg-color'
   * @example 'md:!pr'
   */

  var classGroupsInConflict = new Set();
  return classList.trim().split(SPLIT_CLASSES_REGEX).map(function (originalClassName) {
    var _splitModifiers = splitModifiers(originalClassName),
        modifiers = _splitModifiers.modifiers,
        hasImportantModifier = _splitModifiers.hasImportantModifier,
        baseClassName = _splitModifiers.baseClassName;

    var classGroupId = getClassGroupId(baseClassName);

    if (!classGroupId) {
      return {
        isTailwindClass: false,
        originalClassName: originalClassName
      };
    }

    var variantModifier = sortModifiers(modifiers).join(':');
    var modifierId = hasImportantModifier ? variantModifier + IMPORTANT_MODIFIER : variantModifier;
    return {
      isTailwindClass: true,
      modifierId: modifierId,
      classGroupId: classGroupId,
      originalClassName: originalClassName
    };
  }).reverse() // Last class in conflict wins, so we need to filter conflicting classes in reverse order.
  .filter(function (parsed) {
    if (!parsed.isTailwindClass) {
      return true;
    }

    var modifierId = parsed.modifierId,
        classGroupId = parsed.classGroupId;
    var classId = modifierId + classGroupId;

    if (classGroupsInConflict.has(classId)) {
      return false;
    }

    classGroupsInConflict.add(classId);
    getConflictingClassGroupIds(classGroupId).forEach(function (group) {
      return classGroupsInConflict.add(modifierId + group);
    });
    return true;
  }).reverse().map(function (parsed) {
    return parsed.originalClassName;
  }).join(' ');
}

export { mergeClassList };
//# sourceMappingURL=merge-classlist.mjs.map
