

import * as React from "react";
import { SVGProps } from "react";

export const IconLike = (props: SVGProps<SVGSVGElement>) => (
  <svg
    width="1em"
    height="1em"
    fill="currentColor"
    viewBox="0 0 1024 1024"
    {...props}
  >
    <path d="M885.9 533.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.4-65.5-111.1a67.67 67.67 0 0 0-34.3-9.3H572.4l6-122.9c1.4-29.7-9.1-57.9-29.5-79.4A106.62 106.62 0 0 0 471 99.9c-52 0-98 35-111.8 85.1l-85.9 311H144c-17.7 0-32 14.3-32 32v364c0 17.7 14.3 32 32 32h601.3c9.2 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7-.2-12.6-2-25.1-5.6-37.1zM184 852V568h81v284h-81zm636.4-353-21.9 19 13.9 25.4a56.2 56.2 0 0 1 6.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 0 1 6.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 0 1 6.9 27.3c0 22.4-13.2 42.6-33.6 51.8H329V564.8l99.5-360.5a44.1 44.1 0 0 1 42.2-32.3c7.6 0 15.1 2.2 21.1 6.7 9.9 7.4 15.2 18.6 14.6 30.5l-9.6 198.4h314.4C829 418.5 840 436.9 840 456c0 16.5-7.2 32.1-19.6 43z" />
  </svg>
);

export const IconSave = (props: SVGProps<SVGSVGElement>) => (
  <svg
    width="1em"
    height="1em"
    fill="none"
    stroke="currentColor"
    strokeLinecap="round"
    strokeLinejoin="round"
    strokeWidth={2}
    viewBox="0 0 24 24"
    {...props}
  >
    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z" />
    <path d="M17 21v-8H7v8M7 3v5h8" />
  </svg>
);



export const IconMessage = (props: SVGProps<SVGSVGElement>) => (
  <svg
    width="1em"
    height="1em"
    fill="currentColor"
    viewBox="0 0 1024 1024"
    {...props}
  >
    <path d="M464 512a48 48 0 1 0 96 0 48 48 0 1 0-96 0zm200 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0zm-400 0a48 48 0 1 0 96 0 48 48 0 1 0-96 0zm661.2-173.6c-22.6-53.7-55-101.9-96.3-143.3a444.35 444.35 0 0 0-143.3-96.3C630.6 75.7 572.2 64 512 64h-2c-60.6.3-119.3 12.3-174.5 35.9a445.35 445.35 0 0 0-142 96.5c-40.9 41.3-73 89.3-95.2 142.8-23 55.4-34.6 114.3-34.3 174.9A449.4 449.4 0 0 0 112 714v152a46 46 0 0 0 46 46h152.1A449.4 449.4 0 0 0 510 960h2.1c59.9 0 118-11.6 172.7-34.3a444.48 444.48 0 0 0 142.8-95.2c41.3-40.9 73.8-88.7 96.5-142 23.6-55.2 35.6-113.9 35.9-174.5.3-60.9-11.5-120-34.8-175.6zm-151.1 438C704 845.8 611 884 512 884h-1.7c-60.3-.3-120.2-15.3-173.1-43.5l-8.4-4.5H188V695.2l-4.5-8.4C155.3 633.9 140.3 574 140 513.7c-.4-99.7 37.7-193.3 107.6-263.8 69.8-70.5 163.1-109.5 262.8-109.9h1.7c50 0 98.5 9.7 144.2 28.9 44.6 18.7 84.6 45.6 119 80 34.3 34.3 61.3 74.4 80 119 19.4 46.2 29.1 95.2 28.9 145.8-.6 99.6-39.7 192.9-110.1 262.7z" />
  </svg>
);

export function IconNotebook(props: SVGProps<SVGSVGElement>) {
    return (
      <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 32 32"
        width="1em"
        height="1em"
        {...props}
      >
        <g fill="currentColor">
          <path d="M25 2h-5V0h-2v2h-3V0h-2v2h-3V0H8v2H3v26h22zm-2 24H5V4h3v2h2V4h3v2h2V4h3v2h2V4h3z"></path>
          <path d="M27 7v23H8v2h21V7z"></path>
          <path
            d="M8 12h12v2H8zm0 5h12v2H8z"
            className="ouiIcon__fillSecondary"
          ></path>
        </g>
      </svg>
    )
  }


export const LearnVideo1 = ()=>(
    <svg
  xmlns="http://www.w3.org/2000/svg"
  xmlnsXlink="http://www.w3.org/1999/xlink"
  viewBox="0 0 640 640"
  width={640}
  height={640}
  preserveAspectRatio="xMidYMid meet"
  style={{
    width: "100%",
    height: "100%",
    transform: "translate3d(0px, 0px, 0px)",
    contentVisibility: "visible"
  }}
>
  <defs>
    <clipPath id="__lottie_element_35">
      <rect width={640} height={640} x={0} y={0} />
    </clipPath>
    <clipPath id="__lottie_element_37">
      <path d="M0,0 L279,0 L279,161 L0,161z" />
    </clipPath>
    <clipPath id="__lottie_element_41">
      <path d="M0,0 L301,0 L301,320 L0,320z" />
    </clipPath>
    <clipPath id="__lottie_element_45">
      <path d="M0,0 L158,0 L158,71 L0,71z" />
    </clipPath>
    <clipPath id="__lottie_element_49">
      <path d="M0,0 L360,0 L360,560 L0,560z" />
    </clipPath>
    <clipPath id="__lottie_element_53">
      <path d="M0,0 L320,0 L320,320 L0,320z" />
    </clipPath>
    <clipPath id="__lottie_element_57">
      <path d="M0,0 L360,0 L360,360 L0,360z" />
    </clipPath>
    <clipPath id="__lottie_element_61">
      <path d="M0,0 L70,0 L70,39 L0,39z" />
    </clipPath>
    <clipPath id="__lottie_element_65">
      <path d="M0,0 L56,0 L56,32 L0,32z" />
    </clipPath>
    <clipPath id="__lottie_element_81">
      <path d="M0,0 L164,0 L164,96 L0,96z" />
    </clipPath>
    <mask id="__lottie_element_82">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M163.9080047607422,49.91899871826172 C163.9080047607422,49.91899871826172 78.0770034790039,0 78.0770034790039,0 C78.0770034790039,0 0,45.64699935913086 0,45.64699935913086 C0,45.64699935913086 85.83000183105469,95.56600189208984 85.83000183105469,95.56600189208984 C85.83000183105469,95.56600189208984 163.9080047607422,49.91899871826172 163.9080047607422,49.91899871826172"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_121">
      <path d="M0,0 L301,0 L301,320 L0,320z" />
    </clipPath>
    <clipPath id="__lottie_element_179">
      <path d="M0,0 L161,0 L161,396 L0,396z" />
    </clipPath>
    <linearGradient
      id="__lottie_element_185"
      spreadMethod="pad"
      gradientUnits="userSpaceOnUse"
      x1={0}
      y1={183}
      x2={100}
      y2={0}
    >
      <stop offset="0%" stopColor="rgb(255,114,92)" />
      <stop offset="44%" stopColor="rgb(255,144,103)" />
      <stop offset="100%" stopColor="rgb(255,173,113)" />
    </linearGradient>
    <linearGradient
      id="__lottie_element_201"
      spreadMethod="pad"
      gradientUnits="userSpaceOnUse"
      x1={0}
      y1={0}
      x2={100}
      y2={0}
    >
      <stop offset="0%" stopColor="rgb(255,77,49)" />
      <stop offset="44%" stopColor="rgb(255,125,81)" />
      <stop offset="100%" stopColor="rgb(255,173,113)" />
    </linearGradient>
    <clipPath id="__lottie_element_227">
      <path d="M0,0 L241,0 L241,193 L0,193z" />
    </clipPath>
    <clipPath id="__lottie_element_255">
      <path d="M0,0 L70,0 L70,37 L0,37z" />
    </clipPath>
    <clipPath id="__lottie_element_265">
      <path d="M0,0 L20,0 L20,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_269">
      <path d="M0,0 L5,0 L5,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_273">
      <path d="M0,0 L7,0 L7,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_277">
      <path d="M0,0 L3,0 L3,6 L0,6z" />
    </clipPath>
    <clipPath id="__lottie_element_287">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_297">
      <path d="M0,0 L3,0 L3,5 L0,5z" />
    </clipPath>
    <clipPath id="__lottie_element_307">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_317">
      <path d="M0,0 L22,0 L22,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_324">
      <path d="M0,0 L20,0 L20,9 L0,9z" />
    </clipPath>
    <mask id="__lottie_element_325">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,6.783999919891357 C0,6.783999919891357 0.006000000052154064,8.557000160217285 0.006000000052154064,8.557000160217285 C0.004000000189989805,8.527000427246094 0.006000000052154064,8.49899959564209 0.006000000052154064,8.470000267028809 C0.035999998450279236,6.685999870300293 1.2640000581741333,5.00600004196167 3.4519999027252197,3.74399995803833 C5.729000091552734,2.450000047683716 8.666000366210938,1.7599999904632568 11.777999877929688,1.7730000019073486 C14.88700008392334,1.7869999408721924 17.79800033569336,2.503000020980835 19.97599983215332,3.7839999198913574 C19.97599983215332,3.7839999198913574 19.97100067138672,2.013000011444092 19.97100067138672,2.013000011444092 C17.792999267578125,0.7300000190734863 14.881999969482422,0.014000000432133675 11.77299976348877,0 C8.659000396728516,-0.010999999940395355 5.724999904632568,0.6790000200271606 3.446000099182129,1.9730000495910645 C1.2599999904632568,3.234999895095825 0.03200000151991844,4.914000034332275 0.0020000000949949026,6.697000026702881 C0.0020000000949949026,6.697000026702881 0,6.783999919891357 0,6.783999919891357"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_328">
      <path d="M0,0 L20,0 L20,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_368">
      <path d="M0,0 L5,0 L5,9 L0,9z" />
    </clipPath>
    <mask id="__lottie_element_369">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.010999999940395355,4.243000030517578 1.652999997138977,6.568999767303467 4.646999835968018,8.331999778747559 C4.646999835968018,8.331999778747559 4.64300012588501,6.559000015258789 4.64300012588501,6.559000015258789 C1.6490000486373901,4.796999931335449 0.006000000052154064,2.4700000286102295 0,0"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_372">
      <path d="M0,0 L5,0 L5,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_403">
      <path d="M0,0 L7,0 L7,4 L0,4z" />
    </clipPath>
    <mask id="__lottie_element_404">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,2.1700000762939453 C0,2.1700000762939453 0.004999999888241291,3.940999984741211 0.004999999888241291,3.940999984741211 C0.004999999888241291,3.940999984741211 0.006000000052154064,3.9159998893737793 0.006000000052154064,3.9159998893737793 C0.01899999938905239,3.3450000286102295 0.41200000047683716,2.806999921798706 1.1169999837875366,2.4000000953674316 C2.5980000495910645,1.5570000410079956 4.9720001220703125,1.5640000104904175 6.4079999923706055,2.4159998893737793 C6.4079999923706055,2.4159998893737793 6.4029998779296875,0.6439999938011169 6.4029998779296875,0.6439999938011169 C4.9670000076293945,-0.20800000429153442 2.5929999351501465,-0.2160000056028366 1.1119999885559082,0.628000020980835 C0.40700000524520874,1.034999966621399 0.014000000432133675,1.5729999542236328 0,2.1440000534057617 C0,2.1440000534057617 0,2.1700000762939453 0,2.1700000762939453"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_407">
      <path d="M0,0 L7,0 L7,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_447">
      <path d="M0,0 L3,0 L3,6 L0,6z" />
    </clipPath>
    <mask id="__lottie_element_448">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.00800000037997961,3.0220000743865967 0.8730000257492065,4.245999813079834 2.385999917984009,5.13700008392334 C2.385999917984009,5.13700008392334 2.38100004196167,3.365999937057495 2.38100004196167,3.365999937057495 C0.8679999709129333,2.4739999771118164 0.003000000026077032,1.2510000467300415 0,0"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_451">
      <path d="M0,0 L3,0 L3,6 L0,6z" />
    </clipPath>
    <clipPath id="__lottie_element_482">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <mask id="__lottie_element_483">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M3.9519999027252197,1.7710000276565552 C3.9519999027252197,1.7710000276565552 3.947000026702881,0 3.947000026702881,0 C3.947000026702881,0.34599998593330383 3.7149999141693115,0.6940000057220459 3.253999948501587,0.9620000123977661 C2.3440001010894775,1.4780000448226929 0.8889999985694885,1.4730000495910645 0,0.9480000138282776 C0,0.9480000138282776 0.004999999888241291,2.7190001010894775 0.004999999888241291,2.7190001010894775 C0.8939999938011169,3.24399995803833 2.3489999771118164,3.25 3.259000062942505,2.7339999675750732 C3.7219998836517334,2.4660000801086426 3.9519999027252197,2.117000102996826 3.9519999027252197,1.7710000276565552"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_486">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_526">
      <path d="M0,0 L3,0 L3,5 L0,5z" />
    </clipPath>
    <mask id="__lottie_element_527">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M2.2009999752044678,4.885000228881836 C2.2009999752044678,4.885000228881836 2.196000099182129,3.114000082015991 2.196000099182129,3.114000082015991 C2.193000078201294,1.9869999885559082 1.4620000123977661,0.8629999756813049 0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C1.468000054359436,2.634000062942505 2.197999954223633,3.759999990463257 2.2009999752044678,4.885000228881836"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_530">
      <path d="M0,0 L3,0 L3,5 L0,5z" />
    </clipPath>
    <clipPath id="__lottie_element_561">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <mask id="__lottie_element_562">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M3.953000068664551,1.7710000276565552 C3.953000068664551,1.7710000276565552 3.947999954223633,0 3.947999954223633,0 C3.947999954223633,0.34599998593330383 3.7179999351501465,0.6919999718666077 3.256999969482422,0.9589999914169312 C2.3489999771118164,1.4759999513626099 0.8889999985694885,1.4709999561309814 0,0.9459999799728394 C0,0.9459999799728394 0.004999999888241291,2.7179999351501465 0.004999999888241291,2.7179999351501465 C0.8939999938011169,3.243000030517578 2.3540000915527344,3.247999906539917 3.26200008392334,2.7309999465942383 C3.7230000495910645,2.4639999866485596 3.953000068664551,2.117000102996826 3.953000068664551,1.7710000276565552"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_565">
      <path d="M0,0 L4,0 L4,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_605">
      <path d="M0,0 L22,0 L22,9 L0,9z" />
    </clipPath>
    <mask id="__lottie_element_606">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M21.111000061035156,1.7710000276565552 C21.111000061035156,1.7710000276565552 21.106000900268555,0 21.106000900268555,0 C21.111000061035156,1.8509999513626099 19.881999969482422,3.7109999656677246 17.41900062561035,5.132999897003174 C15.067000389099121,6.46999979019165 11.96500015258789,7.198999881744385 8.668999671936035,7.184999942779541 C5.380000114440918,7.171000003814697 2.299999952316284,6.414000034332275 0,5.057000160217285 C0,5.057000160217285 0.006000000052154064,6.828999996185303 0.006000000052154064,6.828999996185303 C2.303999900817871,8.185999870300293 5.385000228881836,8.942999839782715 8.673999786376953,8.956000328063965 C11.970000267028809,8.970000267028809 15.071999549865723,8.241000175476074 17.423999786376953,6.9039998054504395 C19.88599967956543,5.48199987411499 21.115999221801758,3.621999979019165 21.111000061035156,1.7710000276565552"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_609">
      <path d="M0,0 L22,0 L22,9 L0,9z" />
    </clipPath>
    <clipPath id="__lottie_element_652">
      <path d="M0,0 L56,0 L56,30 L0,30z" />
    </clipPath>
    <clipPath id="__lottie_element_662">
      <path d="M0,0 L16,0 L16,7 L0,7z" />
    </clipPath>
    <clipPath id="__lottie_element_666">
      <path d="M0,0 L4,0 L4,7 L0,7z" />
    </clipPath>
    <clipPath id="__lottie_element_670">
      <path d="M0,0 L6,0 L6,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_674">
      <path d="M0,0 L2,0 L2,5 L0,5z" />
    </clipPath>
    <clipPath id="__lottie_element_684">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <clipPath id="__lottie_element_694">
      <path d="M0,0 L2,0 L2,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_704">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <clipPath id="__lottie_element_714">
      <path d="M0,0 L17,0 L17,8 L0,8z" />
    </clipPath>
    <clipPath id="__lottie_element_721">
      <path d="M0,0 L16,0 L16,7 L0,7z" />
    </clipPath>
    <mask id="__lottie_element_722">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M15.979999542236328,5.426000118255615 C15.979999542236328,5.426000118255615 15.975000381469727,6.8429999351501465 15.975000381469727,6.8429999351501465 C15.975000381469727,6.821000099182129 15.975000381469727,6.796999931335449 15.975000381469727,6.775000095367432 C15.949000358581543,5.3470001220703125 14.968000411987305,4.004000186920166 13.218999862670898,2.99399995803833 C11.395999908447266,1.9579999446868896 9.04800033569336,1.406999945640564 6.558000087738037,1.4170000553131104 C4.072000026702881,1.4279999732971191 1.7430000305175781,2 0,3.0260000228881836 C0,3.0260000228881836 0.003000000026077032,1.6089999675750732 0.003000000026077032,1.6089999675750732 C1.746000051498413,0.5830000042915344 4.073999881744385,0.010999999940395355 6.561999797821045,0 C9.052000045776367,-0.009999999776482582 11.401000022888184,0.5410000085830688 13.222000122070312,1.5770000219345093 C14.972999572753906,2.5869998931884766 15.954000473022461,3.930000066757202 15.977999687194824,5.357999801635742 C15.979999542236328,5.380000114440918 15.979999542236328,5.4039998054504395 15.979999542236328,5.426000118255615"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_725">
      <path d="M0,0 L16,0 L16,7 L0,7z" />
    </clipPath>
    <clipPath id="__lottie_element_765">
      <path d="M0,0 L4,0 L4,7 L0,7z" />
    </clipPath>
    <mask id="__lottie_element_766">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M3.7170000076293945,0 C3.7170000076293945,0 3.7139999866485596,1.4170000553131104 3.7139999866485596,1.4170000553131104 C3.7079999446868896,3.3940000534057617 2.3940000534057617,5.254000186920166 0,6.664999961853027 C0,6.664999961853027 0.003000000026077032,5.247000217437744 0.003000000026077032,5.247000217437744 C2.3980000019073486,3.8359999656677246 3.7119998931884766,1.9759999513626099 3.7170000076293945,0"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_769">
      <path d="M0,0 L4,0 L4,7 L0,7z" />
    </clipPath>
    <clipPath id="__lottie_element_800">
      <path d="M0,0 L6,0 L6,4 L0,4z" />
    </clipPath>
    <mask id="__lottie_element_801">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M5.125999927520752,1.7350000143051147 C5.125999927520752,1.7350000143051147 5.120999813079834,3.1519999504089355 5.120999813079834,3.1519999504089355 C5.120999813079834,3.1519999504089355 5.120999813079834,3.132999897003174 5.120999813079834,3.132999897003174 C5.110000133514404,2.674999952316284 4.796999931335449,2.244999885559082 4.23199987411499,1.9179999828338623 C3.0460000038146973,1.2450000047683716 1.1490000486373901,1.2519999742507935 0,1.9329999685287476 C0,1.9329999685287476 0.003000000026077032,0.5139999985694885 0.003000000026077032,0.5139999985694885 C1.1540000438690186,-0.16599999368190765 3.052000045776367,-0.1720000058412552 4.236000061035156,0.5009999871253967 C4.801000118255615,0.828000009059906 5.114999771118164,1.2580000162124634 5.125999927520752,1.715999960899353 C5.125999927520752,1.715999960899353 5.125999927520752,1.7350000143051147 5.125999927520752,1.7350000143051147"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_804">
      <path d="M0,0 L6,0 L6,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_844">
      <path d="M0,0 L2,0 L2,5 L0,5z" />
    </clipPath>
    <mask id="__lottie_element_845">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M1.909000039100647,0 C1.909000039100647,0 1.906000018119812,1.4170000553131104 1.906000018119812,1.4170000553131104 C1.902999997138977,2.4179999828338623 1.2100000381469727,3.3970000743865967 0,4.110000133514404 C0,4.110000133514404 0.003000000026077032,2.691999912261963 0.003000000026077032,2.691999912261963 C1.2139999866485596,1.9789999723434448 1.906000018119812,1.0010000467300415 1.909000039100647,0"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_848">
      <path d="M0,0 L2,0 L2,5 L0,5z" />
    </clipPath>
    <clipPath id="__lottie_element_879">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <mask id="__lottie_element_880">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,1.4190000295639038 C0,1.4190000295639038 0.004999999888241291,0 0.004999999888241291,0 C0.003000000026077032,0.27799999713897705 0.1889999955892563,0.5569999814033508 0.5590000152587891,0.7689999938011169 C1.2869999408721924,1.1820000410079956 2.4489998817443848,1.1779999732971191 3.1610000133514404,0.7580000162124634 C3.1610000133514404,0.7580000162124634 3.1579999923706055,2.177000045776367 3.1579999923706055,2.177000045776367 C2.446000099182129,2.5950000286102295 1.281999945640564,2.6010000705718994 0.5540000200271606,2.187999963760376 C0.1850000023841858,1.9739999771118164 0,1.6950000524520874 0,1.4190000295639038"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_883">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <clipPath id="__lottie_element_923">
      <path d="M0,0 L2,0 L2,4 L0,4z" />
    </clipPath>
    <mask id="__lottie_element_924">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,3.9079999923706055 C0,3.9079999923706055 0.004999999888241291,2.490999937057495 0.004999999888241291,2.490999937057495 C0.00800000037997961,1.590999960899353 0.5920000076293945,0.6909999847412109 1.7599999904632568,0 C1.7599999904632568,0 1.7569999694824219,1.4190000295639038 1.7569999694824219,1.4190000295639038 C0.5870000123977661,2.1080000400543213 0.003000000026077032,3.007999897003174 0,3.9079999923706055"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_927">
      <path d="M0,0 L2,0 L2,4 L0,4z" />
    </clipPath>
    <clipPath id="__lottie_element_958">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <mask id="__lottie_element_959">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.003000000026077032,0.27799999713897705 0.1860000044107437,0.5540000200271606 0.5550000071525574,0.7680000066757202 C1.2829999923706055,1.180999994277954 2.4519999027252197,1.1779999732971191 3.1619999408721924,0.7580000162124634 C3.1619999408721924,0.7580000162124634 3.1579999923706055,2.174999952316284 3.1579999923706055,2.174999952316284 C2.446000099182129,2.5950000286102295 1.2799999713897705,2.5980000495910645 0.5519999861717224,2.184999942779541 C0.18299999833106995,1.9730000495910645 -0.0020000000949949026,1.6950000524520874 0,1.4190000295639038"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_962">
      <path d="M0,0 L4,0 L4,3 L0,3z" />
    </clipPath>
    <clipPath id="__lottie_element_1002">
      <path d="M0,0 L17,0 L17,8 L0,8z" />
    </clipPath>
    <mask id="__lottie_element_1003">
      <path
        fill="#ffffff"
        clipRule="nonzero"
        d=" M0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0,1.4809999465942383 0.9829999804496765,2.9670000076293945 2.9539999961853027,4.105000019073486 C4.835999965667725,5.176000118255615 7.317999839782715,5.757999897003174 9.954000473022461,5.747000217437744 C12.583999633789062,5.736000061035156 15.04800033569336,5.13100004196167 16.88800048828125,4.046000003814697 C16.88800048828125,4.046000003814697 16.882999420166016,5.4629998207092285 16.882999420166016,5.4629998207092285 C15.043999671936035,6.547999858856201 12.581000328063965,7.1539998054504395 9.949000358581543,7.164000034332275 C7.313000202178955,7.175000190734863 4.830999851226807,6.5929999351501465 2.9489998817443848,5.521999835968018 C0.9779999852180481,4.383999824523926 -0.004999999888241291,2.8980000019073486 0,1.4170000553131104"
        fillOpacity={1}
      />
    </mask>
    <clipPath id="__lottie_element_1006">
      <path d="M0,0 L17,0 L17,8 L0,8z" />
    </clipPath>
    <clipPath id="__lottie_element_1811">
      <path d="M0,0 L360,0 L360,360 L0,360z" />
    </clipPath>
    <clipPath id="__lottie_element_1815">
      <path d="M0,0 L360,0 L360,360 L0,360z" />
    </clipPath>
  </defs>
  <g clipPath="url(#__lottie_element_35)">
    <g
      clipPath="url(#__lottie_element_37)"
      transform="matrix(1.0994752645492554,0,0,1.0994752645492554,17.597198486328125,444.4732666015625)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        transform="matrix(1,0,0,1,0,0)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,228,227)"
            fillOpacity={1}
            d=" M278.70001220703125,94.61599731445312 C278.70001220703125,94.61599731445312 114.71199798583984,0 114.71199798583984,0 C114.71199798583984,0 0,66.27799987792969 0,66.27799987792969 C0,66.27799987792969 163.89199829101562,160.8990020751953 163.89199829101562,160.8990020751953 C163.89199829101562,160.8990020751953 278.70001220703125,94.61599731445312 278.70001220703125,94.61599731445312z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,144.8330078125,113.89799499511719)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,101,131)"
            fillOpacity={1}
            d=" M0,9.322999954223633 C0,14.470999717712402 8.060999870300293,18.64699935913086 18.0049991607666,18.64699935913086 C27.947999954223633,18.64699935913086 36.00899887084961,14.470999717712402 36.00899887084961,9.322999954223633 C36.00899887084961,4.172999858856201 27.947999954223633,0 18.0049991607666,0 C8.060999870300293,0 0,4.172999858856201 0,9.322999954223633z"
          />
        </g>
      </g>
      <g
        clipPath="url(#__lottie_element_81)"
        transform="matrix(1,0,0,1,33.16400146484375,18.11499786376953)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g mask="url(#__lottie_element_82)">
          <g
            transform="matrix(0.8632898926734924,-0.504708468914032,0.504708468914032,0.8632898926734924,41.66699981689453,23.736000061035156)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M47.02899932861328,-2.114000082015991 C47.02899932861328,-2.114000082015991 47.02899932861328,2.114000082015991 47.02899932861328,2.114000082015991 C47.02899932861328,2.114000082015991 -47.02899932861328,2.114000082015991 -47.02899932861328,2.114000082015991 C-47.02899932861328,2.114000082015991 -47.02899932861328,-2.114000082015991 -47.02899932861328,-2.114000082015991 C-47.02899932861328,-2.114000082015991 47.02899932861328,-2.114000082015991 47.02899932861328,-2.114000082015991z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,41.66699981689453,23.736000061035156)"
            opacity={1}
            style={{ display: "block" }}
          />
          <g
            transform="matrix(0.8682507872581482,-0.49612557888031006,0.49612557888031006,0.8682507872581482,57.59400177001953,33.729000091552734)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M47.84049987792969,-2.1135001182556152 C47.84049987792969,-2.1135001182556152 47.84049987792969,2.1135001182556152 47.84049987792969,2.1135001182556152 C47.84049987792969,2.1135001182556152 -47.84049987792969,2.1135001182556152 -47.84049987792969,2.1135001182556152 C-47.84049987792969,2.1135001182556152 -47.84049987792969,-2.1135001182556152 -47.84049987792969,-2.1135001182556152 C-47.84049987792969,-2.1135001182556152 47.84049987792969,-2.1135001182556152 47.84049987792969,-2.1135001182556152z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,57.59400177001953,33.729000091552734)"
            opacity={1}
            style={{ display: "block" }}
          />
          <g
            transform="matrix(0.8738910555839539,-0.48612186312675476,0.48612186312675476,0.8738910555839539,73.30500030517578,42.7859992980957)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M46.897499084472656,-2.114000082015991 C46.897499084472656,-2.114000082015991 46.897499084472656,2.114000082015991 46.897499084472656,2.114000082015991 C46.897499084472656,2.114000082015991 -46.897499084472656,2.114000082015991 -46.897499084472656,2.114000082015991 C-46.897499084472656,2.114000082015991 -46.897499084472656,-2.114000082015991 -46.897499084472656,-2.114000082015991 C-46.897499084472656,-2.114000082015991 46.897499084472656,-2.114000082015991 46.897499084472656,-2.114000082015991z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,73.30500030517578,42.7859992980957)"
            opacity={1}
            style={{ display: "block" }}
          />
          <g
            transform="matrix(0.8690635561943054,-0.49470046162605286,0.49470046162605286,0.8690635561943054,91.01100158691406,51.84199905395508)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M46.71649932861328,-2.114000082015991 C46.71649932861328,-2.114000082015991 46.71649932861328,2.114000082015991 46.71649932861328,2.114000082015991 C46.71649932861328,2.114000082015991 -46.71649932861328,2.114000082015991 -46.71649932861328,2.114000082015991 C-46.71649932861328,2.114000082015991 -46.71649932861328,-2.114000082015991 -46.71649932861328,-2.114000082015991 C-46.71649932861328,-2.114000082015991 46.71649932861328,-2.114000082015991 46.71649932861328,-2.114000082015991z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,91.01100158691406,51.84199905395508)"
            opacity={1}
            style={{ display: "block" }}
          />
          <g
            transform="matrix(0.8648011088371277,-0.5021145939826965,0.5021145939826965,0.8648011088371277,106.16699981689453,61.941001892089844)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M47.479000091552734,-2.114000082015991 C47.479000091552734,-2.114000082015991 47.479000091552734,2.114000082015991 47.479000091552734,2.114000082015991 C47.479000091552734,2.114000082015991 -47.479000091552734,2.114000082015991 -47.479000091552734,2.114000082015991 C-47.479000091552734,2.114000082015991 -47.479000091552734,-2.114000082015991 -47.479000091552734,-2.114000082015991 C-47.479000091552734,-2.114000082015991 47.479000091552734,-2.114000082015991 47.479000091552734,-2.114000082015991z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,106.16699981689453,61.941001892089844)"
            opacity={1}
            style={{ display: "block" }}
          />
          <g
            transform="matrix(0.8632986545562744,-0.5046933889389038,0.5046933889389038,0.8632986545562744,122.24099731445312,71.83100128173828)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(35,55,77)"
                fillOpacity={1}
                d=" M47.02949905395508,-2.1135001182556152 C47.02949905395508,-2.1135001182556152 47.02949905395508,2.1135001182556152 47.02949905395508,2.1135001182556152 C47.02949905395508,2.1135001182556152 -47.02949905395508,2.1135001182556152 -47.02949905395508,2.1135001182556152 C-47.02949905395508,2.1135001182556152 -47.02949905395508,-2.1135001182556152 -47.02949905395508,-2.1135001182556152 C-47.02949905395508,-2.1135001182556152 47.02949905395508,-2.1135001182556152 47.02949905395508,-2.1135001182556152z"
              />
            </g>
          </g>
          <g
            transform="matrix(1,0,0,1,122.24099731445312,71.83100128173828)"
            opacity={1}
            style={{ display: "block" }}
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,115.16400146484375,66.11499786376953)"
        opacity={1}
        style={{ display: "block" }}
      />
      <g
        transform="matrix(1,0,0,1,139.35000610351562,80.44999694824219)"
        opacity={1}
        style={{ display: "block" }}
      />
    </g>
    <g
      clipPath="url(#__lottie_element_41)"
      transform="matrix(1,0,0,1,171.63900756835938,236.17999267578125)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        clipPath="url(#__lottie_element_121)"
        transform="matrix(1,0,0,1,0,0)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          transform="matrix(1,0,0,1,0,93.38600158691406)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M284.87799072265625,92.54299926757812 C284.87799072265625,92.54299926757812 295.7179870605469,84.6500015258789 295.7179870605469,84.6500015258789 C295.7179870605469,84.6500015258789 295.010009765625,64.19000244140625 295.010009765625,64.19000244140625 C295.010009765625,64.19000244140625 124.63400268554688,0 124.63400268554688,0 C124.63400268554688,0 0,71.95700073242188 0,71.95700073242188 C0,71.95700073242188 160.24400329589844,164.46499633789062 160.24400329589844,164.46499633789062 C160.24400329589844,164.46499633789062 284.87799072265625,92.54299926757812 284.87799072265625,92.54299926757812z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0.22699737548828125,164.8389892578125)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M160.2429962158203,102.78700256347656 C160.2429962158203,102.78700256347656 0,10.279000282287598 0,10.279000282287598 C0,10.279000282287598 0,0 0,0 C0,0 160.2429962158203,92.50800323486328 160.2429962158203,92.50800323486328 C160.2429962158203,92.50800323486328 160.2429962158203,102.78700256347656 160.2429962158203,102.78700256347656z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0.2270050048828125,51.5)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M0,71.96099853515625 C0,71.96099853515625 160.2429962158203,164.46299743652344 160.2429962158203,164.46299743652344 C160.2429962158203,164.46299743652344 284.8789978027344,92.54199981689453 284.8789978027344,92.54199981689453 C284.8789978027344,92.54199981689453 124.63600158691406,0 124.63600158691406,0 C124.63600158691406,0 0,71.96099853515625 0,71.96099853515625z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,285.10498046875,144.04299926757812)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M2.815000057220459,1.031000018119812 C2.815000057220459,1.031000018119812 0.0020000000949949026,0 0.0020000000949949026,0 C0.0020000000949949026,0 0,10.246000289916992 0,10.246000289916992 C0,10.246000289916992 0,10.246000289916992 0,10.246000289916992 C9.159000396728516,13.675999641418457 12.37399959564209,30.79400062561035 3.572000026702881,38.63600158691406 C3.572000026702881,38.63600158691406 0,41.38199996948242 0,41.38199996948242 C0,41.38199996948242 0,51.625 0,51.625 C0,51.625 2.438999891281128,50.39099884033203 7.567999839782715,46.24300003051758 C20.513999938964844,35.779998779296875 17.160999298095703,6.2829999923706055 2.815000057220459,1.031000018119812z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,14.343002319335938,139.6840057373047)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,255,255)"
              fillOpacity={1}
              d=" M269.9159851074219,9.984000205993652 C269.9159851074219,9.984000205993652 247.53500366210938,25.040000915527344 247.53500366210938,25.040000915527344 C247.53500366210938,25.040000915527344 144.822998046875,83.60600280761719 144.822998046875,83.60600280761719 C144.822998046875,83.60600280761719 0,0 0,0 C0,0 0,28.108999252319336 0,28.108999252319336 C0,28.108999252319336 144.822998046875,111.71399688720703 144.822998046875,111.71399688720703 C144.822998046875,111.71399688720703 269.9159851074219,39.766998291015625 269.9159851074219,39.766998291015625 C269.9159851074219,39.766998291015625 269.9159851074219,9.984000205993652 269.9159851074219,9.984000205993652z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,160.58399963378906,149.66799926757812)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(235,239,255)"
              fillOpacity={1}
              d=" M0,100.91500091552734 C0,100.91500091552734 123.67500305175781,29.784000396728516 123.67500305175781,29.784000396728516 C123.67500305175781,29.784000396728516 123.67500305175781,0 123.67500305175781,0 C123.67500305175781,0 101.29399871826172,15.055999755859375 101.29399871826172,15.055999755859375 C101.29399871826172,15.055999755859375 0.4729999899864197,72.54399871826172 0.4729999899864197,72.54399871826172 C0.4729999899864197,72.54399871826172 0,100.91500091552734 0,100.91500091552734z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,160.4709930419922,185.42498779296875)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M124.63400268554688,10.244000434875488 C124.63400268554688,10.244000434875488 0,82.20099639892578 0,82.20099639892578 C0,82.20099639892578 0,71.9219970703125 0,71.9219970703125 C0,71.9219970703125 124.63400268554688,0 124.63400268554688,0 C124.63400268554688,0 124.63400268554688,10.244000434875488 124.63400268554688,10.244000434875488z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,160.4709930419922,144.04400634765625)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(82,138,163)"
              fillOpacity={1}
              d=" M124.63400268554688,10.244000434875488 C124.63400268554688,10.244000434875488 0,82.20099639892578 0,82.20099639892578 C0,82.20099639892578 0,71.9219970703125 0,71.9219970703125 C0,71.9219970703125 124.63400268554688,0 124.63400268554688,0 C124.63400268554688,0 124.63400268554688,10.244000434875488 124.63400268554688,10.244000434875488z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0.22699737548828125,123.45799255371094)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(235,239,255)"
              fillOpacity={1}
              d=" M160.2429962158203,102.78600311279297 C160.2429962158203,102.78600311279297 0,10.277999877929688 0,10.277999877929688 C0,10.277999877929688 0,0 0,0 C0,0 160.2429962158203,92.50800323486328 160.2429962158203,92.50800323486328 C160.2429962158203,92.50800323486328 160.2429962158203,102.78600311279297 160.2429962158203,102.78600311279297z"
            />
          </g>
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,186.1699981689453,211.52200317382812)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(241,114,129)"
            fillOpacity={1}
            d=" M0,8.064000129699707 C0,8.064000129699707 0,40.2239990234375 0,40.2239990234375 C0,40.2239990234375 8.387999534606934,26.339000701904297 8.387999534606934,26.339000701904297 C8.387999534606934,26.339000701904297 15.279000282287598,30.937000274658203 15.279000282287598,30.937000274658203 C15.279000282287598,30.937000274658203 14.430000305175781,0 14.430000305175781,0 C14.430000305175781,0 0,8.064000129699707 0,8.064000129699707z"
          />
        </g>
      </g>
    </g>
    <g
      clipPath="url(#__lottie_element_45)"
      transform="matrix(1,0,0,1,465,418.5)"
      opacity="0.9999998991296903"
      style={{ display: "block" }}
    >
      <g
        transform="matrix(1,0,0,1,0,0)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(35,55,77)"
            fillOpacity={1}
            d=" M134.0959930419922,10.262999534606934 C164.9199981689453,23.947999954223633 165.08299255371094,46.132999420166016 134.46499633789062,59.816001892089844 C103.84700012207031,73.4990005493164 54.04100036621094,73.50299835205078 23.216999053955078,59.816001892089844 C-7.599999904632568,46.132999420166016 -7.756999969482422,23.945999145507812 22.858999252319336,10.262999534606934 C53.47700119018555,-3.4200000762939453 103.27899932861328,-3.4200000762939453 134.0959930419922,10.262999534606934z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,78.66100311279297,35.040000915527344)"
        opacity={1}
        style={{ display: "block" }}
      />
    </g>
    <g
      clipPath="url(#__lottie_element_1811)"
      transform="matrix(1,0,0,1,127.59185791015625,147.2550048828125)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        clipPath="url(#__lottie_element_1815)"
        transform="matrix(1,0,0,1,7,17)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          transform="matrix(1,0,0,1,49.989990234375,120.84600830078125)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(208,152,69)"
              fillOpacity={1}
              d=" M9.664999961853027,82.51100158691406 C9.664999961853027,82.51100158691406 0,75.4739990234375 0,75.4739990234375 C0,75.4739990234375 0.6309999823570251,57.23099899291992 0.6309999823570251,57.23099899291992 C0.6309999823570251,57.23099899291992 152.53700256347656,0 152.53700256347656,0 C152.53700256347656,0 263.6600036621094,64.15699768066406 263.6600036621094,64.15699768066406 C263.6600036621094,64.15699768066406 120.78800201416016,146.63600158691406 120.78800201416016,146.63600158691406 C120.78800201416016,146.63600158691406 9.664999961853027,82.51100158691406 9.664999961853027,82.51100158691406z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,170.5749969482422,184.552001953125)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M0,91.64299774169922 C0,91.64299774169922 142.8719940185547,9.163999557495117 142.8719940185547,9.163999557495117 C142.8719940185547,9.163999557495117 142.8719940185547,0 142.8719940185547,0 C142.8719940185547,0 0,82.47899627685547 0,82.47899627685547 C0,82.47899627685547 0,91.64299774169922 0,91.64299774169922z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,59.451995849609375,83.50000762939453)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,199,105)"
              fillOpacity={1}
              d=" M253.99600219726562,64.16000366210938 C253.99600219726562,64.16000366210938 111.1240005493164,146.63400268554688 111.1240005493164,146.63400268554688 C111.1240005493164,146.63400268554688 0,82.51000213623047 0,82.51000213623047 C0,82.51000213623047 142.8719940185547,0 142.8719940185547,0 C142.8719940185547,0 253.99600219726562,64.16000366210938 253.99600219726562,64.16000366210938z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,45.5,166.01100158691406)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(246,204,140)"
              fillOpacity={1}
              d=" M11.442999839782715,0.9190000295639038 C11.442999839782715,0.9190000295639038 13.95199966430664,0 13.95199966430664,0 C13.95199966430664,0 13.95199966430664,9.135000228881836 13.95199966430664,9.135000228881836 C13.95199966430664,9.135000228881836 13.95199966430664,9.135000228881836 13.95199966430664,9.135000228881836 C5.7870001792907715,12.192999839782715 2.9210000038146973,27.454999923706055 10.770000457763672,34.448001861572266 C10.770000457763672,34.448001861572266 13.95199966430664,36.895999908447266 13.95199966430664,36.895999908447266 C13.95199966430664,36.895999908447266 13.95199966430664,46.029998779296875 13.95199966430664,46.029998779296875 C13.95199966430664,46.029998779296875 11.779999732971191,44.92900085449219 7.203999996185303,41.23099899291992 C-4.3379998207092285,31.902999877929688 -1.347000002861023,5.60099983215332 11.442999839782715,0.9190000295639038z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,60.206993103027344,162.125)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,255,255)"
              fillOpacity={1}
              d=" M0,8.901000022888184 C0,8.901000022888184 19.954999923706055,22.326000213623047 19.954999923706055,22.326000213623047 C19.954999923706055,22.326000213623047 111.53199768066406,74.54199981689453 111.53199768066406,74.54199981689453 C111.53199768066406,74.54199981689453 240.65499877929688,0 240.65499877929688,0 C240.65499877929688,0 240.65499877929688,25.062000274658203 240.65499877929688,25.062000274658203 C240.65499877929688,25.062000274658203 111.53199768066406,99.60399627685547 111.53199768066406,99.60399627685547 C111.53199768066406,99.60399627685547 0,35.45600128173828 0,35.45600128173828 C0,35.45600128173828 0,8.901000022888184 0,8.901000022888184z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,60.207000732421875,171.0260009765625)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(235,239,255)"
              fillOpacity={1}
              d=" M110.26799774169922,89.9749984741211 C110.26799774169922,89.9749984741211 0,26.55500030517578 0,26.55500030517578 C0,26.55500030517578 0,0 0,0 C0,0 19.954999923706055,13.423999786376953 19.954999923706055,13.423999786376953 C19.954999923706055,13.423999786376953 109.84600067138672,64.67900085449219 109.84600067138672,64.67900085449219 C109.84600067138672,64.67900085449219 110.26799774169922,89.9749984741211 110.26799774169922,89.9749984741211z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,179.5749969482422,179.84800720214844)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          transform="matrix(1,0,0,1,59.4530029296875,202.906005859375)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(246,204,140)"
              fillOpacity={1}
              d=" M0,9.133000373840332 C0,9.133000373840332 111.12300109863281,73.28900146484375 111.12300109863281,73.28900146484375 C111.12300109863281,73.28900146484375 111.12300109863281,64.125 111.12300109863281,64.125 C111.12300109863281,64.125 0,0 0,0 C0,0 0,9.133000373840332 0,9.133000373840332z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,59.4530029296875,166.0120086669922)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(246,204,140)"
              fillOpacity={1}
              d=" M0,9.133000373840332 C0,9.133000373840332 111.12300109863281,73.28900146484375 111.12300109863281,73.28900146484375 C111.12300109863281,73.28900146484375 111.12300109863281,64.125 111.12300109863281,64.125 C111.12300109863281,64.125 0,0 0,0 C0,0 0,9.133000373840332 0,9.133000373840332z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,170.5749969482422,147.6580047607422)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M0,91.64299774169922 C0,91.64299774169922 142.8719940185547,9.163999557495117 142.8719940185547,9.163999557495117 C142.8719940185547,9.163999557495117 142.8719940185547,0 142.8719940185547,0 C142.8719940185547,0 0,82.47899627685547 0,82.47899627685547 C0,82.47899627685547 0,91.64299774169922 0,91.64299774169922z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,179.5749969482422,179.84800720214844)"
          opacity={1}
          style={{ display: "block" }}
        />
      </g>
    </g>
    <g
      clipPath="url(#__lottie_element_49)"
      transform="matrix(1,0,0,1,340.8389892578125,64.14999389648438)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        transform="matrix(1,0,0,1,157.26800537109375,439.26800537109375)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,255,255)"
            fillOpacity={1}
            d=" M63.027000427246094,2.6589999198913574 C66.10399627685547,4.434999942779541 67.77999877929688,6.730000019073486 67.82599639892578,9.180000305175781 C67.87100219726562,11.64900016784668 66.25399780273438,13.979000091552734 63.268001556396484,15.73799991607666 C63.268001556396484,15.73799991607666 34.132999420166016,32.917999267578125 34.132999420166016,32.917999267578125 C33.2599983215332,33.43299865722656 31.82699966430664,33.43600082397461 30.933000564575195,32.92900085449219 C30.041000366210938,32.41299819946289 30.030000686645508,31.59000015258789 30.899999618530273,31.077999114990234 C30.899999618530273,31.077999114990234 60.03300094604492,13.89799976348877 60.03300094604492,13.89799976348877 C62.16999816894531,12.63700008392334 63.332000732421875,10.965999603271484 63.29800033569336,9.197999954223633 C63.268001556396484,7.446000099182129 62.0629997253418,5.796999931335449 59.915000915527344,4.557000160217285 C57.678001403808594,3.2850000858306885 54.79399871826172,2.6080000400543213 51.736000061035156,2.61899995803833 C48.680999755859375,2.632999897003174 45.823001861572266,3.3359999656677246 43.68299865722656,4.59499979019165 C43.68299865722656,4.59499979019165 6.672999858856201,26.422000885009766 6.672999858856201,26.422000885009766 C3.7669999599456787,28.13800048828125 3.803999900817871,30.905000686645508 6.749000072479248,32.60499954223633 C9.684000015258789,34.270999908447266 14.666000366210938,34.249000549316406 17.496999740600586,32.58100128173828 C17.496999740600586,32.58100128173828 42.35200119018555,17.923999786376953 42.35200119018555,17.923999786376953 C43.02899932861328,17.527000427246094 43.40999984741211,16.97800064086914 43.39899826049805,16.41900062561035 C43.38600158691406,15.857000350952148 43,15.329999923706055 42.30699920654297,14.928999900817871 C40.85200119018555,14.10099983215332 38.52199935913086,14.107999801635742 37.111000061035156,14.944000244140625 C37.111000061035156,14.944000244140625 20.13800048828125,24.95400047302246 20.13800048828125,24.95400047302246 C19.26300048828125,25.469999313354492 17.833999633789062,25.47599983215332 16.941999435424805,24.968000411987305 C16.04800033569336,24.45199966430664 16.033000946044922,23.628000259399414 16.902999877929688,23.11400032043457 C16.902999877929688,23.11400032043457 33.87900161743164,13.102999687194824 33.87900161743164,13.102999687194824 C37.034000396728516,11.241999626159668 42.229000091552734,11.218999862670898 45.45899963378906,13.053000450134277 C47.03900146484375,13.965999603271484 47.89899826049805,15.144000053405762 47.91999816894531,16.402000427246094 C47.944000244140625,17.652000427246094 47.09199905395508,18.87700080871582 45.582000732421875,19.766000747680664 C45.582000732421875,19.766000747680664 20.729999542236328,34.42100143432617 20.729999542236328,34.42100143432617 C18.472000122070312,35.75199890136719 15.446000099182129,36.49599838256836 12.215999603271484,36.5099983215332 C8.979000091552734,36.52399826049805 5.932000160217285,35.80799865722656 3.621000051498413,34.49300003051758 C-1.1460000276565552,31.742000579833984 -1.2059999704360962,27.320999145507812 3.440000057220459,24.582000732421875 C3.440000057220459,24.582000732421875 40.448001861572266,2.755000114440918 40.448001861572266,2.755000114440918 C43.430999755859375,0.9950000047683716 47.42399978637695,0.01600000075995922 51.691001892089844,0 C55.95399856567383,-0.017999999225139618 59.98400115966797,0.9259999990463257 63.027000427246094,2.6589999198913574z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,99.5,82)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(208,35,65)"
            fillOpacity={1}
            d=" M85.43000030517578,41.13600158691406 C85.43000030517578,41.13600158691406 13.199999809265137,0.5070000290870667 13.199999809265137,0.5070000290870667 C12.26200008392334,-0.04800000041723251 11.383000373840332,-0.12999999523162842 10.626999855041504,0.17499999701976776 C10.538000106811523,0.19900000095367432 10.45199966430664,0.2280000001192093 10.366999626159668,0.2619999945163727 C10.279000282287598,0.28600001335144043 10.192999839782715,0.3140000104904175 10.107000350952148,0.3479999899864197 C10.019000053405762,0.37400001287460327 9.932999610900879,0.4000000059604645 9.847999572753906,0.4339999854564667 C9.760000228881836,0.46000000834465027 9.673999786376953,0.4869999885559082 9.588000297546387,0.5220000147819519 C9.5,0.5460000038146973 9.414999961853027,0.5730000138282776 9.329999923706055,0.6079999804496765 C9.241999626159668,0.6320000290870667 9.154999732971191,0.6600000262260437 9.069999694824219,0.6940000057220459 C8.982000350952148,0.7179999947547913 8.895000457763672,0.7459999918937683 8.809000015258789,0.7799999713897705 C8.720999717712402,0.8059999942779541 8.63599967956543,0.8320000171661377 8.550999641418457,0.8659999966621399 C8.463000297546387,0.8920000195503235 8.376999855041504,0.9190000295639038 8.291000366210938,0.9539999961853027 C8.20300006866455,0.9779999852180481 8.116999626159668,1.0049999952316284 8.031999588012695,1.0399999618530273 C7.943999767303467,1.0640000104904175 7.85699987411499,1.093000054359436 7.771999835968018,1.1269999742507935 C7.684000015258789,1.1510000228881836 7.5980000495910645,1.1790000200271606 7.51200008392334,1.2130000591278076 C7.423999786376953,1.2369999885559082 7.3379998207092285,1.2649999856948853 7.252999782562256,1.2990000247955322 C7.164999961853027,1.3229999542236328 7.078999996185303,1.3519999980926514 6.993000030517578,1.3869999647140503 C6.90500020980835,1.4110000133514404 6.820000171661377,1.437999963760376 6.735000133514404,1.4730000495910645 C6.646999835968018,1.496999979019165 6.559999942779541,1.5260000228881836 6.474999904632568,1.559000015258789 C6.38700008392334,1.5829999446868896 6.301000118255615,1.6109999418258667 6.215000152587891,1.6449999809265137 C6.126999855041504,1.6690000295639038 6.040999889373779,1.6970000267028809 5.955999851226807,1.7309999465942383 C5.868000030517578,1.7569999694824219 5.7820000648498535,1.784000039100647 5.696000099182129,1.819000005722046 C5.607999801635742,1.843000054359436 5.521999835968018,1.8700000047683716 5.436999797821045,1.9049999713897705 C5.348999977111816,1.9290000200271606 5.263000011444092,1.9579999446868896 5.177000045776367,1.9919999837875366 C5.089000225067139,2.0160000324249268 5.004000186920166,2.0439999103546143 4.919000148773193,2.078000068664551 C4.829999923706055,2.1019999980926514 4.743000030517578,2.130000114440918 4.658999919891357,2.1640000343322754 C4.571000099182129,2.190000057220459 4.485000133514404,2.2170000076293945 4.400000095367432,2.252000093460083 C4.310999870300293,2.2760000228881836 4.224999904632568,2.302999973297119 4.139999866485596,2.3380000591278076 C4.052000045776367,2.361999988555908 3.9660000801086426,2.390000104904175 3.880000114440918,2.4240000247955322 C3.7920000553131104,2.447999954223633 3.7049999237060547,2.4760000705718994 3.621000051498413,2.509999990463257 C3.5320000648498535,2.5339999198913574 3.446000099182129,2.562000036239624 3.3610000610351562,2.5959999561309814 C3.2730000019073486,2.619999885559082 3.187000036239624,2.6489999294281006 3.1019999980926514,2.684000015258789 C3.013000011444092,2.7079999446868896 2.927000045776367,2.734999895095825 2.8420000076293945,2.7699999809265137 C1.1579999923706055,3.2330000400543213 0,5.541999816894531 0,9.01200008392334 C0,9.01200008392334 0,74.6969985961914 0,74.6969985961914 C0,79.5999984741211 2.306999921798706,84.94400024414062 5.156000137329102,86.63099670410156 C5.156000137329102,86.63099670410156 15.425999641418457,92.71800231933594 15.425999641418457,92.71800231933594 C15.425999641418457,92.71800231933594 15.425999641418457,112.81199645996094 15.425999641418457,112.81199645996094 C15.425999641418457,112.81199645996094 15.6850004196167,112.5790023803711 15.6850004196167,112.5790023803711 C15.6850004196167,112.5790023803711 15.6850004196167,112.7239990234375 15.6850004196167,112.7239990234375 C15.6850004196167,112.7239990234375 15.944999694824219,112.49199676513672 15.944999694824219,112.49199676513672 C15.944999694824219,112.49199676513672 15.944999694824219,112.63800048828125 15.944999694824219,112.63800048828125 C15.944999694824219,112.63800048828125 16.202999114990234,112.40499877929688 16.202999114990234,112.40499877929688 C16.202999114990234,112.40499877929688 16.202999114990234,112.552001953125 16.202999114990234,112.552001953125 C16.202999114990234,112.552001953125 16.464000701904297,112.31900024414062 16.464000701904297,112.31900024414062 C16.464000701904297,112.31900024414062 16.464000701904297,112.46600341796875 16.464000701904297,112.46600341796875 C16.464000701904297,112.46600341796875 16.722000122070312,112.23300170898438 16.722000122070312,112.23300170898438 C16.722000122070312,112.23300170898438 16.722000122070312,112.37999725341797 16.722000122070312,112.37999725341797 C16.722000122070312,112.37999725341797 16.98200035095215,112.14700317382812 16.98200035095215,112.14700317382812 C16.98200035095215,112.14700317382812 16.98200035095215,112.29399871826172 16.98200035095215,112.29399871826172 C16.98200035095215,112.29399871826172 17.242000579833984,112.05899810791016 17.242000579833984,112.05899810791016 C17.242000579833984,112.05899810791016 17.242000579833984,112.20600128173828 17.242000579833984,112.20600128173828 C17.242000579833984,112.20600128173828 17.500999450683594,111.9729995727539 17.500999450683594,111.9729995727539 C17.500999450683594,111.9729995727539 17.500999450683594,112.12000274658203 17.500999450683594,112.12000274658203 C17.500999450683594,112.12000274658203 17.76099967956543,111.88700103759766 17.76099967956543,111.88700103759766 C17.76099967956543,111.88700103759766 17.76099967956543,112.03299713134766 17.76099967956543,112.03299713134766 C17.76099967956543,112.03299713134766 18.020000457763672,111.8010025024414 18.020000457763672,111.8010025024414 C18.020000457763672,111.8010025024414 18.020000457763672,111.9469985961914 18.020000457763672,111.9469985961914 C18.020000457763672,111.9469985961914 18.280000686645508,111.71399688720703 18.280000686645508,111.71399688720703 C18.280000686645508,111.71399688720703 18.280000686645508,111.86100006103516 18.280000686645508,111.86100006103516 C18.280000686645508,111.86100006103516 18.538000106811523,111.62699890136719 18.538000106811523,111.62699890136719 C18.538000106811523,111.62699890136719 18.538000106811523,111.77300262451172 18.538000106811523,111.77300262451172 C18.538000106811523,111.77300262451172 18.79800033569336,111.54000091552734 18.79800033569336,111.54000091552734 C18.79800033569336,111.54000091552734 18.79800033569336,111.68699645996094 18.79800033569336,111.68699645996094 C18.79800033569336,111.68699645996094 19.058000564575195,111.4540023803711 19.058000564575195,111.4540023803711 C19.058000564575195,111.4540023803711 19.058000564575195,111.60099792480469 19.058000564575195,111.60099792480469 C19.058000564575195,111.60099792480469 19.316999435424805,111.36799621582031 19.316999435424805,111.36799621582031 C19.316999435424805,111.36799621582031 19.316999435424805,111.51499938964844 19.316999435424805,111.51499938964844 C19.316999435424805,111.51499938964844 19.57699966430664,111.28199768066406 19.57699966430664,111.28199768066406 C19.57699966430664,111.28199768066406 19.57699966430664,111.427001953125 19.57699966430664,111.427001953125 C19.57699966430664,111.427001953125 19.836000442504883,111.19400024414062 19.836000442504883,111.19400024414062 C19.836000442504883,111.19400024414062 19.836000442504883,111.34100341796875 19.836000442504883,111.34100341796875 C19.836000442504883,111.34100341796875 20.09600067138672,111.10800170898438 20.09600067138672,111.10800170898438 C20.09600067138672,111.10800170898438 20.09600067138672,111.25499725341797 20.09600067138672,111.25499725341797 C20.09600067138672,111.25499725341797 20.356000900268555,111.02200317382812 20.356000900268555,111.02200317382812 C20.356000900268555,111.02200317382812 20.356000900268555,111.16799926757812 20.356000900268555,111.16799926757812 C20.356000900268555,111.16799926757812 20.61400032043457,110.93499755859375 20.61400032043457,110.93499755859375 C20.61400032043457,110.93499755859375 20.61400032043457,111.08200073242188 20.61400032043457,111.08200073242188 C20.61400032043457,111.08200073242188 20.875,110.8489990234375 20.875,110.8489990234375 C20.875,110.8489990234375 20.875,110.99600219726562 20.875,110.99600219726562 C20.875,110.99600219726562 21.132999420166016,110.76300048828125 21.132999420166016,110.76300048828125 C21.132999420166016,110.76300048828125 21.132999420166016,110.90799713134766 21.132999420166016,110.90799713134766 C21.132999420166016,110.90799713134766 21.39299964904785,110.67500305175781 21.39299964904785,110.67500305175781 C21.39299964904785,110.67500305175781 21.39299964904785,110.8219985961914 21.39299964904785,110.8219985961914 C21.39299964904785,110.8219985961914 21.652999877929688,110.58899688720703 21.652999877929688,110.58899688720703 C21.652999877929688,110.58899688720703 21.652999877929688,110.73600006103516 21.652999877929688,110.73600006103516 C21.652999877929688,110.73600006103516 21.91200065612793,110.50299835205078 21.91200065612793,110.50299835205078 C21.91200065612793,110.50299835205078 21.91200065612793,110.6500015258789 21.91200065612793,110.6500015258789 C21.91200065612793,110.6500015258789 22.172000885009766,110.41699981689453 22.172000885009766,110.41699981689453 C22.172000885009766,110.41699981689453 22.172000885009766,110.56400299072266 22.172000885009766,110.56400299072266 C22.172000885009766,110.56400299072266 22.430999755859375,110.3290023803711 22.430999755859375,110.3290023803711 C22.430999755859375,110.3290023803711 22.430999755859375,110.47599792480469 22.430999755859375,110.47599792480469 C22.430999755859375,110.47599792480469 22.69099998474121,110.24299621582031 22.69099998474121,110.24299621582031 C22.69099998474121,110.24299621582031 22.69099998474121,110.38999938964844 22.69099998474121,110.38999938964844 C22.69099998474121,110.38999938964844 22.948999404907227,110.15699768066406 22.948999404907227,110.15699768066406 C22.948999404907227,110.15699768066406 22.948999404907227,110.30400085449219 22.948999404907227,110.30400085449219 C22.948999404907227,110.30400085449219 23.208999633789062,110.07099914550781 23.208999633789062,110.07099914550781 C23.208999633789062,110.07099914550781 23.208999633789062,110.21700286865234 23.208999633789062,110.21700286865234 C23.208999633789062,110.21700286865234 23.469999313354492,109.98400115966797 23.469999313354492,109.98400115966797 C23.469999313354492,109.98400115966797 23.469999313354492,110.13099670410156 23.469999313354492,110.13099670410156 C23.469999313354492,110.13099670410156 31.948999404907227,102.51100158691406 31.948999404907227,102.51100158691406 C31.948999404907227,102.51100158691406 79.18299865722656,127.25900268554688 79.18299865722656,127.25900268554688 C80.12100219726562,127.81600189208984 80.99800109863281,127.89700317382812 81.75599670410156,127.59200286865234 C81.84400177001953,127.56600189208984 81.93000030517578,127.53900146484375 82.01599884033203,127.50399780273438 C82.10399627685547,127.4800033569336 82.18900299072266,127.4520034790039 82.27400207519531,127.41799926757812 C87.44200134277344,125.34300231933594 90.58599853515625,125.43099975585938 90.58599853515625,118.75499725341797 C90.58599853515625,118.75499725341797 90.58599853515625,53.069000244140625 90.58599853515625,53.069000244140625 C90.58599853515625,48.16600036621094 88.2770004272461,42.823001861572266 85.43000030517578,41.13600158691406z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,99.50000762939453,84.67500305175781)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,101,131)"
            fillOpacity={1}
            d=" M79.18299865722656,41.141998291015625 C79.18299865722656,41.141998291015625 5.156000137329102,0.5130000114440918 5.156000137329102,0.5130000114440918 C2.306999921798706,-1.1740000247955322 0,1.4329999685287476 0,6.336999893188477 C0,6.336999893188477 0,72.02200317382812 0,72.02200317382812 C0,76.92500305175781 2.306999921798706,82.26899719238281 5.156000137329102,83.95600128173828 C5.156000137329102,83.95600128173828 15.425000190734863,90.04299926757812 15.425000190734863,90.04299926757812 C15.425000190734863,90.04299926757812 15.425000190734863,110.13700103759766 15.425000190734863,110.13700103759766 C15.425000190734863,110.13700103759766 28.89900016784668,98.0270004272461 28.89900016784668,98.0270004272461 C28.89900016784668,98.0270004272461 79.18299865722656,124.58399963378906 79.18299865722656,124.58399963378906 C82.02999877929688,126.27200317382812 84.33799743652344,123.66500091552734 84.33799743652344,118.76200103759766 C84.33799743652344,118.76200103759766 84.33799743652344,53.07500076293945 84.33799743652344,53.07500076293945 C84.33799743652344,48.172000885009766 82.02999877929688,42.82899856567383 79.18299865722656,41.141998291015625z"
          />
        </g>
      </g>
      <g
        style={{ display: "none" }}
        transform="matrix(1.0768431425094604,0,0,1.0768431425094604,121.21983337402344,169.6508331298828)"
        opacity="0.11089414636706778"
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,255,255)"
            fillOpacity={1}
            d=" M5.418000221252441,6.540999889373779 C5.418000221252441,9.118000030517578 4.204999923706055,10.48799991607666 2.7079999446868896,9.60200023651123 C1.2130000591278076,8.71500015258789 0,5.9070000648498535 0,3.3299999237060547 C0,0.753000020980835 1.2130000591278076,-0.6169999837875366 2.7079999446868896,0.27000001072883606 C4.204999923706055,1.156000018119812 5.418000221252441,3.9649999141693115 5.418000221252441,6.540999889373779z"
          />
        </g>
      </g>
      <g
        style={{ display: "none" }}
        transform="matrix(1.0114177465438843,0,0,1.0114177465438843,137.44407653808594,174.0357666015625)"
        opacity="0.01902948655110862"
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,255,255)"
            fillOpacity={1}
            d=" M5.418000221252441,6.541999816894531 C5.418000221252441,9.119000434875488 4.204999923706055,10.48799991607666 2.7100000381469727,9.60099983215332 C1.2130000591278076,8.71500015258789 0,5.906000137329102 0,3.3289999961853027 C0,0.753000020980835 1.2130000591278076,-0.6169999837875366 2.7100000381469727,0.27000001072883606 C4.204999923706055,1.156999945640564 5.418000221252441,3.9649999141693115 5.418000221252441,6.541999816894531z"
          />
        </g>
      </g>
      <g
        style={{ display: "block" }}
        transform="matrix(1.006696343421936,0,0,1.006696343421936,153.50384521484375,154.1409454345703)"
        opacity="0.011160651723853618"
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,255,255)"
            fillOpacity={1}
            d=" M5.420000076293945,6.540999889373779 C5.420000076293945,9.118000030517578 4.206999778747559,10.48799991607666 2.7100000381469727,9.60200023651123 C1.2130000591278076,8.71500015258789 0,5.9070000648498535 0,3.3299999237060547 C0,0.753000020980835 1.2130000591278076,-0.6169999837875366 2.7100000381469727,0.27000001072883606 C4.206999778747559,1.156000018119812 5.420000076293945,3.9649999141693115 5.420000076293945,6.540999889373779z"
          />
        </g>
      </g>
      <g
        clipPath="url(#__lottie_element_179)"
        transform="matrix(1,0,0,1,99.5,82)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          transform="matrix(0.550000011920929,0,0,0.550000011920929,102.5,234.5)"
          opacity={1}
          style={{ display: "block" }}
        >
          <path
            fill="url(#__lottie_element_185)"
            fillOpacity={1}
            d=" M-42.3489990234375,-69.28199768066406 C-43.266998291015625,-66.6989974975586 -50.119998931884766,-42.683998107910156 -51.034000396728516,-40.099998474121094 C-52.8650016784668,-34.92399978637695 -54.715999603271484,-29.7549991607666 -56.53200149536133,-24.572999954223633 C-60.17300033569336,-14.184000015258789 -63.900001525878906,-3.8239998817443848 -67.5770034790039,6.552000045776367 C-71.25900268554688,16.941999435424805 -74.91699981689453,27.340999603271484 -78.63800048828125,37.71699905395508 C-82.36199951171875,48.10200119018555 -86.03800201416016,58.505001068115234 -89.70600128173828,68.90899658203125 C-93.375,79.31700134277344 -97.12699890136719,89.6969985961914 -100.78700256347656,100.10800170898438 C-101.23500061035156,101.38200378417969 -101.72899627685547,102.64700317382812 -102.14199829101562,103.93299865722656 C-108.8759994506836,123.15699768066406 -99.32599639892578,143.93800354003906 -73.48999786376953,158.85499572753906 C-32.65299987792969,182.43499755859375 33.334999084472656,182.42999267578125 73.89700317382812,158.85499572753906 C99.53800201416016,143.99099731445312 108.875,123.26699829101562 102.00900268554688,104.0770034790039 C102.00900268554688,104.0770034790039 40.54199981689453,-69.48300170898438 40.54199981689453,-69.48300170898438 C40.45199966430664,-69.78299713134766 40.34700012207031,-70.0780029296875 40.22800064086914,-70.36699676513672 C40.1510009765625,-70.63200378417969 40.04899978637695,-70.90499877929688 39.95399856567383,-71.15599822998047 C39.95399856567383,-71.15599822998047 39.95399856567383,-71.25599670410156 39.95399856567383,-71.25599670410156 C39.95399856567383,-86.30599975585938 39.95399856567383,-101.3550033569336 39.95399856567383,-116.40499877929688 C39.95399856567383,-120.58000183105469 39.95399856567383,-124.75499725341797 39.95399856567383,-128.92999267578125 C39.95399856567383,-122.04100036621094 39.95399856567383,-115.1520004272461 39.95399856567383,-108.26300048828125 C39.95399856567383,-107.33000183105469 39.95399856567383,-106.38999938964844 39.95399856567383,-105.45999908447266 C39.95399856567383,-120.31600189208984 39.95399856567383,-135.17300415039062 39.95399856567383,-150.0290069580078 C39.95399856567383,-154.2050018310547 39.95399856567383,-158.3800048828125 39.95399856567383,-162.55599975585938 C40.11399841308594,-167.218994140625 36.1870002746582,-171.91700744628906 28.163999557495117,-175.47999572753906 C12.50100040435791,-182.4340057373047 -12.812000274658203,-182.4340057373047 -28.375999450683594,-175.47999572753906 C-36.30099868774414,-171.94000244140625 -40.1619987487793,-167.2740020751953 -39.983001708984375,-162.63299560546875 C-39.983001708984375,-162.63299560546875 -42.3489990234375,-69.28199768066406 -42.3489990234375,-69.28199768066406z"
          />
        </g>
        <g
          transform="matrix(1,0,0,1,52.77499771118164,234.69000244140625)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,222,167)"
              fillOpacity={1}
              d=" M97.25399780273438,59.487998962402344 C97.22799682617188,59.40999984741211 67.93086242675781,-33.72906494140625 67.93083190917969,-33.81306076049805 C67.92977142333984,-34.09016418457031 67.8983383178711,-62.81293869018555 67.35003662109375,-63.28404235839844 C55.95223617553711,-73.61605072021484 32.111907958984375,-69.06501770019531 29.996013641357422,-62.28510284423828 C30.593517303466797,-62.56318664550781 30.19398307800293,-35.0890998840332 29.99318504333496,-33.347618103027344 C29.983165740966797,-33.26362228393555 1.0049999952316284,59.141998291015625 0.9789999723434448,59.220001220703125 C0.9520000219345093,59.29800033569336 0.9279999732971191,59.375999450683594 0.9020000100135803,59.45600128173828 C-2.1080000400543213,68.427001953125 2.4119999408721924,78.08999633789062 14.45300006866455,85.04199981689453 C33.64699935913086,96.1240005493164 64.66200256347656,96.12100219726562 83.72699737548828,85.04199981689453 C95.6760025024414,78.0979995727539 100.34400177001953,68.45099639892578 97.25399780273438,59.487998962402344z"
            />
          </g>
        </g>
        <g
          transform="matrix(0.5604992508888245,0,0,0.5604992508888245,84.10169982910156,200.85264587402344)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,-64.8239974975586)">
            <path
              fill="rgb(255,196,87)"
              fillOpacity={1}
              d=" M56.73099899291992,4.341000080108643 C69.77100372314453,10.130999565124512 69.83999633789062,19.517000198364258 56.88600158691406,25.30500030517578 C43.933998107910156,31.0939998626709 22.86199951171875,31.094999313354492 9.821999549865723,25.30500030517578 C-3.2149999141693115,19.517000198364258 -3.2820000648498535,10.130999565124512 9.670000076293945,4.341000080108643 C22.624000549316406,-1.4470000267028809 43.69200134277344,-1.4470000267028809 56.73099899291992,4.341000080108643z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,48.624000549316406,144.43899536132812)"
          opacity="0.20927"
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,255,255)"
              fillOpacity={1}
              d=" M18.4060001373291,156.7550048828125 C18.4060001373291,156.7550048828125 47.59199905395508,65.08200073242188 47.59199905395508,65.08200073242188 C47.59199905395508,65.08200073242188 47.59199905395508,8.508000373840332 47.59199905395508,8.508000373840332 C47.59199905395508,8.508000373840332 32.400001525878906,0 32.400001525878906,0 C32.01499938964844,0.7710000276565552 31.812000274658203,1.5570000410079956 31.841999053955078,2.3440001010894775 C31.839000701904297,2.4509999752044678 31.836999893188477,2.559000015258789 31.841999053955078,2.6679999828338623 C31.839000701904297,2.7769999504089355 31.836999893188477,2.884999990463257 31.841999053955078,2.992000102996826 C31.839000701904297,3.1010000705718994 31.836999893188477,3.2090001106262207 31.841999053955078,3.318000078201294 C31.839000701904297,3.4260001182556152 31.836999893188477,3.5329999923706055 31.841999053955078,3.6419999599456787 C31.839000701904297,3.750999927520752 31.836999893188477,3.8589999675750732 31.841999053955078,3.9670000076293945 C31.839000701904297,4.076000213623047 31.836999893188477,4.182000160217285 31.841999053955078,4.290999889373779 C31.839000701904297,4.400000095367432 31.836999893188477,4.507999897003174 31.841999053955078,4.617000102996826 C31.839000701904297,4.723999977111816 31.836999893188477,4.831999778747559 31.841999053955078,4.940999984741211 C31.839000701904297,5.050000190734863 31.836999893188477,5.1579999923706055 31.841999053955078,5.264999866485596 C31.839000701904297,5.374000072479248 31.836999893188477,5.48199987411499 31.841999053955078,5.591000080108643 C31.839000701904297,5.699999809265137 31.836999893188477,5.806000232696533 31.841999053955078,5.914999961853027 C31.839000701904297,6.02400016784668 31.836999893188477,6.131999969482422 31.841999053955078,6.239999771118164 C31.839000701904297,6.348999977111816 31.836999893188477,6.455999851226807 31.841999053955078,6.564000129699707 C31.839000701904297,6.672999858856201 31.836999893188477,6.7820000648498535 31.841999053955078,6.889999866485596 C31.839000701904297,6.997000217437744 31.836999893188477,7.105000019073486 31.841999053955078,7.214000225067139 C31.839000701904297,7.322999954223633 31.836999893188477,7.429999828338623 31.841999053955078,7.539000034332275 C31.839000701904297,7.645999908447266 31.836999893188477,7.754000186920166 31.841999053955078,7.86299991607666 C31.839000701904297,7.9720001220703125 31.836999893188477,8.079000473022461 31.841999053955078,8.187000274658203 C31.839000701904297,8.295999526977539 31.836999893188477,8.404000282287598 31.841999053955078,8.512999534606934 C31.839000701904297,8.621999740600586 31.836999893188477,8.727999687194824 31.841999053955078,8.836999893188477 C31.839000701904297,8.944999694824219 31.836999893188477,9.053000450134277 31.841999053955078,9.161999702453613 C31.839000701904297,9.269000053405762 31.836999893188477,9.378000259399414 31.841999053955078,9.486000061035156 C31.839000701904297,9.595000267028809 31.836999893188477,9.70300006866455 31.841999053955078,9.8100004196167 C31.839000701904297,9.918999671936035 31.836999893188477,10.027000427246094 31.841999053955078,10.13599967956543 C31.839000701904297,10.244000434875488 31.836999893188477,10.352999687194824 31.841999053955078,10.460000038146973 C31.839000701904297,10.569000244140625 31.836999893188477,10.675999641418457 31.841999053955078,10.78499984741211 C31.839000701904297,10.894000053405762 31.836999893188477,11 31.841999053955078,11.109000205993652 C31.839000701904297,11.218000411987305 31.836999893188477,11.326000213623047 31.841999053955078,11.4350004196167 C31.839000701904297,11.541999816894531 31.836999893188477,11.649999618530273 31.841999053955078,11.758999824523926 C31.839000701904297,11.868000030517578 31.836999893188477,11.97599983215332 31.841999053955078,12.083000183105469 C31.839000701904297,12.192000389099121 31.836999893188477,12.298999786376953 31.841999053955078,12.407999992370605 C31.839000701904297,12.517000198364258 31.836999893188477,12.625 31.841999053955078,12.732000350952148 C31.839000701904297,12.84000015258789 31.836999893188477,12.949000358581543 31.841999053955078,13.057999610900879 C31.839000701904297,13.166999816894531 31.836999893188477,13.27299976348877 31.841999053955078,13.381999969482422 C31.839000701904297,13.491000175476074 31.836999893188477,13.597999572753906 31.841999053955078,13.706999778747559 C31.839000701904297,13.814000129699707 31.836999893188477,13.92199993133545 31.841999053955078,14.031000137329102 C31.839000701904297,14.140000343322754 31.836999893188477,14.248000144958496 31.841999053955078,14.357000350952148 C31.839000701904297,14.46399974822998 31.836999893188477,14.571999549865723 31.841999053955078,14.680999755859375 C31.839000701904297,14.789999961853027 31.836999893188477,14.89799976348877 31.841999053955078,15.005000114440918 C31.839000701904297,15.11400032043457 31.836999893188477,15.220999717712402 31.841999053955078,15.329999923706055 C31.839000701904297,15.439000129699707 31.836999893188477,15.545000076293945 31.841999053955078,15.654000282287598 C31.839000701904297,15.762999534606934 31.836999893188477,15.871000289916992 31.841999053955078,15.979999542236328 C31.839000701904297,16.086999893188477 31.836999893188477,16.19499969482422 31.841999053955078,16.304000854492188 C31.839000701904297,16.413000106811523 31.836999893188477,16.520999908447266 31.841999053955078,16.628000259399414 C31.839000701904297,16.73699951171875 31.836999893188477,16.8439998626709 31.841999053955078,16.952999114990234 C31.839000701904297,17.062000274658203 31.836999893188477,17.170000076293945 31.841999053955078,17.277000427246094 C31.839000701904297,17.38599967956543 31.836999893188477,17.493999481201172 31.841999053955078,17.60300064086914 C31.839000701904297,17.709999084472656 31.836999893188477,17.81800079345703 31.841999053955078,17.927000045776367 C31.839000701904297,18.035999298095703 31.836999893188477,18.143999099731445 31.841999053955078,18.253000259399414 C31.839000701904297,18.36199951171875 31.836999893188477,18.468000411987305 31.841999053955078,18.57699966430664 C31.839000701904297,18.68600082397461 31.836999893188477,18.792999267578125 31.841999053955078,18.902000427246094 C31.839000701904297,19.009000778198242 31.836999893188477,19.117000579833984 31.841999053955078,19.22599983215332 C31.839000701904297,19.334999084472656 31.836999893188477,19.44300079345703 31.841999053955078,19.549999237060547 C31.839000701904297,19.659000396728516 31.836999893188477,19.76799964904785 31.841999053955078,19.875999450683594 C31.839000701904297,19.985000610351562 31.836999893188477,20.090999603271484 31.841999053955078,20.200000762939453 C31.839000701904297,20.30900001525879 31.836999893188477,20.416000366210938 31.841999053955078,20.524999618530273 C31.839000701904297,20.632999420166016 31.836999893188477,20.739999771118164 31.841999053955078,20.849000930786133 C31.84000015258789,20.923999786376953 31.841999053955078,20.999000549316406 31.841999053955078,21.073999404907227 C31.836999893188477,20.96500015258789 31.839000701904297,34.27000045776367 31.841999053955078,34.1609992980957 C31.84000015258789,34.236000061035156 31.839000701904297,34.31100082397461 31.841999053955078,34.38600158691406 C31.839000701904297,34.494998931884766 31.836999893188477,34.60100173950195 31.841999053955078,34.709999084472656 C31.839000701904297,34.819000244140625 31.836999893188477,34.92599868774414 31.841999053955078,35.03499984741211 C31.839000701904297,35.141998291015625 31.836999893188477,35.25 31.841999053955078,35.35900115966797 C31.839000701904297,35.46799850463867 31.836999893188477,35.57600021362305 31.841999053955078,35.68299865722656 C31.839000701904297,35.79199981689453 31.836999893188477,35.900001525878906 31.841999053955078,36.00899887084961 C31.839000701904297,36.11800003051758 31.836999893188477,36.2239990234375 31.841999053955078,36.33300018310547 C31.839000701904297,36.44200134277344 31.836999893188477,36.54899978637695 31.841999053955078,36.65800094604492 C31.839000701904297,36.76499938964844 31.836999893188477,36.87300109863281 31.841999053955078,36.981998443603516 C31.839000701904297,37.090999603271484 31.836999893188477,37.19900131225586 31.841999053955078,37.30799865722656 C31.839000701904297,37.415000915527344 31.836999893188477,37.52299880981445 31.841999053955078,37.63199996948242 C31.839000701904297,37.74100112915039 31.836999893188477,37.8489990234375 31.841999053955078,37.95600128173828 C31.839000701904297,38.064998626708984 31.836999893188477,38.172000885009766 31.841999053955078,38.28099822998047 C31.839000701904297,38.38999938964844 31.836999893188477,38.49800109863281 31.841999053955078,38.60499954223633 C31.839000701904297,38.7140007019043 31.836999893188477,38.821998596191406 31.841999053955078,38.930999755859375 C31.839000701904297,39.040000915527344 31.836999893188477,39.145999908447266 31.841999053955078,39.255001068115234 C31.839000701904297,39.36399841308594 31.836999893188477,39.47100067138672 31.841999053955078,39.58000183105469 C31.839000701904297,39.6870002746582 31.836999893188477,39.79499816894531 31.841999053955078,39.90399932861328 C31.839000701904297,40.01300048828125 31.836999893188477,40.12099838256836 31.841999053955078,40.22800064086914 C31.839000701904297,40.33599853515625 31.836999893188477,40.44499969482422 31.841999053955078,40.55400085449219 C31.839000701904297,40.6619987487793 31.836999893188477,40.76900100708008 31.841999053955078,40.87799835205078 C31.839000701904297,40.98699951171875 31.836999893188477,41.095001220703125 31.841999053955078,41.20399856567383 C31.839000701904297,41.3120002746582 31.836999893188477,41.417999267578125 31.841999053955078,41.527000427246094 C31.839000701904297,41.63600158691406 31.836999893188477,41.74399948120117 31.841999053955078,41.85300064086914 C31.839000701904297,41.959999084472656 31.836999893188477,42.06800079345703 31.841999053955078,42.176998138427734 C31.839000701904297,42.2859992980957 31.836999893188477,42.39400100708008 31.841999053955078,42.500999450683594 C31.839000701904297,42.60900115966797 31.836999893188477,42.71799850463867 31.841999053955078,42.82699966430664 C31.839000701904297,42.93600082397461 31.836999893188477,43.04399871826172 31.841999053955078,43.1510009765625 C31.839000701904297,43.25899887084961 31.836999893188477,43.367000579833984 31.841999053955078,43.47600173950195 C31.839000701904297,43.584999084472656 31.836999893188477,43.691001892089844 31.841999053955078,43.79999923706055 C31.839000701904297,43.90800094604492 31.836999893188477,44.016998291015625 31.841999053955078,44.125999450683594 C31.839000701904297,44.233001708984375 31.836999893188477,44.340999603271484 31.841999053955078,44.45000076293945 C31.839000701904297,44.558998107910156 31.836999893188477,44.66699981689453 31.841999053955078,44.77399826049805 C31.839000701904297,44.882999420166016 31.836999893188477,44.9900016784668 31.841999053955078,45.0989990234375 C31.839000701904297,45.20800018310547 31.836999893188477,45.316001892089844 31.841999053955078,45.42300033569336 C31.839000701904297,45.53200149536133 31.836999893188477,45.63999938964844 31.841999053955078,45.749000549316406 C31.839000701904297,45.858001708984375 31.836999893188477,45.9640007019043 31.841999053955078,46.073001861572266 C31.839000701904297,46.18199920654297 31.836999893188477,46.28900146484375 31.841999053955078,46.39799880981445 C31.839000701904297,46.505001068115234 31.836999893188477,46.612998962402344 31.841999053955078,46.72200012207031 C31.839000701904297,46.83100128173828 31.836999893188477,46.93899917602539 31.841999053955078,47.04800033569336 C31.839000701904297,47.154998779296875 31.836999893188477,47.26300048828125 31.841999053955078,47.37200164794922 C31.839000701904297,47.48099899291992 31.836999893188477,47.5890007019043 31.841999053955078,47.69599914550781 C31.839000701904297,47.80500030517578 31.836999893188477,47.9119987487793 31.841999053955078,48.020999908447266 C31.839000701904297,48.130001068115234 31.836999893188477,48.236000061035156 31.841999053955078,48.345001220703125 C31.839000701904297,48.45399856567383 31.836999893188477,48.5620002746582 31.841999053955078,48.67100143432617 C31.839000701904297,48.77799987792969 31.836999893188477,48.88600158691406 31.841999053955078,48.994998931884766 C31.839000701904297,49.104000091552734 31.836999893188477,49.21099853515625 31.841999053955078,49.31999969482422 C31.839000701904297,49.426998138427734 31.836999893188477,49.53499984741211 31.841999053955078,49.64400100708008 C31.839000701904297,49.75299835205078 31.836999893188477,49.861000061035156 31.841999053955078,49.96799850463867 C31.839000701904297,50.07699966430664 31.836999893188477,50.185001373291016 31.841999053955078,50.29399871826172 C31.839000701904297,50.40299987792969 31.836999893188477,50.50899887084961 31.841999053955078,50.61800003051758 C31.839000701904297,50.72700119018555 31.836999893188477,50.83399963378906 31.841999053955078,50.94300079345703 C31.839000701904297,51.051998138427734 31.836999893188477,51.15800094604492 31.841999053955078,51.266998291015625 C31.839000701904297,51.375999450683594 31.836999893188477,51.48400115966797 31.841999053955078,51.59299850463867 C31.839000701904297,51.70000076293945 31.836999893188477,51.80799865722656 31.841999053955078,51.91699981689453 C31.839000701904297,52.0260009765625 31.836999893188477,52.13399887084961 31.841999053955078,52.24100112915039 C31.839000701904297,52.349998474121094 31.836999893188477,52.457000732421875 31.841999053955078,52.566001892089844 C31.839000701904297,52.67499923706055 31.836999893188477,52.78099822998047 31.841999053955078,52.88999938964844 C31.839000701904297,52.999000549316406 31.836999893188477,53.106998443603516 31.841999053955078,53.215999603271484 C31.841999053955078,53.215999603271484 31.84000015258789,53.237998962402344 31.84000015258789,53.237998962402344 C31.7810001373291,53.38800048828125 31.72800064086914,53.5369987487793 31.68199920654297,53.6870002746582 C31.614999771118164,53.849998474121094 31.55699920654297,54.013999938964844 31.507999420166016,54.178001403808594 C31.44099998474121,54.34199905395508 31.381999969482422,54.50699996948242 31.33300018310547,54.67100143432617 C31.26799964904785,54.834999084472656 31.20800018310547,55.000999450683594 31.159000396728516,55.165000915527344 C31.091999053955078,55.32899856567383 31.031999588012695,55.49399948120117 30.982999801635742,55.65800094604492 C30.91699981689453,55.821998596191406 30.857999801635742,55.98699951171875 30.80900001525879,56.1510009765625 C30.742000579833984,56.314998626708984 30.683000564575195,56.47999954223633 30.634000778198242,56.645999908447266 C30.569000244140625,56.810001373291016 30.506999969482422,56.974998474121094 30.45800018310547,57.138999938964844 C30.39299964904785,57.303001403808594 30.33300018310547,57.46799850463867 30.284000396728516,57.63199996948242 C30.216999053955078,57.79600143432617 30.158000946044922,57.96099853515625 30.107999801635742,58.12699890136719 C30.042999267578125,58.290000915527344 29.98200035095215,58.45399856567383 29.933000564575195,58.619998931884766 C29.868000030517578,58.784000396728516 29.808000564575195,58.94900131225586 29.756999969482422,59.1150016784668 C29.700000762939453,59.25899887084961 29.64900016784668,59.404998779296875 29.60300064086914,59.54999923706055 C29.538000106811523,59.7130012512207 29.481000900268555,59.875999450683594 29.43000030517578,60.03900146484375 C29.364999771118164,60.20199966430664 29.30900001525879,60.36399841308594 29.257999420166016,60.527000427246094 C29.19099998474121,60.689998626708984 29.136999130249023,60.85300064086914 29.083999633789062,61.016998291015625 C29.018999099731445,61.178001403808594 28.96299934387207,61.34199905395508 28.91200065612793,61.505001068115234 C28.847000122070312,61.667999267578125 28.790000915527344,61.83100128173828 28.73900032043457,61.99399948120117 C28.673999786376953,62.15700149536133 28.618000030517578,62.319000244140625 28.565000534057617,62.481998443603516 C28.5,62.64500045776367 28.444000244140625,62.80699920654297 28.39299964904785,62.970001220703125 C28.327999114990234,63.132999420166016 28.27199935913086,63.29600143432617 28.2189998626709,63.459999084472656 C28.15399932861328,63.62300109863281 28.100000381469727,63.7859992980957 28.047000885009766,63.94900131225586 C27.98200035095215,64.11199951171875 27.926000595092773,64.2750015258789 27.87299919128418,64.43900299072266 C27.808000564575195,64.60199737548828 27.753000259399414,64.76399993896484 27.700000762939453,64.927001953125 C27.635000228881836,65.08999633789062 27.57900047302246,65.25199890136719 27.525999069213867,65.41500091552734 C27.461000442504883,65.5780029296875 27.406999588012695,65.74199676513672 27.354000091552734,65.90499877929688 C27.288999557495117,66.06800079345703 27.232999801635742,66.23100280761719 27.18000030517578,66.3949966430664 C27.114999771118164,66.55599975585938 27.06100082397461,66.72000122070312 27.007999420166016,66.88300323486328 C26.94300079345703,67.0459976196289 26.886999130249023,67.20899963378906 26.833999633789062,67.37300109863281 C26.768999099731445,67.53600311279297 26.714000701904297,67.6989974975586 26.65999984741211,67.86299896240234 C26.59600067138672,68.0260009765625 26.540000915527344,68.18900299072266 26.48699951171875,68.35199737548828 C26.422000885009766,68.51499938964844 26.365999221801758,68.6780014038086 26.312999725341797,68.84200286865234 C26.24799919128418,69.00499725341797 26.19300079345703,69.16799926757812 26.138999938964844,69.33200073242188 C26.075000762939453,69.49500274658203 26.020000457763672,69.65799713134766 25.966999053955078,69.8219985961914 C25.902000427246094,69.98300170898438 25.84600067138672,70.14700317382812 25.792999267578125,70.30999755859375 C25.72800064086914,70.4729995727539 25.67300033569336,70.63700103759766 25.618999481201172,70.80000305175781 C25.55500030517578,70.96299743652344 25.499000549316406,71.1259994506836 25.44499969482422,71.29000091552734 C25.381000518798828,71.4530029296875 25.326000213623047,71.61599731445312 25.273000717163086,71.77999877929688 C25.20800018310547,71.94300079345703 25.152999877929688,72.10600280761719 25.099000930786133,72.2699966430664 C25.034000396728516,72.43299865722656 24.979000091552734,72.59600067138672 24.924999237060547,72.76000213623047 C24.861000061035156,72.9229965209961 24.80500030517578,73.08599853515625 24.750999450683594,73.25 C24.687000274658203,73.41300201416016 24.631000518798828,73.57599639892578 24.57699966430664,73.73999786376953 C24.51300048828125,73.90299987792969 24.45800018310547,74.06500244140625 24.405000686645508,74.22899627685547 C24.34000015258789,74.39199829101562 24.284000396728516,74.55500030517578 24.231000900268555,74.71900177001953 C24.166000366210938,74.88200378417969 24.111000061035156,75.04499816894531 24.05699920654297,75.20899963378906 C23.993000030517578,75.37200164794922 23.937000274658203,75.53500366210938 23.882999420166016,75.6989974975586 C23.819000244140625,75.86199951171875 23.76300048828125,76.0250015258789 23.708999633789062,76.18900299072266 C23.645000457763672,76.35199737548828 23.589000701904297,76.51599884033203 23.53499984741211,76.67900085449219 C23.47100067138672,76.84200286865234 23.415000915527344,77.00700378417969 23.361000061035156,77.1709976196289 C23.297000885009766,77.33399963378906 23.240999221801758,77.49700164794922 23.187000274658203,77.66100311279297 C23.12299919128418,77.8239974975586 23.066999435424805,77.98699951171875 23.01300048828125,78.1510009765625 C22.948999404907227,78.31400299072266 22.89299964904785,78.47699737548828 22.839000701904297,78.64099884033203 C22.774999618530273,78.80400085449219 22.719999313354492,78.96800231933594 22.66699981689453,79.13099670410156 C22.601999282836914,79.29499816894531 22.54599952697754,79.45800018310547 22.493000030517578,79.62200164794922 C22.429000854492188,79.78500366210938 22.37299919128418,79.947998046875 22.319000244140625,80.11199951171875 C22.2549991607666,80.2750015258789 22.198999404907227,80.43900299072266 22.145000457763672,80.60199737548828 C22.08099937438965,80.76499938964844 22.024999618530273,80.93000030517578 21.97100067138672,81.09400177001953 C21.906999588012695,81.25700378417969 21.85099983215332,81.41899871826172 21.797000885009766,81.58300018310547 C21.732999801635742,81.74600219726562 21.677000045776367,81.91000366210938 21.62299919128418,82.072998046875 C21.55900001525879,82.23600006103516 21.503000259399414,82.4010009765625 21.448999404907227,82.56500244140625 C21.385000228881836,82.72799682617188 21.32900047302246,82.89099884033203 21.274999618530273,83.05500030517578 C21.211000442504883,83.21800231933594 21.155000686645508,83.38200378417969 21.10099983215332,83.54499816894531 C21.03700065612793,83.70899963378906 20.979999542236328,83.87200164794922 20.926000595092773,84.03600311279297 C20.86400032043457,84.1989974975586 20.805999755859375,84.36299896240234 20.75200080871582,84.5260009765625 C20.690000534057617,84.69000244140625 20.631999969482422,84.85399627685547 20.577999114990234,85.01799774169922 C20.516000747680664,85.18099975585938 20.45800018310547,85.34600067138672 20.40399932861328,85.51000213623047 C20.341999053955078,85.6729965209961 20.284000396728516,85.83499908447266 20.229999542236328,85.9990005493164 C20.167999267578125,86.16200256347656 20.110000610351562,86.3270034790039 20.055999755859375,86.49099731445312 C19.993999481201172,86.65399932861328 19.93600082397461,86.81700134277344 19.881999969482422,86.98100280761719 C19.81800079345703,87.1449966430664 19.761999130249023,87.30799865722656 19.70800018310547,87.47200012207031 C19.643999099731445,87.63500213623047 19.58799934387207,87.79900360107422 19.534000396728516,87.96199798583984 C19.469999313354492,88.1259994506836 19.413999557495117,88.29000091552734 19.360000610351562,88.4540023803711 C19.29599952697754,88.61699676513672 19.239999771118164,88.78099822998047 19.18400001525879,88.94400024414062 C19.121999740600586,89.10800170898438 19.06399917602539,89.27300262451172 19.010000228881836,89.43699645996094 C18.947999954223633,89.5999984741211 18.891000747680664,89.76300048828125 18.836999893188477,89.927001953125 C18.774999618530273,90.08999633789062 18.716999053955078,90.25399780273438 18.663000106811523,90.41699981689453 C18.60099983215332,90.58100128173828 18.542999267578125,90.74400329589844 18.48900032043457,90.90799713134766 C18.427000045776367,91.0719985961914 18.368999481201172,91.23600006103516 18.315000534057617,91.4000015258789 C18.253000259399414,91.56300354003906 18.19499969482422,91.72799682617188 18.138999938964844,91.89199829101562 C18.07699966430664,92.05500030517578 18.018999099731445,92.21800231933594 17.96500015258789,92.38099670410156 C17.902999877929688,92.54499816894531 17.844999313354492,92.70899963378906 17.791000366210938,92.87300109863281 C17.729000091552734,93.03700256347656 17.67099952697754,93.20099639892578 17.617000579833984,93.36499786376953 C17.55500030517578,93.52799987792969 17.496999740600586,93.69200134277344 17.44300079345703,93.85600280761719 C17.381000518798828,94.01899719238281 17.322999954223633,94.18399810791016 17.268999099731445,94.3479995727539 C17.207000732421875,94.51100158691406 17.148000717163086,94.67400360107422 17.0939998626709,94.83799743652344 C17.031999588012695,95.00199890136719 16.974000930786133,95.16500091552734 16.920000076293945,95.3290023803711 C16.857999801635742,95.49299621582031 16.799999237060547,95.65699768066406 16.746000289916992,95.82099914550781 C16.68400001525879,95.98400115966797 16.625999450683594,96.14800262451172 16.57200050354004,96.31199645996094 C16.510000228881836,96.4749984741211 16.45199966430664,96.63999938964844 16.395999908447266,96.80400085449219 C16.334999084472656,96.96700286865234 16.275999069213867,97.13099670410156 16.222000122070312,97.29499816894531 C16.160999298095703,97.45800018310547 16.101999282836914,97.62100219726562 16.04800033569336,97.78500366210938 C15.986000061035156,97.9489974975586 15.928999900817871,98.11299896240234 15.875,98.2770004272461 C15.812999725341797,98.44100189208984 15.755000114440918,98.60399627685547 15.701000213623047,98.76799774169922 C15.638999938964844,98.93199920654297 15.579000473022461,99.09600067138672 15.524999618530273,99.26000213623047 C15.46399974822998,99.4229965209961 15.404999732971191,99.58699798583984 15.35099983215332,99.7509994506836 C15.288999557495117,99.91400146484375 15.230999946594238,100.0790023803711 15.177000045776367,100.24299621582031 C15.114999771118164,100.40599822998047 15.057999610900879,100.57099914550781 15.001999855041504,100.73500061035156 C14.940999984741211,100.89800262451172 14.881999969482422,101.06199645996094 14.82800006866455,101.22599792480469 C14.767000198364258,101.38899993896484 14.708000183105469,101.55400085449219 14.654000282287598,101.71800231933594 C14.592000007629395,101.88099670410156 14.534000396728516,102.04499816894531 14.479999542236328,102.20899963378906 C14.418000221252441,102.37200164794922 14.357999801635742,102.53600311279297 14.303999900817871,102.6989974975586 C14.243000030517578,102.86299896240234 14.184000015258789,103.02799987792969 14.130000114440918,103.19200134277344 C14.069000244140625,103.3550033569336 14.010000228881836,103.51899719238281 13.956000328063965,103.68199920654297 C13.894000053405762,103.84600067138672 13.836999893188477,104.01100158691406 13.781000137329102,104.17500305175781 C13.720000267028809,104.33799743652344 13.66100025177002,104.50299835205078 13.607000350952148,104.66699981689453 C13.545999526977539,104.83000183105469 13.487000465393066,104.99400329589844 13.432999610900879,105.15799713134766 C13.371999740600586,105.32099914550781 13.312999725341797,105.48600006103516 13.258999824523926,105.6500015258789 C13.196999549865723,105.81300354003906 13.13700008392334,105.97799682617188 13.083000183105469,106.14199829101562 C13.022000312805176,106.30500030517578 12.963000297546387,106.46900177001953 12.909000396728516,106.63300323486328 C12.847999572753906,106.7969970703125 12.788999557495117,106.96099853515625 12.734999656677246,107.125 C12.673999786376953,107.28800201416016 12.61400032043457,107.4520034790039 12.5600004196167,107.61599731445312 C12.49899959564209,107.77899932861328 12.4399995803833,107.94400024414062 12.38599967956543,108.10800170898438 C12.324999809265137,108.27200317382812 12.265000343322754,108.43499755859375 12.211999893188477,108.5989990234375 C12.151000022888184,108.76300048828125 12.09000015258789,108.927001953125 12.03600025177002,109.09100341796875 C11.975000381469727,109.25499725341797 11.916000366210938,109.41799926757812 11.862000465393066,109.58200073242188 C11.800999641418457,109.74600219726562 11.741999626159668,109.91000366210938 11.687999725341797,110.0739974975586 C11.626999855041504,110.23799896240234 11.567000389099121,110.4020004272461 11.512999534606934,110.56500244140625 C11.45199966430664,110.72899627685547 11.392999649047852,110.8949966430664 11.33899974822998,111.05899810791016 C11.277999877929688,111.22200012207031 11.218000411987305,111.38600158691406 11.164999961853027,111.55000305175781 C11.104000091552734,111.71299743652344 11.043000221252441,111.87799835205078 10.98900032043457,112.04199981689453 C10.928000450134277,112.20600128173828 10.869000434875488,112.36900329589844 10.8149995803833,112.53299713134766 C10.753999710083008,112.6969985961914 10.694000244140625,112.86100006103516 10.640000343322754,113.0250015258789 C10.581000328063965,113.18900299072266 10.520000457763672,113.35399627685547 10.465999603271484,113.51799774169922 C10.404999732971191,113.68099975585938 10.345999717712402,113.84500122070312 10.291999816894531,114.00900268554688 C10.230999946594238,114.1719970703125 10.170999526977539,114.33699798583984 10.116999626159668,114.5009994506836 C10.057999610900879,114.66400146484375 9.996999740600586,114.8280029296875 9.942999839782715,114.99199676513672 C9.881999969482422,115.15599822998047 9.821000099182129,115.31999969482422 9.767000198364258,115.48600006103516 C9.708000183105469,115.64900207519531 9.647000312805176,115.81300354003906 9.593000411987305,115.97599792480469 C9.534000396728516,116.13999938964844 9.472999572753906,116.30500030517578 9.418999671936035,116.46900177001953 C9.357999801635742,116.63200378417969 9.29800033569336,116.7959976196289 9.244000434875488,116.95999908447266 C9.1850004196167,117.1240005493164 9.12399959564209,117.28800201416016 9.069999694824219,117.4520034790039 C9.01099967956543,117.61599731445312 8.949999809265137,117.77899932861328 8.895999908447266,117.94300079345703 C8.835000038146973,118.10700225830078 8.77400016784668,118.27300262451172 8.720000267028809,118.43699645996094 C8.66100025177002,118.5999984741211 8.600000381469727,118.76399993896484 8.545999526977539,118.9280014038086 C8.484999656677246,119.09200286865234 8.425000190734863,119.25599670410156 8.371000289916992,119.41999816894531 C8.312000274658203,119.58399963378906 8.25100040435791,119.74700164794922 8.196999549865723,119.91100311279297 C8.137999534606934,120.07499694824219 8.076000213623047,120.23999786376953 8.02299976348877,120.40399932861328 C7.961999893188477,120.56800079345703 7.901000022888184,120.73200225830078 7.8470001220703125,120.89600372314453 C7.788000106811523,121.05999755859375 7.7270002365112305,121.2229995727539 7.672999858856201,121.38700103759766 C7.613999843597412,121.5510025024414 7.552000045776367,121.71600341796875 7.498000144958496,121.87899780273438 C7.439000129699707,122.04299926757812 7.377999782562256,122.20800018310547 7.323999881744385,122.37200164794922 C7.264999866485596,122.53600311279297 7.203000068664551,122.69999694824219 7.150000095367432,122.86399841308594 C7.089000225067139,123.02799987792969 7.0279998779296875,123.19100189208984 6.973999977111816,123.3550033569336 C6.914999961853027,123.51899719238281 6.854000091552734,123.68399810791016 6.800000190734863,123.8479995727539 C6.741000175476074,124.01100158691406 6.678999900817871,124.1760025024414 6.625,124.33999633789062 C6.565999984741211,124.50399780273438 6.505000114440918,124.66699981689453 6.451000213623047,124.83300018310547 C6.392000198364258,124.99600219726562 6.329999923706055,125.16100311279297 6.2769999504089355,125.32499694824219 C6.216000080108643,125.48899841308594 6.15500020980835,125.6520004272461 6.10099983215332,125.81600189208984 C6.041999816894531,125.9800033569336 5.980000019073486,126.14399719238281 5.927000045776367,126.30799865722656 C5.868000030517578,126.47200012207031 5.806000232696533,126.63700103759766 5.751999855041504,126.8010025024414 C5.692999839782715,126.96499633789062 5.63100004196167,127.12799835205078 5.578000068664551,127.29199981689453 C5.519000053405762,127.45600128173828 5.455999851226807,127.61900329589844 5.4019999504089355,127.78500366210938 C5.3429999351501465,127.947998046875 5.2820000648498535,128.11300659179688 5.228000164031982,128.27699279785156 C5.169000148773193,128.4409942626953 5.10699987411499,128.60499572753906 5.052999973297119,128.7689971923828 C4.994999885559082,128.93299865722656 4.933000087738037,129.09800720214844 4.879000186920166,129.26199340820312 C4.820000171661377,129.42599487304688 4.757999897003174,129.58900451660156 4.704999923706055,129.7530059814453 C4.645999908447266,129.91700744628906 4.583000183105469,130.0800018310547 4.5289998054504395,130.24600219726562 C4.46999979019165,130.40899658203125 4.4079999923706055,130.57400512695312 4.355000019073486,130.73800659179688 C4.296000003814697,130.90199279785156 4.234000205993652,131.06500244140625 4.179999828338623,131.2310028076172 C4.120999813079834,131.3939971923828 4.059000015258789,131.5590057373047 4.00600004196167,131.72300720214844 C3.947000026702881,131.88699340820312 3.884000062942505,132.0500030517578 3.8299999237060547,132.21400451660156 C3.7730000019073486,132.3780059814453 3.7090001106262207,132.54299926757812 3.6559998989105225,132.70700073242188 C3.5969998836517334,132.8699951171875 3.5350000858306885,133.03500366210938 3.4809999465942383,133.19900512695312 C3.4240000247955322,133.36300659179688 3.359999895095825,133.5260009765625 3.306999921798706,133.69000244140625 C3.247999906539917,133.85400390625 3.184999942779541,134.02000427246094 3.13100004196167,134.1840057373047 C3.0739998817443848,134.34800720214844 3.009999990463257,134.51100158691406 2.9570000171661377,134.6750030517578 C2.8980000019073486,134.83900451660156 2.8359999656677246,135.00399780273438 2.7820000648498535,135.16799926757812 C2.7249999046325684,135.33200073242188 2.6619999408721924,135.49600219726562 2.6080000400543213,135.66000366210938 C2.5490000247955322,135.82400512695312 2.486999988555908,135.98899841308594 2.434000015258789,136.1529998779297 C2.375,136.3159942626953 2.312000036239624,136.47999572753906 2.257999897003174,136.6439971923828 C2.1989998817443848,136.80799865722656 2.13700008392334,136.9720001220703 2.0840001106262207,137.13800048828125 C2.0250000953674316,137.30099487304688 1.9630000591278076,137.46499633789062 1.909000039100647,137.62899780273438 C1.8509999513626099,137.79299926757812 1.7879999876022339,137.95799255371094 1.7350000143051147,138.1219940185547 C1.6759999990463257,138.28500366210938 1.6130000352859497,138.4499969482422 1.559000015258789,138.61399841308594 C1.5019999742507935,138.7779998779297 1.437999963760376,138.9409942626953 1.3849999904632568,139.10499572753906 C1.3259999752044678,139.2689971923828 1.2640000581741333,139.4340057373047 1.2100000381469727,139.59800720214844 C1.1519999504089355,139.76199340820312 1.0889999866485596,139.92599487304688 1.0360000133514404,140.08999633789062 C0.9769999980926514,140.25399780273438 0.9139999747276306,140.41900634765625 0.8600000143051147,140.58299255371094 C0.8029999732971191,140.7469940185547 0.7390000224113464,140.91099548339844 0.6859999895095825,141.0749969482422 C0.6269999742507935,141.23899841308594 0.5649999976158142,141.4040069580078 0.5109999775886536,141.5679931640625 C0.45399999618530273,141.73199462890625 0.38999998569488525,141.89500427246094 0.3370000123977661,142.0590057373047 C0.27799999713897705,142.22300720214844 0.2150000035762787,142.38800048828125 0.16099999845027924,142.552001953125 C0.1080000028014183,142.70399475097656 0.050999999046325684,142.85499572753906 0,143.0070037841797 C3.765000104904175,147.56700134277344 9.583999633789062,152.68499755859375 18.4060001373291,156.7550048828125z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,80.45800018310547,136.70999145507812)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(21,40,69)"
              fillOpacity={1}
              d=" M38.00899887084961,2.9089999198913574 C46.744998931884766,6.789000034332275 46.79100036621094,13.074000358581543 38.11199951171875,16.95400047302246 C29.434999465942383,20.832000732421875 15.317999839782715,20.833999633789062 6.579999923706055,16.95400047302246 C-2.1540000438690186,13.076000213623047 -2.1989998817443848,6.7870001792907715 6.480000019073486,2.9089999198913574 C15.159000396728516,-0.968999981880188 29.274999618530273,-0.968999981880188 38.00899887084961,2.9089999198913574z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,80.5,198)"
          opacity={1}
          style={{ display: "block" }}
        >
          <path
            fill="url(#__lottie_element_201)"
            fillOpacity={1}
            d=" M34.59299850463867,-49.176998138427734 C27.816999435424805,-46.143001556396484 16.32200050354004,-46.143001556396484 9.493000030517578,-49.176998138427734 C7.197999954223633,-50.194000244140625 6.349999904632568,-51.16400146484375 6.170000076293945,-51.525001525878906 C6.170000076293945,-51.525001525878906 6.177999973297119,-51.5260009765625 6.177999973297119,-51.5260009765625 C6.355999946594238,-51.87900161743164 7.185999870300293,-52.82600021362305 9.406999588012695,-53.823001861572266 C16.18600082397461,-56.856998443603516 27.680999755859375,-56.85499954223633 34.50699996948242,-53.823001861572266 C36.801998138427734,-52.80500030517578 37.6510009765625,-51.83399963378906 37.83100128173828,-51.47200012207031 C37.652000427246094,-51.11800003051758 36.821998596191406,-50.176998138427734 34.59299850463867,-49.176998138427734z M38.12799835205078,-62.266998291015625 C29.0310001373291,-66.31300354003906 14.817000389099121,-66.31099700927734 5.76800012588501,-62.266998291015625 C-1.6779999732971191,-58.941001892089844 -2.7829999923706055,-54.30400085449219 -2.7790000438690186,-51.8120002746582 C-2.7750000953674316,-49.31999969482422 -1.6469999551773071,-44.6510009765625 5.868000030517578,-41.3120002746582 C11.008999824523926,-39.22100067138672 16.518999099731445,-38.189998626708984 22.06800079345703,-38.28300094604492 C27.60700035095215,-38.1870002746582 33.108001708984375,-39.21699905395508 38.236000061035156,-41.3120002746582 C45.68000030517578,-44.63800048828125 46.78200149536133,-49.277000427246094 46.77899932861328,-51.766998291015625 C46.7760009765625,-54.25699996948242 45.64799880981445,-58.928001403808594 38.12799835205078,-62.266998291015625z"
          />
        </g>
        <g
          transform="matrix(1,0,0,1,108.38200378417969,123.15800476074219)"
          opacity="0.8950000000000017"
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(233,189,111)"
              fillOpacity={1}
              d=" M7.6479997634887695,3.8239998817443848 C7.6479997634887695,5.936999797821045 5.935999870300293,7.64900016784668 3.8239998817443848,7.64900016784668 C1.7130000591278076,7.64900016784668 0,5.936999797821045 0,3.8239998817443848 C0,1.7130000591278076 1.7130000591278076,0 3.8239998817443848,0 C5.935999870300293,0 7.6479997634887695,1.7130000591278076 7.6479997634887695,3.8239998817443848z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,90.10000610351562,125.77000427246094)"
          opacity="0.9936666666667882"
          style={{ display: "none" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(233,189,111)"
              fillOpacity={1}
              d=" M7.6479997634887695,3.8239998817443848 C7.6479997634887695,5.936999797821045 5.935999870300293,7.64900016784668 3.8239998817443848,7.64900016784668 C1.7130000591278076,7.64900016784668 0,5.936999797821045 0,3.8239998817443848 C0,1.7130000591278076 1.7130000591278076,0 3.8239998817443848,0 C5.935999870300293,0 7.6479997634887695,1.7130000591278076 7.6479997634887695,3.8239998817443848z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,99.64900207519531,111.87699890136719)"
          opacity="0.7663076923077483"
          style={{ display: "none" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(233,189,111)"
              fillOpacity={1}
              d=" M5.2829999923706055,2.6410000324249268 C5.2829999923706055,4.099999904632568 4.099999904632568,5.2829999923706055 2.6410000324249268,5.2829999923706055 C1.1820000410079956,5.2829999923706055 0,4.099999904632568 0,2.6410000324249268 C0,1.1820000410079956 1.1820000410079956,0 2.6410000324249268,0 C4.099999904632568,0 5.2829999923706055,1.1820000410079956 5.2829999923706055,2.6410000324249268z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,105.83799743652344,103.73500061035156)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(233,189,111)"
              fillOpacity={1}
              d=" M5.2829999923706055,2.6410000324249268 C5.2829999923706055,4.10099983215332 4.099999904632568,5.283999919891357 2.6410000324249268,5.283999919891357 C1.1820000410079956,5.283999919891357 0,4.10099983215332 0,2.6410000324249268 C0,1.1820000410079956 1.1820000410079956,0 2.6410000324249268,0 C4.099999904632568,0 5.2829999923706055,1.1820000410079956 5.2829999923706055,2.6410000324249268z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,100.61499786376953,89.70100402832031)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(233,189,111)"
              fillOpacity={1}
              d=" M5.2829999923706055,2.6410000324249268 C5.2829999923706055,4.10099983215332 4.099999904632568,5.283999919891357 2.6410000324249268,5.283999919891357 C1.1820000410079956,5.283999919891357 0,4.10099983215332 0,2.6410000324249268 C0,1.1820000410079956 1.1820000410079956,0 2.6410000324249268,0 C4.099999904632568,0 5.2829999923706055,1.1820000410079956 5.2829999923706055,2.6410000324249268z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,101.36000061035156,128.04261779785156)"
          opacity="0.6134693559046385"
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,255,255)"
              fillOpacity={1}
              d=" M7.64900016784668,3.8239998817443848 C7.64900016784668,5.936999797821045 5.936999797821045,7.64900016784668 3.8259999752044678,7.64900016784668 C1.7130000591278076,7.64900016784668 0,5.936999797821045 0,3.8239998817443848 C0,1.7130000591278076 1.7130000591278076,0 3.8259999752044678,0 C5.936999797821045,0 7.64900016784668,1.7130000591278076 7.64900016784668,3.8239998817443848z"
            />
          </g>
        </g>
      </g>
    </g>
    <g
      clipPath="url(#__lottie_element_53)"
      transform="matrix(1,0,0,1,145,155)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        transform="matrix(1,0,0,1,159.69000244140625,146.90499877929688)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          opacity={1}
          transform="matrix(1.1267873048782349,0,0,1.1267873048782349,0,0)"
        >
          <path
            fill="rgb(218,166,92)"
            fillOpacity={1}
            d=" M0,-33.904998779296875 C41.49736404418945,-33.904998779296875 75.19000244140625,-18.712169647216797 75.19000244140625,0 C75.19000244140625,18.712169647216797 41.49736404418945,33.904998779296875 0,33.904998779296875 C-41.49736404418945,33.904998779296875 -75.19000244140625,18.712169647216797 -75.19000244140625,0 C-75.19000244140625,-18.712169647216797 -41.49736404418945,-33.904998779296875 0,-33.904998779296875z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,122.17200469970703,183.90199279785156)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(49,72,144)"
            fillOpacity={1}
            d=" M2.7920000553131104,1.5470000505447388 C1.003000020980835,2.5799999237060547 0.02800000086426735,3.9140000343322754 0.0010000000474974513,5.339000225067139 C-0.02500000037252903,6.775000095367432 0.9150000214576721,8.130000114440918 2.6530001163482666,9.152999877929688 C2.6530001163482666,9.152999877929688 19.597000122070312,19.145000457763672 19.597000122070312,19.145000457763672 C20.104000091552734,19.44499969482422 20.93899917602539,19.445999145507812 21.45800018310547,19.150999069213867 C21.97800064086914,18.85099983215332 21.98200035095215,18.371999740600586 21.47800064086914,18.073999404907227 C21.47800064086914,18.073999404907227 4.5329999923706055,8.083000183105469 4.5329999923706055,8.083000183105469 C3.2909998893737793,7.348999977111816 2.615000009536743,6.377999782562256 2.634000062942505,5.349999904632568 C2.6519999504089355,4.329999923706055 3.3540000915527344,3.369999885559082 4.6020002365112305,2.6489999294281006 C5.9039998054504395,1.909999966621399 7.580999851226807,1.5169999599456787 9.359000205993652,1.5230000019073486 C11.135000228881836,1.531000018119812 12.79800033569336,1.9390000104904175 14.043000221252441,2.671999931335449 C14.043000221252441,2.671999931335449 35.56700134277344,15.366999626159668 35.56700134277344,15.366999626159668 C37.25699996948242,16.36400032043457 37.236000061035156,17.974000930786133 35.52399826049805,18.96299934387207 C33.81800079345703,19.93199920654297 30.917999267578125,19.920000076293945 29.273000717163086,18.947999954223633 C29.273000717163086,18.947999954223633 14.817000389099121,10.425000190734863 14.817000389099121,10.425000190734863 C14.42300033569336,10.194000244140625 14.20199966430664,9.875 14.206999778747559,9.548999786376953 C14.21500015258789,9.222999572753906 14.440999984741211,8.914999961853027 14.843000411987305,8.682000160217285 C15.689000129699707,8.20199966430664 17.045000076293945,8.206999778747559 17.864999771118164,8.692000389099121 C17.864999771118164,8.692000389099121 27.738000869750977,14.512999534606934 27.738000869750977,14.512999534606934 C28.246000289916992,14.812999725341797 29.076000213623047,14.815999984741211 29.594999313354492,14.520999908447266 C30.114999771118164,14.220999717712402 30.124000549316406,13.741999626159668 29.618000030517578,13.444000244140625 C29.618000030517578,13.444000244140625 19.7450008392334,7.620999813079834 19.7450008392334,7.620999813079834 C17.90999984741211,6.539000034332275 14.888999938964844,6.526000022888184 13.008999824523926,7.5920000076293945 C12.090999603271484,8.121999740600586 11.59000015258789,8.807999610900879 11.579000473022461,9.538999557495117 C11.5649995803833,10.265000343322754 12.0600004196167,10.979000091552734 12.939000129699707,11.496000289916992 C12.939000129699707,11.496000289916992 27.391000747680664,20.018999099731445 27.391000747680664,20.018999099731445 C28.70400047302246,20.792999267578125 30.46500015258789,21.22599983215332 32.34299850463867,21.233999252319336 C34.22600173950195,21.242000579833984 35.999000549316406,20.826000213623047 37.34299850463867,20.06100082397461 C40.117000579833984,18.459999084472656 40.1510009765625,15.890000343322754 37.44900131225586,14.295999526977539 C37.44900131225586,14.295999526977539 15.925000190734863,1.6019999980926514 15.925000190734863,1.6019999980926514 C14.1899995803833,0.5770000219345093 11.866000175476074,0.009999999776482582 9.38599967956543,0 C6.906000137329102,-0.009999999776482582 4.561999797821045,0.5379999876022339 2.7920000553131104,1.5470000505447388z"
          />
        </g>
      </g>
    </g>
    <g
      clipPath="url(#__lottie_element_57)"
      transform="matrix(1,0,0,1,125.3599853515625,50.96299743652344)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        clipPath="url(#__lottie_element_227)"
        transform="matrix(1,0,0,1,59.5,83.5)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          transform="matrix(1,0,0,1,0,69.44400024414062)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(55,93,168)"
              fillOpacity={1}
              d=" M240.58700561523438,0.007000000216066837 C240.58700561523438,0.007000000216066837 240.58700561523438,5.507999897003174 240.58700561523438,5.507999897003174 C240.58700561523438,5.507999897003174 120.32599639892578,74.97100067138672 120.32599639892578,74.97100067138672 C120.32599639892578,74.97100067138672 0,5.5 0,5.5 C0,5.5 0,0 0,0 C0,0 240.58700561523438,0.007000000216066837 240.58700561523438,0.007000000216066837z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,53.230995178222656,88.33899688720703)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(35,55,77)"
              fillOpacity={1}
              d=" M0,0 C0,0 0,63.83399963378906 0,63.83399963378906 C0,85.97100067138672 30.301000595092773,103.91500091552734 67.677001953125,103.91500091552734 C105.0530014038086,103.91500091552734 135.35299682617188,85.97100067138672 135.35299682617188,63.83399963378906 C135.35299682617188,63.83399963378906 135.35299682617188,0 135.35299682617188,0 C135.35299682617188,0 0,0 0,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,54.33000183105469,89.94300079345703)"
          opacity="0.11319000000000001"
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(0,0,0)"
              fillOpacity={1}
              d=" M0.11400000005960464,16.434999465942383 C-1.7120000123977661,16.950000762939453 18.482999801635742,44.696998596191406 51.888999938964844,63.36600112915039 C71.33999633789062,74.23600006103516 108.33799743652344,76.625 129.44900512695312,77.06199645996094 C132.53900146484375,72.47200012207031 134.25399780273438,67.47100067138672 134.25399780273438,62.22999954223633 C134.25399780273438,62.22999954223633 134.25399780273438,14.670000076293945 134.25399780273438,14.670000076293945 C134.25399780273438,14.670000076293945 45.779998779296875,0 45.779998779296875,0 C45.779998779296875,0 2.9040000438690186,15.64799976348877 0.11400000005960464,16.434999465942383z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0,5.5)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(56,96,166)"
              fillOpacity={1}
              d=" M0,69.44400024414062 C0,69.44400024414062 120.29299926757812,0 120.29299926757812,0 C120.29299926757812,0 240.58700561523438,69.45099639892578 240.58700561523438,69.45099639892578 C240.58700561523438,69.45099639892578 120.32599639892578,138.91400146484375 120.32599639892578,138.91400146484375 C120.32599639892578,138.91400146484375 0,69.44400024414062 0,69.44400024414062z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0,0)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(35,55,77)"
              fillOpacity={1}
              d=" M0,69.44400024414062 C0,69.44400024414062 120.29299926757812,0 120.29299926757812,0 C120.29299926757812,0 240.58700561523438,69.45099639892578 240.58700561523438,69.45099639892578 C240.58700561523438,69.45099639892578 120.32599639892578,138.91400146484375 120.32599639892578,138.91400146484375 C120.32599639892578,138.91400146484375 0,69.44400024414062 0,69.44400024414062z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,0,69.44400024414062)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(78,116,193)"
              fillOpacity={1}
              d=" M120.32599639892578,74.97100067138672 C120.32599639892578,74.97100067138672 120.32599639892578,69.47100067138672 120.32599639892578,69.47100067138672 C120.32599639892578,69.47100067138672 0,0 0,0 C0,0 0,5.5 0,5.5 C0,5.5 120.32599639892578,74.97100067138672 120.32599639892578,74.97100067138672z"
            />
          </g>
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,229.36099243164062,229.7679901123047)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(233,189,111)"
            fillOpacity={1}
            d=" M10.003000259399414,29.323999404907227 C10.003000259399414,29.323999404907227 15.03499984741211,29.323999404907227 15.03499984741211,29.323999404907227 C17.94099998474121,29.323999404907227 20.235000610351562,26.854999542236328 20.023000717163086,23.957000732421875 C20.023000717163086,23.957000732421875 17.506999969482422,10.88599967956543 17.506999969482422,10.88599967956543 C17.31599998474121,8.272000312805176 15.138999938964844,6.25 12.517999649047852,6.25 C12.517999649047852,6.25 12.517999649047852,6.25 12.517999649047852,6.25 C9.89900016784668,6.25 7.7230000495910645,8.272000312805176 7.531000137329102,10.88599967956543 C7.531000137329102,10.88599967956543 5.013999938964844,23.957000732421875 5.013999938964844,23.957000732421875 C4.802000045776367,26.854999542236328 7.0970001220703125,29.323999404907227 10.003000259399414,29.323999404907227z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,170.48899841308594,140.97000122070312)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,5,5)">
          <path
            fill="rgb(233,189,111)"
            fillOpacity={1}
            d=" M65.23500061035156,112.2770004272461 C65.23500061035156,112.2770004272461 67.66000366210938,112.2770004272461 67.66000366210938,112.2770004272461 C67.66000366210938,112.2770004272461 67.66000366210938,39.172000885009766 67.66000366210938,39.172000885009766 C67.66000366210938,39.172000885009766 1.2319999933242798,0 1.2319999933242798,0 C1.2319999933242798,0 0,2.0889999866485596 0,2.0889999866485596 C0,2.0889999866485596 65.23500061035156,40.55500030517578 65.23500061035156,40.55500030517578 C65.23500061035156,40.55500030517578 65.23500061035156,112.2770004272461 65.23500061035156,112.2770004272461z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,231.2080078125,215.35899353027344)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(233,189,111)"
            fillOpacity={1}
            d=" M16.277999877929688,11.388999938964844 C16.277999877929688,14.503000259399414 13.753999710083008,17.027000427246094 10.638999938964844,17.027000427246094 C7.525000095367432,17.027000427246094 5,14.503000259399414 5,11.388999938964844 C5,8.274999618530273 7.525000095367432,5.75 10.638999938964844,5.75 C13.753999710083008,5.75 16.277999877929688,8.274999618530273 16.277999877929688,11.388999938964844z"
          />
        </g>
      </g>
    </g>
    <g
      clipPath="url(#__lottie_element_61)"
      transform="matrix(1,0,0,1,231,522.5)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        clipPath="url(#__lottie_element_255)"
        transform="matrix(1,0,0,1,-0.4720001220703125,2.302999496459961)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          clipPath="url(#__lottie_element_265)"
          transform="matrix(1,0,0,1,4.5970001220703125,-0.22100019454956055)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M0,6.783999919891357 C0,6.783999919891357 0.006000000052154064,8.557000160217285 0.006000000052154064,8.557000160217285 C0.004000000189989805,8.527000427246094 0.006000000052154064,8.49899959564209 0.006000000052154064,8.470000267028809 C0.035999998450279236,6.685999870300293 1.2640000581741333,5.00600004196167 3.4519999027252197,3.74399995803833 C5.729000091552734,2.450000047683716 8.666000366210938,1.7599999904632568 11.777999877929688,1.7730000019073486 C14.88700008392334,1.7869999408721924 17.79800033569336,2.503000020980835 19.97599983215332,3.7839999198913574 C19.97599983215332,3.7839999198913574 19.97100067138672,2.013000011444092 19.97100067138672,2.013000011444092 C17.792999267578125,0.7300000190734863 14.881999969482422,0.014000000432133675 11.77299976348877,0 C8.659000396728516,-0.010999999940395355 5.724999904632568,0.6790000200271606 3.446000099182129,1.9730000495910645 C1.2599999904632568,3.234999895095825 0.03200000151991844,4.914000034332275 0.0020000000949949026,6.697000026702881 C0.0020000000949949026,6.697000026702881 0,6.783999919891357 0,6.783999919891357z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_324)"
            transform="matrix(1,0,0,1,-0.012000083923339844,-0.22100019454956055)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_325)">
              <g
                clipPath="url(#__lottie_element_328)"
                transform="matrix(1,0,0,1,-0.012000083923339844,-0.22100019454956055)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,1.1679999828338623)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,5.616000175476074 C0,5.616000175476074 0.006000000052154064,7.388999938964844 0.006000000052154064,7.388999938964844 C0.004000000189989805,7.359000205993652 0.006000000052154064,7.329999923706055 0.006000000052154064,7.301000118255615 C0.035999998450279236,5.517000198364258 1.2640000581741333,3.8380000591278076 3.4519999027252197,2.5759999752044678 C3.9820001125335693,2.2739999294281006 4.547999858856201,2.006999969482422 5.144999980926514,1.7719999551773071 C5.144999980926514,1.7719999551773071 5.140999794006348,0 5.140999794006348,0 C4.544000148773193,0.2329999953508377 3.9769999980926514,0.5019999742507935 3.446000099182129,0.8040000200271606 C1.2599999904632568,2.065999984741211 0.03200000151991844,3.744999885559082 0.0020000000949949026,5.5279998779296875 C0.0020000000949949026,5.5279998779296875 0,5.616000175476074 0,5.616000175476074"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,5.140000343322754,0.687999963760376)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.47999998927116394 C0,0.47999998927116394 0.004999999888241291,2.252000093460083 0.004999999888241291,2.252000093460083 C0.460999995470047,2.072000026702881 0.9350000023841858,1.9119999408721924 1.4229999780654907,1.7730000019073486 C1.4229999780654907,1.7730000019073486 1.4190000295639038,0 1.4190000295639038,0 C0.9309999942779541,0.14100000262260437 0.4560000002384186,0.30000001192092896 0,0.47999998927116394"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,6.559000015258789,0.39100003242492676)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.296999990940094 C0,0.296999990940094 0.004999999888241291,2.069999933242798 0.004999999888241291,2.069999933242798 C0.4009999930858612,1.9570000171661377 0.8059999942779541,1.8569999933242798 1.218999981880188,1.7710000276565552 C1.218999981880188,1.7710000276565552 1.2139999866485596,0 1.2139999866485596,0 C0.8009999990463257,0.0860000029206276 0.3959999978542328,0.1850000023841858 0,0.296999990940094"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,7.7729997634887695,0.1929999589920044)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.1979999989271164 C0,0.1979999989271164 0.004999999888241291,1.968999981880188 0.004999999888241291,1.968999981880188 C0.37700000405311584,1.8919999599456787 0.7559999823570251,1.8270000219345093 1.1410000324249268,1.7730000019073486 C1.1410000324249268,1.7730000019073486 1.1360000371932983,0 1.1360000371932983,0 C0.7509999871253967,0.05400000140070915 0.3720000088214874,0.12099999934434891 0,0.1979999989271164"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,8.90999984741211,0.0679999589920044)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.125 C0,0.125 0.004999999888241291,1.8980000019073486 0.004999999888241291,1.8980000019073486 C0.37400001287460327,1.8450000286102295 0.746999979019165,1.8029999732971191 1.125,1.7710000276565552 C1.125,1.7710000276565552 1.1200000047683716,0 1.1200000047683716,0 C0.7419999837875366,0.029999999329447746 0.36899998784065247,0.07400000095367432 0,0.125"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,10.029999732971191,0.008000016212463379)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.061000000685453415 C0,0.061000000685453415 0.004999999888241291,1.8320000171661377 0.004999999888241291,1.8320000171661377 C0.382999986410141,1.8020000457763672 0.765999972820282,1.781000018119812 1.1519999504089355,1.7710000276565552 C1.1519999504089355,1.7710000276565552 1.1480000019073486,0 1.1480000019073486,0 C0.7620000243186951,0.00800000037997961 0.3779999911785126,0.028999999165534973 0,0.061000000685453415"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,11.177999496459961,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.00800000037997961 C0,0.00800000037997961 0.004999999888241291,1.7790000438690186 0.004999999888241291,1.7790000438690186 C0.2029999941587448,1.7740000486373901 0.4000000059604645,1.7710000276565552 0.6000000238418579,1.7730000019073486 C0.8029999732971191,1.7730000019073486 1.003999948501587,1.777999997138977 1.2050000429153442,1.784000039100647 C1.2050000429153442,1.784000039100647 1.2000000476837158,0.013000000268220901 1.2000000476837158,0.013000000268220901 C0.9990000128746033,0.007000000216066837 0.7979999780654907,0.0020000000949949026 0.5950000286102295,0 C0.3959999978542328,0 0.1979999989271164,0.0020000000949949026 0,0.00800000037997961"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,12.378000259399414,0.012999951839447021)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.4410000145435333,1.784999966621399 0.8709999918937683,1.815000057220459 1.2970000505447388,1.8580000400543213 C1.2970000505447388,1.8580000400543213 1.2929999828338623,0.0860000029206276 1.2929999828338623,0.0860000029206276 C0.8669999837875366,0.0430000014603138 0.4359999895095825,0.014000000432133675 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,13.670999526977539,0.09900003671646118)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.5090000033378601,1.8200000524520874 1.003999948501587,1.8890000581741333 1.4889999628067017,1.9769999980926514 C1.4889999628067017,1.9769999980926514 1.4839999675750732,0.20600000023841858 1.4839999675750732,0.20600000023841858 C0.9990000128746033,0.11800000071525574 0.5040000081062317,0.04899999871850014 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,15.155000686645508,0.3049999475479126)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.753000020980835,1.906999945640564 1.4759999513626099,2.0859999656677246 2.1610000133514404,2.305999994277954 C2.1610000133514404,2.305999994277954 2.1559998989105225,0.5350000262260437 2.1559998989105225,0.5350000262260437 C1.4700000286102295,0.3149999976158142 0.7490000128746033,0.13600000739097595 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,17.309999465942383,0.8400000333786011)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.972000002861023,2.0820000171661377 1.8669999837875366,2.4760000705718994 2.6649999618530273,2.944999933242798 C2.6649999618530273,2.944999933242798 2.6600000858306885,1.1729999780654907 2.6600000858306885,1.1729999780654907 C1.8619999885559082,0.7039999961853027 0.9670000076293945,0.3100000023841858 0,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_269)"
          transform="matrix(1,0,0,1,-0.17600011825561523,6.461999893188477)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.010999999940395355,4.243000030517578 1.652999997138977,6.568999767303467 4.646999835968018,8.331999778747559 C4.646999835968018,8.331999778747559 4.64300012588501,6.559000015258789 4.64300012588501,6.559000015258789 C1.6490000486373901,4.796999931335449 0.006000000052154064,2.4700000286102295 0,0z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_368)"
            transform="matrix(1,0,0,1,-0.17600011825561523,-0.3340001106262207)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_369)">
              <g
                clipPath="url(#__lottie_element_372)"
                transform="matrix(1,0,0,1,-0.17600011825561523,-0.3340001106262207)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.004999999888241291,1.8200000524520874 0.006000000052154064,1.871000051498413 0.006000000052154064,1.9199999570846558 C0.006000000052154064,1.9199999570846558 0.0020000000949949026,0.1469999998807907 0.0020000000949949026,0.1469999998807907 C0,0.0989999994635582 0,0.05000000074505806 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.000999998301267624,0.14700007438659668)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.014999999664723873,2.0889999866485596 0.050999999046325684,2.4010000228881836 0.11299999803304672,2.7109999656677246 C0.11299999803304672,2.7109999656677246 0.10899999737739563,0.9399999976158142 0.10899999737739563,0.9399999976158142 C0.04699999839067459,0.6299999952316284 0.009999999776482582,0.3160000145435333 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.11100000143051147,1.0870000123977661)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.06599999964237213,2.0789999961853027 0.15299999713897705,2.382999897003174 0.26499998569488525,2.683000087738037 C0.26499998569488525,2.683000087738037 0.25999999046325684,0.9110000133514404 0.25999999046325684,0.9110000133514404 C0.14800000190734863,0.6110000014305115 0.061000000685453415,0.3059999942779541 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.3700000047683716,1.9980000257492065)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.12200000137090683,2.0810000896453857 0.26499998569488525,2.385999917984009 0.4339999854564667,2.686000108718872 C0.4339999854564667,2.686000108718872 0.42899999022483826,0.9150000214576721 0.42899999022483826,0.9150000214576721 C0.25999999046325684,0.6150000095367432 0.11699999868869781,0.3100000023841858 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.7989999651908875,2.9129998683929443)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.1889999955892563,2.0980000495910645 0.40400001406669617,2.4179999828338623 0.6499999761581421,2.7309999465942383 C0.6499999761581421,2.7309999465942383 0.6449999809265137,0.9580000042915344 0.6449999809265137,0.9580000042915344 C0.39899998903274536,0.6470000147819519 0.18400000035762787,0.32600000500679016 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.444000005722046,3.869999885559082)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.296999990940094,2.1429998874664307 0.6299999952316284,2.503999948501587 1.0069999694824219,2.8529999256134033 C1.0069999694824219,2.8529999256134033 1.0019999742507935,1.0800000429153442 1.0019999742507935,1.0800000429153442 C0.625,0.7319999933242798 0.2919999957084656,0.3720000088214874 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.447000026702881,4.951000213623047)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.5889999866485596,2.312000036239624 1.2730000019073486,2.821000099182129 2.052000045776367,3.2920000553131104 C2.052000045776367,3.2920000553131104 2.0480000972747803,1.5210000276565552 2.0480000972747803,1.5210000276565552 C1.2690000534057617,1.0499999523162842 0.5839999914169312,0.5410000085830688 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,4.49399995803833,6.4720001220703125)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.05400000140070915,1.8009999990463257 0.10400000214576721,1.8309999704360962 0.15299999713897705,1.8609999418258667 C0.15299999713897705,1.8609999418258667 0.14800000190734863,0.08799999952316284 0.14800000190734863,0.08799999952316284 C0.14800000190734863,0.08799999952316284 0,0 0,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_273)"
          transform="matrix(1,0,0,1,24.570999145507812,11.875)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M0,2.1700000762939453 C0,2.1700000762939453 0.004999999888241291,3.940999984741211 0.004999999888241291,3.940999984741211 C0.004999999888241291,3.940999984741211 0.006000000052154064,3.9159998893737793 0.006000000052154064,3.9159998893737793 C0.01899999938905239,3.3450000286102295 0.41200000047683716,2.806999921798706 1.1169999837875366,2.4000000953674316 C2.5980000495910645,1.5570000410079956 4.9720001220703125,1.5640000104904175 6.4079999923706055,2.4159998893737793 C6.4079999923706055,2.4159998893737793 6.4029998779296875,0.6439999938011169 6.4029998779296875,0.6439999938011169 C4.9670000076293945,-0.20800000429153442 2.5929999351501465,-0.2160000056028366 1.1119999885559082,0.628000020980835 C0.40700000524520874,1.034999966621399 0.014000000432133675,1.5729999542236328 0,2.1440000534057617 C0,2.1440000534057617 0,2.1700000762939453 0,2.1700000762939453z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_403)"
            transform="matrix(1,0,0,1,-0.29600000381469727,-0.029000043869018555)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_404)">
              <g
                clipPath="url(#__lottie_element_407)"
                transform="matrix(1,0,0,1,-0.29600000381469727,-0.029000043869018555)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0.37699997425079346)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,1.7920000553131104 C0,1.7920000553131104 0.004999999888241291,3.563999891281128 0.004999999888241291,3.563999891281128 C0.004999999888241291,3.563999891281128 0.006000000052154064,3.5380001068115234 0.006000000052154064,3.5380001068115234 C0.01899999938905239,2.9670000076293945 0.41200000047683716,2.428999900817871 1.1169999837875366,2.0220000743865967 C1.2829999923706055,1.9279999732971191 1.4589999914169312,1.843999981880188 1.6440000534057617,1.7710000276565552 C1.6440000534057617,1.7710000276565552 1.6369999647140503,0 1.6369999647140503,0 C1.4529999494552612,0.07199999690055847 1.277999997138977,0.15600000321865082 1.1119999885559082,0.25 C0.40700000524520874,0.6570000052452087 0.014000000432133675,1.1959999799728394 0,1.7669999599456787 C0,1.7669999599456787 0,1.7920000553131104 0,1.7920000553131104"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.6380000114440918,0.22299998998641968)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.1550000011920929 C0,0.1550000011920929 0.006000000052154064,1.9259999990463257 0.006000000052154064,1.9259999990463257 C0.15299999713897705,1.86899995803833 0.3070000112056732,1.8179999589920044 0.46299999952316284,1.7730000019073486 C0.46299999952316284,1.7730000019073486 0.4580000042915344,0 0.4580000042915344,0 C0.30000001192092896,0.04500000178813934 0.14800000190734863,0.09799999743700027 0,0.1550000011920929"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.0950000286102295,0.12699997425079346)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.09600000083446503 C0,0.09600000083446503 0.004999999888241291,1.86899995803833 0.004999999888241291,1.86899995803833 C0.13300000131130219,1.8320000171661377 0.2639999985694885,1.7999999523162842 0.3959999978542328,1.7730000019073486 C0.3959999978542328,1.7730000019073486 0.39100000262260437,0 0.39100000262260437,0 C0.2590000033378601,0.027000000700354576 0.12800000607967377,0.061000000685453415 0,0.09600000083446503"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.486999988555908,0.06300002336502075)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.06400000303983688 C0,0.06400000303983688 0.004999999888241291,1.8370000123977661 0.004999999888241291,1.8370000123977661 C0.12800000607967377,1.8109999895095825 0.2529999911785126,1.7899999618530273 0.37700000405311584,1.7719999551773071 C0.37700000405311584,1.7719999551773071 0.3720000088214874,0 0.3720000088214874,0 C0.2460000067949295,0.017999999225139618 0.12300000339746475,0.039000000804662704 0,0.06400000303983688"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.8580000400543213,0.02199995517730713)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.041999999433755875 C0,0.041999999433755875 0.004999999888241291,1.812999963760376 0.004999999888241291,1.812999963760376 C0.12600000202655792,1.7960000038146973 0.24699999392032623,1.7829999923706055 0.3700000047683716,1.7719999551773071 C0.3700000047683716,1.7719999551773071 0.36500000953674316,0 0.36500000953674316,0 C0.24199999868869781,0.009999999776482582 0.12099999934434891,0.02500000037252903 0,0.041999999433755875"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.2230000495910645,0.0020000338554382324)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.01899999938905239 C0,0.01899999938905239 0.004999999888241291,1.7910000085830688 0.004999999888241291,1.7910000085830688 C0.12800000607967377,1.781000018119812 0.25,1.7740000486373901 0.37299999594688416,1.7710000276565552 C0.37299999594688416,1.7710000276565552 0.36899998784065247,0 0.36899998784065247,0 C0.2460000067949295,0.003000000026077032 0.12099999934434891,0.009999999776482582 0,0.01899999938905239"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.5920000076293945,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.0020000000949949026 C0,0.0020000000949949026 0.004999999888241291,1.7740000486373901 0.004999999888241291,1.7740000486373901 C0.13300000131130219,1.7710000276565552 0.25999999046325684,1.7699999809265137 0.3880000114440918,1.774999976158142 C0.3880000114440918,1.774999976158142 0.382999986410141,0.004000000189989805 0.382999986410141,0.004000000189989805 C0.2549999952316284,-0.0010000000474974513 0.12800000607967377,-0.0010000000474974513 0,0.0020000000949949026"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.9749999046325684,0.0040000081062316895)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.14399999380111694,1.7760000228881836 0.2809999883174896,1.7860000133514404 0.4180000126361847,1.7990000247955322 C0.4180000126361847,1.7990000247955322 0.4129999876022339,0.027000000700354576 0.4129999876022339,0.027000000700354576 C0.2759999930858612,0.014000000432133675 0.13899999856948853,0.004999999888241291 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,4.388999938964844,0.030999958515167236)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.16599999368190765,1.7869999408721924 0.32600000500679016,1.809999942779541 0.4819999933242798,1.8389999866485596 C0.4819999933242798,1.8389999866485596 0.47699999809265137,0.06700000166893005 0.47699999809265137,0.06700000166893005 C0.32100000977516174,0.03799999877810478 0.16099999845027924,0.01600000075995922 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,4.865999698638916,0.09800004959106445)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.24799999594688416,1.8140000104904175 0.4819999933242798,1.8739999532699585 0.7070000171661377,1.9470000267028809 C0.7070000171661377,1.9470000267028809 0.7020000219345093,0.17399999499320984 0.7020000219345093,0.17399999499320984 C0.47699999809265137,0.10199999809265137 0.24300000071525574,0.0430000014603138 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,5.567999839782715,0.27199995517730713)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.3070000112056732,1.8700000047683716 0.5870000123977661,1.9930000305175781 0.8389999866485596,2.1429998874664307 C0.8389999866485596,2.1429998874664307 0.8349999785423279,0.3720000088214874 0.8349999785423279,0.3720000088214874 C0.5830000042915344,0.22200000286102295 0.30000001192092896,0.0989999994635582 0,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_277)"
          transform="matrix(1,0,0,1,19.95800018310547,13.659000396728516)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.00800000037997961,3.0220000743865967 0.8730000257492065,4.245999813079834 2.385999917984009,5.13700008392334 C2.385999917984009,5.13700008392334 2.38100004196167,3.365999937057495 2.38100004196167,3.365999937057495 C0.8679999709129333,2.4739999771118164 0.003000000026077032,1.2510000467300415 0,0z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_447)"
            transform="matrix(1,0,0,1,-0.3070000410079956,-0.4309999942779541)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_448)">
              <g
                clipPath="url(#__lottie_element_451)"
                transform="matrix(1,0,0,1,-0.3070000410079956,-0.4309999942779541)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.004999999888241291,1.7710000276565552 0.006000000052154064,1.843000054359436 0.006000000052154064,1.843000054359436 C0.006000000052154064,1.843000054359436 0.0020000000949949026,0.07199999690055847 0.0020000000949949026,0.07199999690055847 C0.0020000000949949026,0.07199999690055847 0,0 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.0010000001639127731,0.07200002670288086)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.009999999776482582,1.9290000200271606 0.027000000700354576,2.0850000381469727 0.05900000035762787,2.240999937057495 C0.05900000035762787,2.240999937057495 0.05299999937415123,0.46799999475479126 0.05299999937415123,0.46799999475479126 C0.023000000044703484,0.31299999356269836 0.004999999888241291,0.15600000321865082 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.053999997675418854,0.5390000343322754)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7730000019073486 0.006000000052154064,1.7730000019073486 C0.035999998450279236,1.9290000200271606 0.08100000023841858,2.0840001106262207 0.14000000059604645,2.239000082015991 C0.14000000059604645,2.239000082015991 0.1340000033378601,0.46799999475479126 0.1340000033378601,0.46799999475479126 C0.07699999958276749,0.31299999356269836 0.03200000151991844,0.15800000727176666 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.18799999356269836,1.0070000886917114)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7719999551773071 0.006000000052154064,1.7719999551773071 C0.06700000166893005,1.9329999685287476 0.14100000262260437,2.0929999351501465 0.23000000417232513,2.249000072479248 C0.23000000417232513,2.249000072479248 0.22499999403953552,0.47699999809265137 0.22499999403953552,0.47699999809265137 C0.13600000739097595,0.32100000977516174 0.061000000685453415,0.16099999845027924 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.4129999876022339,1.4839999675750732)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.10199999809265137,1.9429999589920044 0.2150000035762787,2.111999988555908 0.34299999475479126,2.2760000228881836 C0.34299999475479126,2.2760000228881836 0.33799999952316284,0.5040000081062317 0.33799999952316284,0.5040000081062317 C0.20900000631809235,0.3400000035762787 0.09600000083446503,0.1720000058412552 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.7519999742507935,1.9890000820159912)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.15800000727176666,1.965999960899353 0.33399999141693115,2.1559998989105225 0.5299999713897705,2.3359999656677246 C0.5299999713897705,2.3359999656677246 0.5249999761581421,0.5649999976158142 0.5249999761581421,0.5649999976158142 C0.32899999618530273,0.382999986410141 0.15299999713897705,0.19499999284744263 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2760000228881836,2.553999900817871)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.3019999861717224,2.046999931335449 0.6460000276565552,2.305000066757202 1.0369999408721924,2.5409998893737793 C1.0369999408721924,2.5409998893737793 1.0329999923706055,0.7689999938011169 1.0329999923706055,0.7689999938011169 C0.6420000195503235,0.5329999923706055 0.296999990940094,0.2750000059604645 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.309999942779541,3.322999954223633)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.004999999888241291,1.7710000276565552 0.07699999958276749,1.815000057220459 0.07699999958276749,1.815000057220459 C0.07699999958276749,1.815000057220459 0.07199999690055847,0.0430000014603138 0.07199999690055847,0.0430000014603138 C0.07199999690055847,0.0430000014603138 0,0 0,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,31.270998001098633,12.547999382019043)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,117,0)"
              fillOpacity={1}
              d=" M0,0 C0,0 0.004999999888241291,1.7719999551773071 0.004999999888241291,1.7719999551773071 C0.004999999888241291,1.7719999551773071 17.283000946044922,11.961999893188477 17.283000946044922,11.961999893188477 C17.283000946044922,11.961999893188477 17.277999877929688,10.1899995803833 17.277999877929688,10.1899995803833 C17.277999877929688,10.1899995803833 0,0 0,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,39.91299819946289,18.52899932861328)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_287)"
          transform="matrix(1,0,0,1,48.525001525878906,21.349000930786133)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M3.9519999027252197,1.7710000276565552 C3.9519999027252197,1.7710000276565552 3.947000026702881,0 3.947000026702881,0 C3.947000026702881,0.34599998593330383 3.7149999141693115,0.6940000057220459 3.253999948501587,0.9620000123977661 C2.3440001010894775,1.4780000448226929 0.8889999985694885,1.4730000495910645 0,0.9480000138282776 C0,0.9480000138282776 0.004999999888241291,2.7190001010894775 0.004999999888241291,2.7190001010894775 C0.8939999938011169,3.24399995803833 2.3489999771118164,3.25 3.259000062942505,2.7339999675750732 C3.7219998836517334,2.4660000801086426 3.9519999027252197,2.117000102996826 3.9519999027252197,1.7710000276565552z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_482)"
            transform="matrix(1,0,0,1,-0.024000048637390137,-0.44200003147125244)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_483)">
              <g
                clipPath="url(#__lottie_element_486)"
                transform="matrix(1,0,0,1,-0.024000048637390137,-0.44200003147125244)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0.9479999542236328)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.16099999845027924,1.8639999628067017 0.33500000834465027,1.940999984741211 0.5220000147819519,2 C0.5220000147819519,2 0.5170000195503235,0.2280000001192093 0.5170000195503235,0.2280000001192093 C0.33000001311302185,0.16699999570846558 0.15600000321865082,0.09300000220537186 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.5180000066757202,1.1759998798370361)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.14399999380111694,1.8170000314712524 0.289000004529953,1.8530000448226929 0.4390000104904175,1.8799999952316284 C0.4390000104904175,1.8799999952316284 0.4339999854564667,0.10899999737739563 0.4339999854564667,0.10899999737739563 C0.2840000092983246,0.0820000022649765 0.13899999856948853,0.04600000008940697 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.9509999752044678,1.284999966621399)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.10199999809265137,1.7879999876022339 0.19900000095367432,1.8029999732971191 0.30000001192092896,1.812999963760376 C0.30000001192092896,1.812999963760376 0.29499998688697815,0.041999999433755875 0.29499998688697815,0.041999999433755875 C0.1940000057220459,0.03200000151991844 0.09700000286102295,0.017999999225139618 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2470000982284546,1.3259999752044678)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.09000000357627869,1.7790000438690186 0.17399999499320984,1.7860000133514404 0.2590000033378601,1.7890000343322754 C0.2590000033378601,1.7890000343322754 0.2540000081062317,0.01600000075995922 0.2540000081062317,0.01600000075995922 C0.16899999976158142,0.013000000268220901 0.08299999684095383,0.00800000037997961 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.5,1.3420000076293945)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.08299999684095383,1.774999976158142 0.16300000250339508,1.774999976158142 0.2409999966621399,1.7730000019073486 C0.2409999966621399,1.7730000019073486 0.23600000143051147,0.0020000000949949026 0.23600000143051147,0.0020000000949949026 C0.15600000321865082,0.004000000189989805 0.07800000160932541,0.003000000026077032 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.7360000610351562,1.3329999446868896)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.010999999940395355 C0,0.010999999940395355 0.004999999888241291,1.7829999923706055 0.004999999888241291,1.7829999923706055 C0.07999999821186066,1.781000018119812 0.15600000321865082,1.7769999504089355 0.23100000619888306,1.7710000276565552 C0.23100000619888306,1.7710000276565552 0.22699999809265137,0 0.22699999809265137,0 C0.15000000596046448,0.004999999888241291 0.07500000298023224,0.008999999612569809 0,0.010999999940395355"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.962999939918518,1.308000087738037)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.026000000536441803 C0,0.026000000536441803 0.004999999888241291,1.7970000505447388 0.004999999888241291,1.7970000505447388 C0.07999999821186066,1.7910000085830688 0.15299999713897705,1.781999945640564 0.2280000001192093,1.7710000276565552 C0.2280000001192093,1.7710000276565552 0.22300000488758087,0 0.22300000488758087,0 C0.14800000190734863,0.009999999776482582 0.07500000298023224,0.019999999552965164 0,0.026000000536441803"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.185999870300293,1.2670000791549683)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.03999999910593033 C0,0.03999999910593033 0.004999999888241291,1.8109999895095825 0.004999999888241291,1.8109999895095825 C0.0820000022649765,1.7999999523162842 0.15800000727176666,1.7869999408721924 0.2329999953508377,1.7710000276565552 C0.2329999953508377,1.7710000276565552 0.22699999809265137,0 0.22699999809265137,0 C0.15199999511241913,0.01600000075995922 0.07699999958276749,0.028999999165534973 0,0.03999999910593033"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.4130001068115234,1.2079999446868896)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.05900000035762787 C0,0.05900000035762787 0.006000000052154064,1.8300000429153442 0.006000000052154064,1.8300000429153442 C0.08699999749660492,1.8140000104904175 0.1679999977350235,1.7929999828338623 0.2460000067949295,1.7710000276565552 C0.2460000067949295,1.7710000276565552 0.2409999966621399,0 0.2409999966621399,0 C0.16300000250339508,0.02199999988079071 0.08100000023841858,0.041999999433755875 0,0.05900000035762787"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.6540000438690186,1.113999843597412)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.09399999678134918 C0,0.09399999678134918 0.004999999888241291,1.8660000562667847 0.004999999888241291,1.8660000562667847 C0.10100000351667404,1.8389999866485596 0.19499999284744263,1.8079999685287476 0.2840000092983246,1.7710000276565552 C0.2840000092983246,1.7710000276565552 0.27900001406669617,0 0.27900001406669617,0 C0.18799999356269836,0.03500000014901161 0.09600000083446503,0.06700000166893005 0,0.09399999678134918"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.932999849319458,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,1.1139999628067017 C0,1.1139999628067017 0.004999999888241291,2.884999990463257 0.004999999888241291,2.884999990463257 C0.11800000071525574,2.8399999141693115 0.22499999403953552,2.7920000553131104 0.32600000500679016,2.7339999675750732 C0.7889999747276306,2.4660000801086426 1.0180000066757202,2.117000102996826 1.0180000066757202,1.7710000276565552 C1.0180000066757202,1.7710000276565552 1.0130000114440918,0 1.0130000114440918,0 C1.0130000114440918,0.34599998593330383 0.7820000052452087,0.6940000057220459 0.32100000977516174,0.9620000123977661 C0.2199999988079071,1.0180000066757202 0.1120000034570694,1.069000005722046 0,1.1139999628067017"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,24.579998016357422,2.01200008392334)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,117,0)"
              fillOpacity={1}
              d=" M0,0 C0,0 0.004999999888241291,1.7719999551773071 0.004999999888241291,1.7719999551773071 C0.004999999888241291,1.7719999551773071 37.680999755859375,23.992000579833984 37.680999755859375,23.992000579833984 C37.680999755859375,23.992000579833984 37.67599868774414,22.219999313354492 37.67599868774414,22.219999313354492 C37.67599868774414,22.219999313354492 0,0 0,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,43.41999816894531,14.008000373840332)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_297)"
          transform="matrix(1,0,0,1,61.85599899291992,24.174999237060547)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M2.2009999752044678,4.885000228881836 C2.2009999752044678,4.885000228881836 2.196000099182129,3.114000082015991 2.196000099182129,3.114000082015991 C2.193000078201294,1.9869999885559082 1.4620000123977661,0.8629999756813049 0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C1.468000054359436,2.634000062942505 2.197999954223633,3.759999990463257 2.2009999752044678,4.885000228881836z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_526)"
            transform="matrix(1,0,0,1,-0.3999999761581421,-0.056999921798706055)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_527)">
              <g
                clipPath="url(#__lottie_element_530)"
                transform="matrix(1,0,0,1,-0.3999999761581421,-0.056999921798706055)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C0.006000000052154064,1.7710000276565552 0.06199999898672104,1.8049999475479126 0.06199999898672104,1.8049999475479126 C0.06199999898672104,1.8049999475479126 0.05700000002980232,0.032999999821186066 0.05700000002980232,0.032999999821186066 C0.05700000002980232,0.032999999821186066 0,0 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.05699998140335083,0.03299999237060547)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.375,1.99399995803833 0.6980000138282776,2.2360000610351562 0.972000002861023,2.48799991607666 C0.972000002861023,2.48799991607666 0.9660000205039978,0.7170000076293945 0.9660000205039978,0.7170000076293945 C0.6930000185966492,0.4650000035762787 0.3700000047683716,0.2240000069141388 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.0230000019073486,0.7510000467300415)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C0.1860000044107437,1.9390000104904175 0.34599998593330383,2.111999988555908 0.48500001430511475,2.2869999408721924 C0.48500001430511475,2.2869999408721924 0.47999998927116394,0.515999972820282 0.47999998927116394,0.515999972820282 C0.3409999907016754,0.33899998664855957 0.18199999630451202,0.1679999977350235 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.503999948501587,1.2659999132156372)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.12300000339746475,1.9229999780654907 0.22599999606609344,2.0769999027252197 0.3140000104904175,2.2330000400543213 C0.3140000104904175,2.2330000400543213 0.3100000023841858,0.460999995470047 0.3100000023841858,0.460999995470047 C0.22200000286102295,0.3050000071525574 0.11800000071525574,0.15000000596046448 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.812999963760376,1.7269999980926514)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.08799999952316284,1.9160000085830688 0.15700000524520874,2.062999963760376 0.210999995470047,2.2100000381469727 C0.210999995470047,2.2100000381469727 0.20600000023841858,0.4390000104904175 0.20600000023841858,0.4390000104904175 C0.15000000596046448,0.28999999165534973 0.08100000023841858,0.14399999380111694 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.0190000534057617,2.1649999618530273)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.05900000035762787,1.9160000085830688 0.10100000351667404,2.062000036239624 0.13099999725818634,2.2070000171661377 C0.13099999725818634,2.2070000171661377 0.12600000202655792,0.4359999895095825 0.12600000202655792,0.4359999895095825 C0.09600000083446503,0.289000004529953 0.05400000140070915,0.14399999380111694 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.1449999809265137,2.6010000705718994)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.03400000184774399,1.9190000295639038 0.050999999046325684,2.066999912261963 0.0560000017285347,2.2149999141693115 C0.0560000017285347,2.2149999141693115 0.04899999871850014,0.4440000057220459 0.04899999871850014,0.4440000057220459 C0.04600000008940697,0.29600000381469727 0.028999999165534973,0.1469999998807907 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.194999933242798,3.044999837875366)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C0.006000000052154064,1.7710000276565552 0.006000000052154064,1.840000033378601 0.006000000052154064,1.840000033378601 C0.006000000052154064,1.840000033378601 0.0020000000949949026,0.0689999982714653 0.0020000000949949026,0.0689999982714653 C0.0020000000949949026,0.0689999982714653 0,0 0,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,4.642001152038574,13.355999946594238)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,117,0)"
              fillOpacity={1}
              d=" M0,0 C0,0 0.004999999888241291,1.7719999551773071 0.004999999888241291,1.7719999551773071 C0.004999999888241291,1.7719999551773071 29.663999557495117,19.26099967956543 29.663999557495117,19.26099967956543 C29.663999557495117,19.26099967956543 29.659000396728516,17.48900032043457 29.659000396728516,17.48900032043457 C29.659000396728516,17.48900032043457 0,0 0,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,19.474000930786133,22.986000061035156)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_307)"
          transform="matrix(1,0,0,1,34.27799987792969,29.45599937438965)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M3.953000068664551,1.7710000276565552 C3.953000068664551,1.7710000276565552 3.947999954223633,0 3.947999954223633,0 C3.947999954223633,0.34599998593330383 3.7179999351501465,0.6919999718666077 3.256999969482422,0.9589999914169312 C2.3489999771118164,1.4759999513626099 0.8889999985694885,1.4709999561309814 0,0.9459999799728394 C0,0.9459999799728394 0.004999999888241291,2.7179999351501465 0.004999999888241291,2.7179999351501465 C0.8939999938011169,3.243000030517578 2.3540000915527344,3.247999906539917 3.26200008392334,2.7309999465942383 C3.7230000495910645,2.4639999866485596 3.953000068664551,2.117000102996826 3.953000068664551,1.7710000276565552z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_561)"
            transform="matrix(1,0,0,1,-0.023000001907348633,-0.44200003147125244)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_562)">
              <g
                clipPath="url(#__lottie_element_565)"
                transform="matrix(1,0,0,1,-0.023000001907348633,-0.4429999589920044)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,0.9459999799728394)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.16099999845027924,1.8630000352859497 0.33500000834465027,1.940999984741211 0.5189999938011169,2 C0.5189999938011169,2 0.5139999985694885,0.2280000001192093 0.5139999985694885,0.2280000001192093 C0.32899999618530273,0.16899999976158142 0.15600000321865082,0.09300000220537186 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.5140000581741333,1.1749999523162842)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.14499999582767487,1.8170000314712524 0.28999999165534973,1.8530000448226929 0.4399999976158142,1.8799999952316284 C0.4399999976158142,1.8799999952316284 0.4339999854564667,0.1080000028014183 0.4339999854564667,0.1080000028014183 C0.28600001335144043,0.08100000023841858 0.14000000059604645,0.04500000178813934 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.9480000734329224,1.284000039100647)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C0.10199999809265137,1.7890000343322754 0.20100000500679016,1.8029999732971191 0.30000001192092896,1.812999963760376 C0.30000001192092896,1.812999963760376 0.29499998688697815,0.041999999433755875 0.29499998688697815,0.041999999433755875 C0.19599999487400055,0.03099999949336052 0.09700000286102295,0.017999999225139618 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2430000305175781,1.3250000476837158)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.09000000357627869,1.7790000438690186 0.17399999499320984,1.7860000133514404 0.25999999046325684,1.7890000343322754 C0.25999999046325684,1.7890000343322754 0.2549999952316284,0.01600000075995922 0.2549999952316284,0.01600000075995922 C0.16899999976158142,0.013000000268220901 0.08500000089406967,0.00800000037997961 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.497999906539917,1.3409998416900635)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.08299999684095383,1.774999976158142 0.16300000250339508,1.774999976158142 0.2409999966621399,1.7730000019073486 C0.2409999966621399,1.7730000019073486 0.23600000143051147,0.0020000000949949026 0.23600000143051147,0.0020000000949949026 C0.15600000321865082,0.003000000026077032 0.07800000160932541,0.003000000026077032 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.7339999675750732,1.3289999961853027)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.013000000268220901 C0,0.013000000268220901 0.004999999888241291,1.784000039100647 0.004999999888241291,1.784000039100647 C0.0820000022649765,1.781999945640564 0.15600000321865082,1.777999997138977 0.23100000619888306,1.7730000019073486 C0.23100000619888306,1.7730000019073486 0.22699999809265137,0 0.22699999809265137,0 C0.15199999511241913,0.006000000052154064 0.07500000298023224,0.010999999940395355 0,0.013000000268220901"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.9609999656677246,1.305999994277954)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.024000000208616257 C0,0.024000000208616257 0.004999999888241291,1.7970000505447388 0.004999999888241291,1.7970000505447388 C0.0820000022649765,1.7910000085830688 0.15700000524520874,1.781000018119812 0.23000000417232513,1.7710000276565552 C0.23000000417232513,1.7710000276565552 0.22499999403953552,0 0.22499999403953552,0 C0.15000000596046448,0.009999999776482582 0.07500000298023224,0.017999999225139618 0,0.024000000208616257"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.187000036239624,1.2649999856948853)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.03999999910593033 C0,0.03999999910593033 0.004999999888241291,1.8109999895095825 0.004999999888241291,1.8109999895095825 C0.0820000022649765,1.7999999523162842 0.15800000727176666,1.7869999408721924 0.2329999953508377,1.7710000276565552 C0.2329999953508377,1.7710000276565552 0.2280000001192093,0 0.2280000001192093,0 C0.15299999713897705,0.014000000432133675 0.07699999958276749,0.028999999165534973 0,0.03999999910593033"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.4150002002716064,1.2070000171661377)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.05900000035762787 C0,0.05900000035762787 0.004999999888241291,1.8300000429153442 0.004999999888241291,1.8300000429153442 C0.08799999952316284,1.812999963760376 0.1679999977350235,1.7929999828338623 0.2460000067949295,1.7710000276565552 C0.2460000067949295,1.7710000276565552 0.2409999966621399,0 0.2409999966621399,0 C0.16300000250339508,0.02199999988079071 0.08100000023841858,0.04100000113248825 0,0.05900000035762787"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.6550002098083496,1.1099998950958252)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.09600000083446503 C0,0.09600000083446503 0.004999999888241291,1.8669999837875366 0.004999999888241291,1.8669999837875366 C0.10199999809265137,1.840000033378601 0.19499999284744263,1.8079999685287476 0.28600001335144043,1.7730000019073486 C0.28600001335144043,1.7730000019073486 0.2809999883174896,0 0.2809999883174896,0 C0.1899999976158142,0.03700000047683716 0.09600000083446503,0.0689999982714653 0,0.09600000083446503"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.936999797821045,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,1.1109999418258667 C0,1.1109999418258667 0.004999999888241291,2.884000062942505 0.004999999888241291,2.884000062942505 C0.11800000071525574,2.8389999866485596 0.22499999403953552,2.7880001068115234 0.32600000500679016,2.7309999465942383 C0.7870000004768372,2.4639999866485596 1.0169999599456787,2.117000102996826 1.0169999599456787,1.7710000276565552 C1.0169999599456787,1.7710000276565552 1.0119999647140503,0 1.0119999647140503,0 C1.0119999647140503,0.34599998593330383 0.7820000052452087,0.6919999718666077 0.32100000977516174,0.9589999914169312 C0.2199999988079071,1.0160000324249268 0.11299999803304672,1.065999984741211 0,1.1109999418258667"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,22.645999908447266,17.45600128173828)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(255,117,0)"
              fillOpacity={1}
              d=" M0,0 C0,0 0.004999999888241291,1.7719999551773071 0.004999999888241291,1.7719999551773071 C0.004999999888241291,1.7719999551773071 25.304000854492188,16.69099998474121 25.304000854492188,16.69099998474121 C25.304000854492188,16.69099998474121 25.298999786376953,14.918999671936035 25.298999786376953,14.918999671936035 C25.298999786376953,14.918999671936035 0,0 0,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,35.29800033569336,25.802000045776367)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_317)"
          transform="matrix(1,0,0,1,47.5,27.29599952697754)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(255,117,0)"
                fillOpacity={1}
                d=" M21.111000061035156,1.7710000276565552 C21.111000061035156,1.7710000276565552 21.106000900268555,0 21.106000900268555,0 C21.111000061035156,1.8509999513626099 19.881999969482422,3.7109999656677246 17.41900062561035,5.132999897003174 C15.067000389099121,6.46999979019165 11.96500015258789,7.198999881744385 8.668999671936035,7.184999942779541 C5.380000114440918,7.171000003814697 2.299999952316284,6.414000034332275 0,5.057000160217285 C0,5.057000160217285 0.006000000052154064,6.828999996185303 0.006000000052154064,6.828999996185303 C2.303999900817871,8.185999870300293 5.385000228881836,8.942999839782715 8.673999786376953,8.956000328063965 C11.970000267028809,8.970000267028809 15.071999549865723,8.241000175476074 17.423999786376953,6.9039998054504395 C19.88599967956543,5.48199987411499 21.115999221801758,3.621999979019165 21.111000061035156,1.7710000276565552z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_605)"
            transform="matrix(1,0,0,1,-0.44499969482421875,-0.021999835968017578)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_606)">
              <g
                clipPath="url(#__lottie_element_609)"
                transform="matrix(1,0,0,1,-0.44499969482421875,-0.021999835968017578)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,0,5.058000087738037)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.006000000052154064,1.7710000276565552 0.006000000052154064,1.7710000276565552 C0.847000002861023,2.2690000534057617 1.7949999570846558,2.686000108718872 2.818000078201294,3.015000104904175 C2.818000078201294,3.015000104904175 2.813999891281128,1.2419999837875366 2.813999891281128,1.2419999837875366 C1.7910000085830688,0.9129999876022339 0.8429999947547913,0.49799999594688416 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.813999891281128,6.298999786376953)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.7300000190734863,2.00600004196167 1.4919999837875366,2.194000005722046 2.2820000648498535,2.3359999656677246 C2.2820000648498535,2.3359999656677246 2.2769999504089355,0.5649999976158142 2.2769999504089355,0.5649999976158142 C1.4869999885559082,0.4230000078678131 0.7250000238418579,0.2329999953508377 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,5.090999603271484,6.86400032043457)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.5170000195503235,1.8639999628067017 1.0410000085830688,1.937999963760376 1.5740000009536743,1.9900000095367432 C1.5740000009536743,1.9900000095367432 1.569000005722046,0.21899999678134918 1.569000005722046,0.21899999678134918 C1.0360000133514404,0.16500000655651093 0.5120000243186951,0.09300000220537186 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,6.658999919891357,7.083000183105469)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7710000276565552 0.004999999888241291,1.7710000276565552 C0.453000009059906,1.815999984741211 0.9089999794960022,1.8459999561309814 1.36899995803833,1.8619999885559082 C1.36899995803833,1.8619999885559082 1.3639999628067017,0.08900000154972076 1.3639999628067017,0.08900000154972076 C0.902999997138977,0.07500000298023224 0.4480000138282776,0.04500000178813934 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,8.02400016784668,7.171999931335449)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0 C0,0 0.004999999888241291,1.7730000019073486 0.004999999888241291,1.7730000019073486 C0.21899999678134918,1.7790000438690186 0.4350000023841858,1.784000039100647 0.6499999761581421,1.784000039100647 C0.8640000224113464,1.7860000133514404 1.0759999752044678,1.784000039100647 1.2879999876022339,1.777999997138977 C1.2879999876022339,1.777999997138977 1.281999945640564,0.006000000052154064 1.281999945640564,0.006000000052154064 C1.0709999799728394,0.010999999940395355 0.859000027179718,0.014999999664723873 0.6449999809265137,0.013000000268220901 C0.42899999022483826,0.010999999940395355 0.21400000154972076,0.00800000037997961 0,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,9.305999755859375,7.11299991607666)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.06499999761581421 C0,0.06499999761581421 0.006000000052154064,1.8370000123977661 0.006000000052154064,1.8370000123977661 C0.41600000858306885,1.8270000219345093 0.8220000267028809,1.8040000200271606 1.2239999771118164,1.7710000276565552 C1.2239999771118164,1.7710000276565552 1.218999981880188,0 1.218999981880188,0 C0.8169999718666077,0.03400000184774399 0.4099999964237213,0.05400000140070915 0,0.06499999761581421"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,10.524999618530273,6.980000019073486)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.13199999928474426 C0,0.13199999928474426 0.004999999888241291,1.9040000438690186 0.004999999888241291,1.9040000438690186 C0.40700000524520874,1.871999979019165 0.8029999732971191,1.8270000219345093 1.194000005722046,1.7710000276565552 C1.194000005722046,1.7710000276565552 1.1890000104904175,0 1.1890000104904175,0 C0.7979999780654907,0.0560000017285347 0.4009999930858612,0.09799999743700027 0,0.13199999928474426"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,11.714000701904297,6.772000312805176)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.20900000631809235 C0,0.20900000631809235 0.004999999888241291,1.9809999465942383 0.004999999888241291,1.9809999465942383 C0.414000004529953,1.9229999780654907 0.8159999847412109,1.8530000448226929 1.2100000381469727,1.7710000276565552 C1.2100000381469727,1.7710000276565552 1.2050000429153442,0 1.2050000429153442,0 C0.8109999895095825,0.0820000022649765 0.4090000092983246,0.1509999930858612 0,0.20900000631809235"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,12.918999671936035,6.456999778747559)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.3140000104904175 C0,0.3140000104904175 0.004999999888241291,2.0859999656677246 0.004999999888241291,2.0859999656677246 C0.4410000145435333,1.9950000047683716 0.8679999709129333,1.8910000324249268 1.284999966621399,1.7730000019073486 C1.284999966621399,1.7730000019073486 1.2799999713897705,0 1.2799999713897705,0 C0.8629999756813049,0.11999999731779099 0.4359999895095825,0.22300000488758087 0,0.3140000104904175"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,14.198999404907227,5.9579997062683105)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,0.5 C0,0.5 0.004999999888241291,2.2730000019073486 0.004999999888241291,2.2730000019073486 C0.5170000195503235,2.125999927520752 1.0110000371932983,1.9589999914169312 1.4869999885559082,1.7710000276565552 C1.4869999885559082,1.7710000276565552 1.4830000400543213,0 1.4830000400543213,0 C1.0069999694824219,0.18700000643730164 0.5120000243186951,0.35499998927116394 0,0.5"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,15.680999755859375,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(255,117,0)"
                      fillOpacity={1}
                      d=" M0,5.958000183105469 C0,5.958000183105469 0.004999999888241291,7.729000091552734 0.004999999888241291,7.729000091552734 C0.6190000176429749,7.48799991607666 1.2000000476837158,7.211999893188477 1.7430000305175781,6.9039998054504395 C4.205999851226807,5.48199987411499 5.434000015258789,3.621999979019165 5.428999900817871,1.7710000276565552 C5.428999900817871,1.7710000276565552 5.423999786376953,0 5.423999786376953,0 C5.428999900817871,1.8509999513626099 4.199999809265137,3.7109999656677246 1.7380000352859497,5.132999897003174 C1.1950000524520874,5.440999984741211 0.6140000224113464,5.715000152587891 0,5.958000183105469"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,34.52799987792969,20.80299949645996)"
        opacity={1}
        style={{ display: "block" }}
      />
      <g
        transform="matrix(1,0,0,1,0,0)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(255,117,0)"
            fillOpacity={1}
            d=" M4.888000011444092,2.7070000171661377 C1.7549999952316284,4.513999938964844 0.05000000074505806,6.849999904632568 0.0010000000474974513,9.343999862670898 C-0.04399999976158142,11.857999801635742 1.6030000448226929,14.229000091552734 4.64300012588501,16.020000457763672 C4.64300012588501,16.020000457763672 34.301998138427734,33.5099983215332 34.301998138427734,33.5099983215332 C35.191001892089844,34.03499984741211 36.6510009765625,34.040000915527344 37.558998107910156,33.52299880981445 C38.46900177001953,32.99800109863281 38.47999954223633,32.15999984741211 37.59400177001953,31.63800048828125 C37.59400177001953,31.63800048828125 7.935999870300293,14.14799976348877 7.935999870300293,14.14799976348877 C5.761000156402588,12.86299991607666 4.576000213623047,11.163999557495117 4.611000061035156,9.362000465393066 C4.640999794006348,7.578999996185303 5.86899995803833,5.900000095367432 8.055000305175781,4.638000011444092 C10.333999633789062,3.3440001010894775 13.269000053405762,2.6540000438690186 16.382999420166016,2.6649999618530273 C19.492000579833984,2.678999900817871 22.402999877929688,3.3949999809265137 24.58099937438965,4.677999973297119 C24.58099937438965,4.677999973297119 62.25600051879883,26.898000717163086 62.25600051879883,26.898000717163086 C65.21499633789062,28.645000457763672 65.1780014038086,31.459999084472656 62.17900085449219,33.19200134277344 C59.19300079345703,34.88800048828125 54.119998931884766,34.86600112915039 51.237998962402344,33.167999267578125 C51.237998962402344,33.167999267578125 25.93600082397461,18.246999740600586 25.93600082397461,18.246999740600586 C25.246999740600586,17.841999053955078 24.857999801635742,17.281999588012695 24.868000030517578,16.714000701904297 C24.881999969482422,16.14299964904785 25.275999069213867,15.604999542236328 25.981000900268555,15.197999954223633 C27.461999893188477,14.354000091552734 29.834999084472656,14.362000465393066 31.270999908447266,15.21399974822998 C31.270999908447266,15.21399974822998 48.54999923706055,25.40399932861328 48.54999923706055,25.40399932861328 C49.43899917602539,25.929000854492188 50.89400100708008,25.934999465942383 51.80400085449219,25.41900062561035 C52.7140007019043,24.893999099731445 52.72700119018555,24.05299949645996 51.84299850463867,23.5310001373291 C51.84299850463867,23.5310001373291 34.560001373291016,13.33899974822998 34.560001373291016,13.33899974822998 C31.347000122070312,11.444999694824219 26.059999465942383,11.42199993133545 22.770999908447266,13.288999557495117 C21.163999557495117,14.215999603271484 20.288000106811523,15.416999816894531 20.266000747680664,16.69700050354004 C20.242000579833984,17.9689998626709 21.110000610351562,19.216999053955078 22.64699935913086,20.121999740600586 C22.64699935913086,20.121999740600586 47.94499969482422,35.040000915527344 47.94499969482422,35.040000915527344 C50.244998931884766,36.395999908447266 53.32500076293945,37.15399932861328 56.61399841308594,37.167999267578125 C59.90999984741211,37.18199920654297 63.01300048828125,36.45199966430664 65.36499786376953,35.1150016784668 C70.21800231933594,32.3129997253418 70.2770004272461,27.81399917602539 65.5479965209961,25.02400016784668 C65.5479965209961,25.02400016784668 27.874000549316406,2.803999900817871 27.874000549316406,2.803999900817871 C24.836999893188477,1.0119999647140503 20.77199935913086,0.01600000075995922 16.429000854492188,0 C12.088000297546387,-0.017999999225139618 7.986000061035156,0.9419999718666077 4.888000011444092,2.7070000171661377z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,34.525001525878906,18.583999633789062)"
        opacity={1}
        style={{ display: "block" }}
      />
      <g
        transform="matrix(1,0,0,1,34.52799987792969,19.469999313354492)"
        opacity={1}
        style={{ display: "block" }}
      />
    </g>
    <g
      clipPath="url(#__lottie_element_65)"
      transform="matrix(1,0,0,1,114,438)"
      opacity={1}
      style={{ display: "block" }}
    >
      <g
        clipPath="url(#__lottie_element_652)"
        transform="matrix(1,0,0,1,-0.37800025939941406,1.643000602722168)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g
          clipPath="url(#__lottie_element_662)"
          transform="matrix(1,0,0,1,35.566001892089844,-0.07800006866455078)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M15.979999542236328,5.426000118255615 C15.979999542236328,5.426000118255615 15.975000381469727,6.8429999351501465 15.975000381469727,6.8429999351501465 C15.975000381469727,6.821000099182129 15.975000381469727,6.796999931335449 15.975000381469727,6.775000095367432 C15.949000358581543,5.3470001220703125 14.968000411987305,4.004000186920166 13.218999862670898,2.99399995803833 C11.395999908447266,1.9579999446868896 9.04800033569336,1.406999945640564 6.558000087738037,1.4170000553131104 C4.072000026702881,1.4279999732971191 1.7430000305175781,2 0,3.0260000228881836 C0,3.0260000228881836 0.003000000026077032,1.6089999675750732 0.003000000026077032,1.6089999675750732 C1.746000051498413,0.5830000042915344 4.073999881744385,0.010999999940395355 6.561999797821045,0 C9.052000045776367,-0.009999999776482582 11.401000022888184,0.5410000085830688 13.222000122070312,1.5770000219345093 C14.972999572753906,2.5869998931884766 15.954000473022461,3.930000066757202 15.977999687194824,5.357999801635742 C15.979999542236328,5.380000114440918 15.979999542236328,5.4039998054504395 15.979999542236328,5.426000118255615z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_721)"
            transform="matrix(1,0,0,1,-0.010000228881835938,-0.07800006866455078)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_722)">
              <g
                clipPath="url(#__lottie_element_725)"
                transform="matrix(1,0,0,1,-0.010000228881835938,-0.07800006866455078)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,11.86400032043457,0.9340000152587891)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M4.116000175476074,4.492000102996826 C4.116000175476074,4.492000102996826 4.111000061035156,5.909999847412109 4.111000061035156,5.909999847412109 C4.111000061035156,5.888000011444092 4.111000061035156,5.86299991607666 4.111000061035156,5.841000080108643 C4.085000038146973,4.413000106811523 3.1040000915527344,3.069999933242798 1.3550000190734863,2.059999942779541 C0.9309999942779541,1.819000005722046 0.47699999809265137,1.6039999723434448 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.48100000619888306,0.18700000643730164 0.9330000281333923,0.4020000100135803 1.3580000400543213,0.6430000066757202 C3.1089999675750732,1.652999997138977 4.090000152587891,2.996000051498413 4.113999843597412,4.423999786376953 C4.116000175476074,4.446000099182129 4.116000175476074,4.46999979019165 4.116000175476074,4.492000102996826"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,10.72700023651123,0.5509999990463257)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.1410000324249268,0.382999986410141 C1.1410000324249268,0.382999986410141 1.1360000371932983,1.7999999523162842 1.1360000371932983,1.7999999523162842 C0.7710000276565552,1.656000018119812 0.39100000262260437,1.5290000438690186 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.3959999978542328,0.10999999940395355 0.7760000228881836,0.23800000548362732 1.1410000324249268,0.382999986410141"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,9.756999969482422,0.31199997663497925)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9750000238418579,0.23899999260902405 C0.9750000238418579,0.23899999260902405 0.9700000286102295,1.656999945640564 0.9700000286102295,1.656999945640564 C0.6539999842643738,1.565999984741211 0.33000001311302185,1.4859999418258667 0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.33500000834465027,0.0689999982714653 0.6589999794960022,0.14800000190734863 0.9750000238418579,0.23899999260902405"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,8.847999572753906,0.15500003099441528)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9129999876022339,0.15600000321865082 C0.9129999876022339,0.15600000321865082 0.9100000262260437,1.5750000476837158 0.9100000262260437,1.5750000476837158 C0.6119999885559082,1.5130000114440918 0.30799999833106995,1.4600000381469727 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.31299999356269836,0.0430000014603138 0.6159999966621399,0.0949999988079071 0.9129999876022339,0.15600000321865082"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,7.953000068664551,0.05500000715255737)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.8999999761581421,0.10100000351667404 C0.8999999761581421,0.10100000351667404 0.8949999809265137,1.5180000066757202 0.8949999809265137,1.5180000066757202 C0.6010000109672546,1.475000023841858 0.3019999861717224,1.440999984741211 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.3059999942779541,0.024000000208616257 0.6050000190734863,0.057999998331069946 0.8999999761581421,0.10100000351667404"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,7.0329999923706055,0.006000041961669922)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.921999990940094,0.04899999871850014 C0.921999990940094,0.04899999871850014 0.9190000295639038,1.4670000076293945 0.9190000295639038,1.4670000076293945 C0.6159999966621399,1.440999984741211 0.3100000023841858,1.4249999523162842 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.31299999356269836,0.00800000037997961 0.6190000176429749,0.023000000044703484 0.921999990940094,0.04899999871850014"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,6.074000358581543,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9639999866485596,0.004999999888241291 C0.9639999866485596,0.004999999888241291 0.9589999914169312,1.4229999780654907 0.9589999914169312,1.4229999780654907 C0.8009999990463257,1.4199999570846558 0.6439999938011169,1.4179999828338623 0.48399999737739563,1.4179999828338623 C0.3230000138282776,1.4179999828338623 0.16099999845027924,1.4210000038146973 0,1.4270000457763672 C0,1.4270000457763672 0.003000000026077032,0.009999999776482582 0.003000000026077032,0.009999999776482582 C0.164000004529953,0.004000000189989805 0.32499998807907104,0.0010000000474974513 0.4880000054836273,0.0010000000474974513 C0.6460000276565552,-0.0010000000474974513 0.8059999942779541,0 0.9639999866485596,0.004999999888241291"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,5.039999961853027,0.010000050067901611)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.0369999408721924,0 C1.0369999408721924,0 1.034000039100647,1.4170000553131104 1.034000039100647,1.4170000553131104 C0.6840000152587891,1.4279999732971191 0.3400000035762787,1.4520000219345093 0,1.4859999418258667 C0,1.4859999418258667 0.004999999888241291,0.0689999982714653 0.004999999888241291,0.0689999982714653 C0.3449999988079071,0.03400000184774399 0.6890000104904175,0.010999999940395355 1.0369999408721924,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.8529999256134033,0.07899999618530273)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.1920000314712524,0 C1.1920000314712524,0 1.187000036239624,1.4170000553131104 1.187000036239624,1.4170000553131104 C0.7829999923706055,1.4570000171661377 0.3880000114440918,1.5130000114440918 0,1.5820000171661377 C0,1.5820000171661377 0.003000000026077032,0.164000004529953 0.003000000026077032,0.164000004529953 C0.39100000262260437,0.09399999678134918 0.7879999876022339,0.03999999910593033 1.1920000314712524,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.128000020980835,0.24400001764297485)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.7280000448226929,0 C1.7280000448226929,0 1.725000023841858,1.4170000553131104 1.725000023841858,1.4170000553131104 C1.1269999742507935,1.524999976158142 0.5490000247955322,1.6690000295639038 0,1.8450000286102295 C0,1.8450000286102295 0.003000000026077032,0.42800000309944153 0.003000000026077032,0.42800000309944153 C0.5519999861717224,0.25099998712539673 1.1299999952316284,0.10899999737739563 1.7280000448226929,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,0.6710000038146973)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M2.13100004196167,0 C2.13100004196167,0 2.127000093460083,1.4170000553131104 2.127000093460083,1.4170000553131104 C1.3530000448226929,1.6660000085830688 0.6370000243186951,1.9809999465942383 0,2.3559999465942383 C0,2.3559999465942383 0.003000000026077032,0.9380000233650208 0.003000000026077032,0.9380000233650208 C0.640999972820282,0.5630000233650208 1.3589999675750732,0.24899999797344208 2.13100004196167,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_666)"
          transform="matrix(1,0,0,1,51.38399887084961,5.267999649047852)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M3.7170000076293945,0 C3.7170000076293945,0 3.7139999866485596,1.4170000553131104 3.7139999866485596,1.4170000553131104 C3.7079999446868896,3.3940000534057617 2.3940000534057617,5.254000186920166 0,6.664999961853027 C0,6.664999961853027 0.003000000026077032,5.247000217437744 0.003000000026077032,5.247000217437744 C2.3980000019073486,3.8359999656677246 3.7119998931884766,1.9759999513626099 3.7170000076293945,0z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_765)"
            transform="matrix(1,0,0,1,-0.1419999599456787,-0.1679999828338623)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_766)">
              <g
                clipPath="url(#__lottie_element_769)"
                transform="matrix(1,0,0,1,-0.1419999599456787,-0.1679999828338623)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,3.7129998207092285,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.004999999888241291,0 C0.004999999888241291,0 0.0020000000949949026,1.4170000553131104 0.0020000000949949026,1.4170000553131104 C0.0020000000949949026,1.4570000171661377 0,1.4950000047683716 0,1.534999966621399 C0,1.534999966621399 0.003000000026077032,0.11800000071525574 0.003000000026077032,0.11800000071525574 C0.004999999888241291,0.07800000160932541 0.004999999888241291,0.03799999877810478 0.004999999888241291,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.625999927520752,0.11899995803833008)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.08900000154972076,0 C0.08900000154972076,0 0.0860000029206276,1.4170000553131104 0.0860000029206276,1.4170000553131104 C0.07800000160932541,1.6690000295639038 0.04899999871850014,1.9199999570846558 0,2.1689999103546143 C0,2.1689999103546143 0.003000000026077032,0.75 0.003000000026077032,0.75 C0.05400000140070915,0.503000020980835 0.08299999684095383,0.25200000405311584 0.08900000154972076,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.4170000553131104,0.8680000305175781)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.21199999749660492,0 C0.21199999749660492,0 0.20900000631809235,1.4190000295639038 0.20900000631809235,1.4190000295639038 C0.1599999964237213,1.6649999618530273 0.08900000154972076,1.906999945640564 0,2.1459999084472656 C0,2.1459999084472656 0.003000000026077032,0.7289999723434448 0.003000000026077032,0.7289999723434448 C0.09399999678134918,0.49000000953674316 0.164000004529953,0.2460000067949295 0.21199999749660492,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.0739998817443848,1.5969998836517334)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.34599998593330383,0 C0.34599998593330383,0 0.34299999475479126,1.4170000553131104 0.34299999475479126,1.4170000553131104 C0.25,1.6640000343322754 0.13600000739097595,1.9110000133514404 0,2.1500000953674316 C0,2.1500000953674316 0.004999999888241291,0.7319999933242798 0.004999999888241291,0.7319999933242798 C0.14100000262260437,0.4909999966621399 0.2529999911785126,0.24699999392032623 0.34599998593330383,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.558000087738037,2.3299999237060547)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.5199999809265137,0 C0.5199999809265137,0 0.515999972820282,1.4170000553131104 0.515999972820282,1.4170000553131104 C0.36899998784065247,1.6770000457763672 0.19599999487400055,1.934000015258789 0,2.183000087738037 C0,2.183000087738037 0.004999999888241291,0.765999972820282 0.004999999888241291,0.765999972820282 C0.20100000500679016,0.5149999856948853 0.3720000088214874,0.25999999046325684 0.5199999809265137,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.7549998760223389,3.0959999561309814)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.8080000281333923,0 C0.8080000281333923,0 0.8029999732971191,1.4170000553131104 0.8029999732971191,1.4170000553131104 C0.5699999928474426,1.7139999866485596 0.3019999861717224,2.003000020980835 0,2.2820000648498535 C0,2.2820000648498535 0.004999999888241291,0.8629999756813049 0.004999999888241291,0.8629999756813049 C0.3050000071525574,0.5849999785423279 0.5730000138282776,0.296999990940094 0.8080000281333923,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.11800003051757812,3.9600000381469727)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.6419999599456787,0 C1.6419999599456787,0 1.6369999647140503,1.4190000295639038 1.6369999647140503,1.4190000295639038 C1.1710000038146973,1.8509999513626099 0.6240000128746033,2.257999897003174 0,2.634999990463257 C0,2.634999990463257 0.004999999888241291,1.218000054359436 0.004999999888241291,1.218000054359436 C0.6269999742507935,0.8410000205039978 1.1740000247955322,0.4320000112056732 1.6419999599456787,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,5.177000045776367)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.12300000339746475,0 C0.12300000339746475,0 0.11800000071525574,1.4170000553131104 0.11800000071525574,1.4170000553131104 C0.11800000071525574,1.4170000553131104 0,1.4869999885559082 0,1.4869999885559082 C0,1.4869999885559082 0.003000000026077032,0.07000000029802322 0.003000000026077032,0.07000000029802322 C0.003000000026077032,0.07000000029802322 0.12300000339746475,0 0.12300000339746475,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_670)"
          transform="matrix(1,0,0,1,29.786998748779297,9.098999977111816)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M5.125999927520752,1.7350000143051147 C5.125999927520752,1.7350000143051147 5.120999813079834,3.1519999504089355 5.120999813079834,3.1519999504089355 C5.120999813079834,3.1519999504089355 5.120999813079834,3.132999897003174 5.120999813079834,3.132999897003174 C5.110000133514404,2.674999952316284 4.796999931335449,2.244999885559082 4.23199987411499,1.9179999828338623 C3.0460000038146973,1.2450000047683716 1.1490000486373901,1.2519999742507935 0,1.9329999685287476 C0,1.9329999685287476 0.003000000026077032,0.5139999985694885 0.003000000026077032,0.5139999985694885 C1.1540000438690186,-0.16599999368190765 3.052000045776367,-0.1720000058412552 4.236000061035156,0.5009999871253967 C4.801000118255615,0.828000009059906 5.114999771118164,1.2580000162124634 5.125999927520752,1.715999960899353 C5.125999927520752,1.715999960899353 5.125999927520752,1.7350000143051147 5.125999927520752,1.7350000143051147z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_800)"
            transform="matrix(1,0,0,1,-0.437000036239624,-0.4240000247955322)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_801)">
              <g
                clipPath="url(#__lottie_element_804)"
                transform="matrix(1,0,0,1,-0.437000036239624,-0.4240000247955322)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,3.810999870300293,0.3020000457763672)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.315000057220459,1.4329999685287476 C1.315000057220459,1.4329999685287476 1.309999942779541,2.8499999046325684 1.309999942779541,2.8499999046325684 C1.309999942779541,2.8499999046325684 1.309999942779541,2.8310000896453857 1.309999942779541,2.8310000896453857 C1.2990000247955322,2.372999906539917 0.9860000014305115,1.944000005722046 0.42100000381469727,1.6169999837875366 C0.289000004529953,1.5420000553131104 0.14800000190734863,1.4759999513626099 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.15199999511241913,0.05900000035762787 0.2930000126361847,0.12399999797344208 0.42399999499320984,0.19900000095367432 C0.9890000224113464,0.5260000228881836 1.3040000200271606,0.9559999704360962 1.315000057220459,1.4140000343322754 C1.315000057220459,1.4140000343322754 1.315000057220459,1.4329999685287476 1.315000057220459,1.4329999685287476"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.446000099182129,0.17900002002716064)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.3700000047683716,0.12300000339746475 C0.3700000047683716,0.12300000339746475 0.36500000953674316,1.5399999618530273 0.36500000953674316,1.5399999618530273 C0.24799999594688416,1.49399995803833 0.12600000202655792,1.4520000219345093 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.1289999932050705,0.03500000014901161 0.25200000405311584,0.07699999958276749 0.3700000047683716,0.12300000339746475"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,3.133000135421753,0.10199999809265137)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.3179999887943268,0.07599999755620956 C0.3179999887943268,0.07599999755620956 0.31299999356269836,1.49399995803833 0.31299999356269836,1.49399995803833 C0.210999995470047,1.465000033378601 0.10700000077486038,1.4390000104904175 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.10999999940395355,0.020999999716877937 0.2160000056028366,0.04699999839067459 0.3179999887943268,0.07599999755620956"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.8359999656677246,0.050000011920928955)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.3019999861717224,0.05299999937415123 C0.3019999861717224,0.05299999937415123 0.296999990940094,1.4700000286102295 0.296999990940094,1.4700000286102295 C0.20000000298023224,1.4490000009536743 0.0989999994635582,1.430999994277954 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.10400000214576721,0.014000000432133675 0.2029999941587448,0.03200000151991844 0.3019999861717224,0.05299999937415123"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.5439999103546143,0.01699995994567871)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.29499998688697815,0.03200000151991844 C0.29499998688697815,0.03200000151991844 0.2919999957084656,1.4490000009536743 0.2919999957084656,1.4490000009536743 C0.19499999284744263,1.4359999895095825 0.09700000286102295,1.4249999523162842 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.10199999809265137,0.00800000037997961 0.19900000095367432,0.01899999938905239 0.29499998688697815,0.03200000151991844"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.249000072479248,0.0009999871253967285)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.2980000078678131,0.01600000075995922 C0.2980000078678131,0.01600000075995922 0.29499998688697815,1.4329999685287476 0.29499998688697815,1.4329999685287476 C0.19599999487400055,1.4249999523162842 0.0989999994635582,1.4199999570846558 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.10199999809265137,0.0020000000949949026 0.20100000500679016,0.00800000037997961 0.2980000078678131,0.01600000075995922"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.941999912261963,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.3100000023841858,0.0020000000949949026 C0.3100000023841858,0.0020000000949949026 0.3059999942779541,1.4190000295639038 0.3059999942779541,1.4190000295639038 C0.20399999618530273,1.4160000085830688 0.10199999809265137,1.4179999828338623 0,1.4210000038146973 C0,1.4210000038146973 0.003000000026077032,0.003000000026077032 0.003000000026077032,0.003000000026077032 C0.10499999672174454,0 0.20800000429153442,-0.0010000000474974513 0.3100000023841858,0.0020000000949949026"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.6119999885559082,0.0029999613761901855)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.33399999141693115,0 C0.33399999141693115,0 0.33000001311302185,1.4170000553131104 0.33000001311302185,1.4170000553131104 C0.21799999475479126,1.4199999570846558 0.10899999737739563,1.4290000200271606 0,1.440000057220459 C0,1.440000057220459 0.003000000026077032,0.02199999988079071 0.003000000026077032,0.02199999988079071 C0.11299999803304672,0.010999999940395355 0.2240000069141388,0.003000000026077032 0.33399999141693115,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2290000915527344,0.02599996328353882)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.38600000739097595,0 C0.38600000739097595,0 0.382999986410141,1.4170000553131104 0.382999986410141,1.4170000553131104 C0.2540000081062317,1.4299999475479126 0.12600000202655792,1.4479999542236328 0,1.4700000286102295 C0,1.4700000286102295 0.004999999888241291,0.05299999937415123 0.004999999888241291,0.05299999937415123 C0.1289999932050705,0.03099999949336052 0.25699999928474426,0.013000000268220901 0.38600000739097595,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.6669999957084656,0.078000009059906)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.5669999718666077,0 C0.5669999718666077,0 0.5619999766349792,1.4170000553131104 0.5619999766349792,1.4170000553131104 C0.36899998784065247,1.4520000219345093 0.18000000715255737,1.4989999532699585 0,1.5579999685287476 C0,1.5579999685287476 0.004999999888241291,0.14000000059604645 0.004999999888241291,0.14000000059604645 C0.18400000035762787,0.08100000023841858 0.37400001287460327,0.03500000014901161 0.5669999718666077,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,0.218999981880188)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.671999990940094,0 C0.671999990940094,0 0.6669999957084656,1.4170000553131104 0.6669999957084656,1.4170000553131104 C0.42800000309944153,1.4950000047683716 0.20100000500679016,1.593999981880188 0,1.7139999866485596 C0,1.7139999866485596 0.003000000026077032,0.29499998688697815 0.003000000026077032,0.29499998688697815 C0.20600000023841858,0.17499999701976776 0.4309999942779541,0.07699999958276749 0.671999990940094,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          clipPath="url(#__lottie_element_674)"
          transform="matrix(1,0,0,1,37.07699966430664,10.82699966430664)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M1.909000039100647,0 C1.909000039100647,0 1.906000018119812,1.4170000553131104 1.906000018119812,1.4170000553131104 C1.902999997138977,2.4179999828338623 1.2100000381469727,3.3970000743865967 0,4.110000133514404 C0,4.110000133514404 0.003000000026077032,2.691999912261963 0.003000000026077032,2.691999912261963 C1.2139999866485596,1.9789999723434448 1.906000018119812,1.0010000467300415 1.909000039100647,0z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_844)"
            transform="matrix(1,0,0,1,-0.046000003814697266,-0.44499993324279785)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_845)">
              <g
                clipPath="url(#__lottie_element_848)"
                transform="matrix(1,0,0,1,-0.046000003814697266,-0.44499993324279785)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,1.9040000438690186,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.004999999888241291,0 C0.004999999888241291,0 0.0020000000949949026,1.4170000553131104 0.0020000000949949026,1.4170000553131104 C0.0020000000949949026,1.4170000553131104 0,1.475000023841858 0,1.475000023841858 C0,1.475000023841858 0.003000000026077032,0.05700000002980232 0.003000000026077032,0.05700000002980232 C0.003000000026077032,0.05700000002980232 0.004999999888241291,0 0.004999999888241291,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.8609999418258667,0.058000028133392334)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.04600000008940697,0 C0.04600000008940697,0 0.0430000014603138,1.4170000553131104 0.0430000014603138,1.4170000553131104 C0.03999999910593033,1.5420000553131104 0.02500000037252903,1.6679999828338623 0,1.7910000085830688 C0,1.7910000085830688 0.004999999888241291,0.37299999594688416 0.004999999888241291,0.37299999594688416 C0.028999999165534973,0.24799999594688416 0.0430000014603138,0.12399999797344208 0.04600000008940697,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.753999948501587,0.4309999942779541)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.1120000034570694,0 C0.1120000034570694,0 0.10700000077486038,1.4170000553131104 0.10700000077486038,1.4170000553131104 C0.08100000023841858,1.5429999828338623 0.04600000008940697,1.6679999828338623 0,1.7910000085830688 C0,1.7910000085830688 0.003000000026077032,0.37299999594688416 0.003000000026077032,0.37299999594688416 C0.04899999871850014,0.25 0.0860000029206276,0.12600000202655792 0.1120000034570694,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.5750000476837158,0.8040000200271606)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.18199999630451202,0 C0.18199999630451202,0 0.17900000512599945,1.4170000553131104 0.17900000512599945,1.4170000553131104 C0.12999999523162842,1.5460000038146973 0.07000000029802322,1.6740000247955322 0,1.7999999523162842 C0,1.7999999523162842 0.003000000026077032,0.38100001215934753 0.003000000026077032,0.38100001215934753 C0.07500000298023224,0.25600001215934753 0.1340000033378601,0.1289999932050705 0.18199999630451202,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.3040000200271606,1.185999870300293)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.27399998903274536,0 C0.27399998903274536,0 0.2709999978542328,1.4190000295639038 0.2709999978542328,1.4190000295639038 C0.19300000369548798,1.555999994277954 0.10199999809265137,1.690000057220459 0,1.8209999799728394 C0,1.8209999799728394 0.003000000026077032,0.40400001406669617 0.003000000026077032,0.40400001406669617 C0.10700000077486038,0.27300000190734863 0.19699999690055847,0.13899999856948853 0.27399998903274536,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.8849999904632568,1.5900001525878906)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.4230000078678131,0 C0.4230000078678131,0 0.41999998688697815,1.4170000553131104 0.41999998688697815,1.4170000553131104 C0.296999990940094,1.5729999542236328 0.15600000321865082,1.725000023841858 0,1.8700000047683716 C0,1.8700000047683716 0.003000000026077032,0.453000009059906 0.003000000026077032,0.453000009059906 C0.16099999845027924,0.30799999833106995 0.30000001192092896,0.15600000321865082 0.4230000078678131,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.05700001120567322,2.0429999828338623)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.8299999833106995,0 C0.8299999833106995,0 0.8270000219345093,1.4170000553131104 0.8270000219345093,1.4170000553131104 C0.5889999866485596,1.6360000371932983 0.31299999356269836,1.843999981880188 0,2.0320000648498535 C0,2.0320000648498535 0.004999999888241291,0.6140000224113464 0.004999999888241291,0.6140000224113464 C0.3160000145435333,0.4259999990463257 0.5920000076293945,0.21899999678134918 0.8299999833106995,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,2.6569998264312744)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.06199999898672104,0 C0.06199999898672104,0 0.05700000002980232,1.4170000553131104 0.05700000002980232,1.4170000553131104 C0.05700000002980232,1.4170000553131104 0,1.4520000219345093 0,1.4520000219345093 C0,1.4520000219345093 0.003000000026077032,0.03500000014901161 0.003000000026077032,0.03500000014901161 C0.003000000026077032,0.03500000014901161 0.06199999898672104,0 0.06199999898672104,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,16.400999069213867,10.036999702453613)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M13.826000213623047,0 C13.826000213623047,0 13.821999549865723,1.4170000553131104 13.821999549865723,1.4170000553131104 C13.821999549865723,1.4170000553131104 0,9.569000244140625 0,9.569000244140625 C0,9.569000244140625 0.004000000189989805,8.152000427246094 0.004000000189989805,8.152000427246094 C0.004000000189989805,8.152000427246094 13.826000213623047,0 13.826000213623047,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,23.31399917602539,14.821999549865723)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_684)"
          transform="matrix(1,0,0,1,12.824000358581543,17.17799949645996)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M0,1.4190000295639038 C0,1.4190000295639038 0.004999999888241291,0 0.004999999888241291,0 C0.003000000026077032,0.27799999713897705 0.1889999955892563,0.5569999814033508 0.5590000152587891,0.7689999938011169 C1.2869999408721924,1.1820000410079956 2.4489998817443848,1.1779999732971191 3.1610000133514404,0.7580000162124634 C3.1610000133514404,0.7580000162124634 3.1579999923706055,2.177000045776367 3.1579999923706055,2.177000045776367 C2.446000099182129,2.5950000286102295 1.281999945640564,2.6010000705718994 0.5540000200271606,2.187999963760376 C0.1850000023841858,1.9739999771118164 0,1.6950000524520874 0,1.4190000295639038z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_879)"
            transform="matrix(1,0,0,1,-0.4190000295639038,-0.25300002098083496)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_880)">
              <g
                clipPath="url(#__lottie_element_883)"
                transform="matrix(1,0,0,1,-0.4190000295639038,-0.25300002098083496)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,2.745000123977661,0.7579999566078186)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.4169999957084656,0 C0.4169999957084656,0 0.4129999876022339,1.4190000295639038 0.4129999876022339,1.4190000295639038 C0.28700000047683716,1.4919999837875366 0.14800000190734863,1.5529999732971191 0,1.6009999513626099 C0,1.6009999513626099 0.003000000026077032,0.18400000035762787 0.003000000026077032,0.18400000035762787 C0.1509999930858612,0.13600000739097595 0.2930000126361847,0.07500000298023224 0.4169999957084656,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.3969998359680176,0.9409999847412109)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.35100001096725464,0 C0.35100001096725464,0 0.3479999899864197,1.4170000553131104 0.3479999899864197,1.4170000553131104 C0.23600000143051147,1.4539999961853027 0.11999999731779099,1.4830000400543213 0,1.5049999952316284 C0,1.5049999952316284 0.003000000026077032,0.0860000029206276 0.003000000026077032,0.0860000029206276 C0.12300000339746475,0.06499999761581421 0.23899999260902405,0.03700000047683716 0.35100001096725464,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.1610000133514404,1.027999997138977)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.23899999260902405,0 C0.23899999260902405,0 0.23600000143051147,1.4190000295639038 0.23600000143051147,1.4190000295639038 C0.15800000727176666,1.4320000410079956 0.07999999821186066,1.4429999589920044 0,1.4509999752044678 C0,1.4509999752044678 0.003000000026077032,0.03400000184774399 0.003000000026077032,0.03400000184774399 C0.08299999684095383,0.026000000536441803 0.16200000047683716,0.014000000432133675 0.23899999260902405,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.9580000638961792,1.060999870300293)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.20600000023841858,0 C0.20600000023841858,0 0.2029999941587448,1.4170000553131104 0.2029999941587448,1.4170000553131104 C0.13600000739097595,1.4229999780654907 0.06700000166893005,1.4290000200271606 0,1.4320000410079956 C0,1.4320000410079956 0.003000000026077032,0.014000000432133675 0.003000000026077032,0.014000000432133675 C0.07199999690055847,0.010999999940395355 0.13899999856948853,0.006000000052154064 0.20600000023841858,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.7680000066757202,1.0759999752044678)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.19300000369548798,0 C0.19300000369548798,0 0.1899999976158142,1.4170000553131104 0.1899999976158142,1.4170000553131104 C0.12600000202655792,1.4190000295639038 0.06400000303983688,1.4190000295639038 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.06700000166893005,0.0020000000949949026 0.13099999725818634,0.0020000000949949026 0.19300000369548798,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.5869998931884766,1.066999912261963)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.1850000023841858,0.009999999776482582 C0.1850000023841858,0.009999999776482582 0.18000000715255737,1.4270000457763672 0.18000000715255737,1.4270000457763672 C0.11900000274181366,1.4249999523162842 0.061000000685453415,1.4220000505447388 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.06400000303983688,0.004999999888241291 0.12399999797344208,0.00800000037997961 0.1850000023841858,0.009999999776482582"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.409000039100647,1.0450000762939453)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.18199999630451202,0.020999999716877937 C0.18199999630451202,0.020999999716877937 0.17900000512599945,1.437999963760376 0.17900000512599945,1.437999963760376 C0.11800000071525574,1.4329999685287476 0.05900000035762787,1.4270000457763672 0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.06199999898672104,0.009999999776482582 0.12300000339746475,0.01600000075995922 0.18199999630451202,0.020999999716877937"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2269999980926514,1.0139999389648438)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.1850000023841858,0.03200000151991844 C0.1850000023841858,0.03200000151991844 0.18199999630451202,1.4509999752044678 0.18199999630451202,1.4509999752044678 C0.11999999731779099,1.440999984741211 0.05900000035762787,1.4320000410079956 0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.06400000303983688,0.013000000268220901 0.12399999797344208,0.024000000208616257 0.1850000023841858,0.03200000151991844"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.0339999198913574,0.9670000672340393)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.19599999487400055,0.04600000008940697 C0.19599999487400055,0.04600000008940697 0.19300000369548798,1.465000033378601 0.19300000369548798,1.465000033378601 C0.12800000607967377,1.4509999752044678 0.06400000303983688,1.4359999895095825 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.06700000166893005,0.017999999225139618 0.13099999725818634,0.032999999821186066 0.19599999487400055,0.04600000008940697"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.8109999895095825,0.8920000195503235)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.2280000001192093,0.07500000298023224 C0.2280000001192093,0.07500000298023224 0.22300000488758087,1.4919999837875366 0.22300000488758087,1.4919999837875366 C0.1459999978542328,1.4709999561309814 0.07199999690055847,1.4459999799728394 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.07699999958276749,0.028999999165534973 0.1509999930858612,0.05299999937415123 0.2280000001192093,0.07500000298023224"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.8159999847412109,0.8920000195503235 C0.8159999847412109,0.8920000195503235 0.8109999895095825,2.309000015258789 0.8109999895095825,2.309000015258789 C0.722000002861023,2.2739999294281006 0.6349999904632568,2.2330000400543213 0.5540000200271606,2.187999963760376 C0.1850000023841858,1.9739999771118164 0,1.6950000524520874 0,1.4190000295639038 C0,1.4190000295639038 0.004999999888241291,0 0.004999999888241291,0 C0.003000000026077032,0.27799999713897705 0.1889999955892563,0.5569999814033508 0.5590000152587891,0.7689999938011169 C0.6389999985694885,0.8149999976158142 0.7250000238418579,0.8550000190734863 0.8159999847412109,0.8920000195503235"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,5.435999870300293,1.6090002059936523)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M30.143999099731445,0 C30.143999099731445,0 30.139999389648438,1.4179999828338623 30.139999389648438,1.4179999828338623 C30.139999389648438,1.4179999828338623 0,19.194000244140625 0,19.194000244140625 C0,19.194000244140625 0.004000000189989805,17.775999069213867 0.004000000189989805,17.775999069213867 C0.004000000189989805,17.775999069213867 30.143999099731445,0 30.143999099731445,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,20.507999420166016,11.206000328063965)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_694)"
          transform="matrix(1,0,0,1,3.559000015258789,19.33799934387207)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M0,3.9079999923706055 C0,3.9079999923706055 0.004999999888241291,2.490999937057495 0.004999999888241291,2.490999937057495 C0.00800000037997961,1.590999960899353 0.5920000076293945,0.6909999847412109 1.7599999904632568,0 C1.7599999904632568,0 1.7569999694824219,1.4190000295639038 1.7569999694824219,1.4190000295639038 C0.5870000123977661,2.1080000400543213 0.003000000026077032,3.007999897003174 0,3.9079999923706055z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_923)"
            transform="matrix(1,0,0,1,-0.12000000476837158,-0.046000003814697266)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_924)">
              <g
                clipPath="url(#__lottie_element_927)"
                transform="matrix(1,0,0,1,-0.12000000476837158,-0.046000003814697266)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,1.7119998931884766,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.04800000041723251,0 C0.04800000041723251,0 0.04500000178813934,1.4190000295639038 0.04500000178813934,1.4190000295639038 C0.04500000178813934,1.4190000295639038 0,1.444000005722046 0,1.444000005722046 C0,1.444000005722046 0.003000000026077032,0.027000000700354576 0.003000000026077032,0.027000000700354576 C0.003000000026077032,0.027000000700354576 0.04800000041723251,0 0.04800000041723251,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.9380000233650208,0.027000010013580322)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.7770000100135803,0 C0.7770000100135803,0 0.7739999890327454,1.4170000553131104 0.7739999890327454,1.4170000553131104 C0.47699999809265137,1.5959999561309814 0.21899999678134918,1.7890000343322754 0,1.9919999837875366 C0,1.9919999837875366 0.004999999888241291,0.5730000138282776 0.004999999888241291,0.5730000138282776 C0.2240000069141388,0.3720000088214874 0.4819999933242798,0.17900000512599945 0.7770000100135803,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.5550000071525574,0.5999999642372131)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.3880000114440918,0 C0.3880000114440918,0 0.382999986410141,1.4190000295639038 0.382999986410141,1.4190000295639038 C0.23800000548362732,1.5509999990463257 0.10999999940395355,1.6890000104904175 0,1.8309999704360962 C0,1.8309999704360962 0.003000000026077032,0.4129999876022339 0.003000000026077032,0.4129999876022339 C0.11500000208616257,0.2709999978542328 0.24300000071525574,0.1340000033378601 0.3880000114440918,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.30699998140335083,1.0130000114440918)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.25200000405311584,0 C0.25200000405311584,0 0.24899999797344208,1.4170000553131104 0.24899999797344208,1.4170000553131104 C0.15299999713897705,1.5369999408721924 0.07000000029802322,1.6619999408721924 0,1.7860000133514404 C0,1.7860000133514404 0.004999999888241291,0.36899998784065247 0.004999999888241291,0.36899998784065247 C0.07500000298023224,0.24300000071525574 0.15800000727176666,0.11999999731779099 0.25200000405311584,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.1419999897480011,1.3819999694824219)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.16899999976158142,0 C0.16899999976158142,0 0.164000004529953,1.4170000553131104 0.164000004529953,1.4170000553131104 C0.0989999994635582,1.531999945640564 0.04500000178813934,1.649999976158142 0,1.7680000066757202 C0,1.7680000066757202 0.003000000026077032,0.35100001096725464 0.003000000026077032,0.35100001096725464 C0.04800000041723251,0.2329999953508377 0.10400000214576721,0.11500000208616257 0.16899999976158142,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.04100000113248825,1.7329999208450317)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.10400000214576721,0 C0.10400000214576721,0 0.10100000351667404,1.4170000553131104 0.10100000351667404,1.4170000553131104 C0.057999998331069946,1.531999945640564 0.024000000208616257,1.6480000019073486 0,1.7649999856948853 C0,1.7649999856948853 0.004999999888241291,0.3479999899864197 0.004999999888241291,0.3479999899864197 C0.028999999165534973,0.23199999332427979 0.061000000685453415,0.11500000208616257 0.10400000214576721,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.0020000003278255463,2.0809998512268066)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.04500000178813934,0 C0.04500000178813934,0 0.03999999910593033,1.4170000553131104 0.03999999910593033,1.4170000553131104 C0.017999999225139618,1.534999966621399 0.003000000026077032,1.6549999713897705 0,1.7730000019073486 C0,1.7730000019073486 0.003000000026077032,0.35600000619888306 0.003000000026077032,0.35600000619888306 C0.00800000037997961,0.23600000143051147 0.020999999716877937,0.11800000071525574 0.04500000178813934,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,2.437000036239624)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.004999999888241291,0 C0.004999999888241291,0 0.0020000000949949026,1.4170000553131104 0.0020000000949949026,1.4170000553131104 C0.0020000000949949026,1.4170000553131104 0,1.4709999561309814 0,1.4709999561309814 C0,1.4709999561309814 0.004999999888241291,0.05400000140070915 0.004999999888241291,0.05400000140070915 C0.004999999888241291,0.05400000140070915 0.004999999888241291,0 0.004999999888241291,0"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,27.799001693725586,10.684000015258789)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M23.731000900268555,0 C23.731000900268555,0 23.726999282836914,1.4179999828338623 23.726999282836914,1.4179999828338623 C23.726999282836914,1.4179999828338623 0,15.409000396728516 0,15.409000396728516 C0,15.409000396728516 0.004000000189989805,13.991000175476074 0.004000000189989805,13.991000175476074 C0.004000000189989805,13.991000175476074 23.731000900268555,0 23.731000900268555,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,39.66400146484375,18.38800048828125)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_704)"
          transform="matrix(1,0,0,1,24.222000122070312,23.663000106811523)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.003000000026077032,0.27799999713897705 0.1860000044107437,0.5540000200271606 0.5550000071525574,0.7680000066757202 C1.2829999923706055,1.180999994277954 2.4519999027252197,1.1779999732971191 3.1619999408721924,0.7580000162124634 C3.1619999408721924,0.7580000162124634 3.1579999923706055,2.174999952316284 3.1579999923706055,2.174999952316284 C2.446000099182129,2.5950000286102295 1.2799999713897705,2.5980000495910645 0.5519999861717224,2.184999942779541 C0.18299999833106995,1.9730000495910645 -0.0020000000949949026,1.6950000524520874 0,1.4190000295639038z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_958)"
            transform="matrix(1,0,0,1,-0.4190000295639038,-0.2539999485015869)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_959)">
              <g
                clipPath="url(#__lottie_element_962)"
                transform="matrix(1,0,0,1,-0.4190000295639038,-0.2539999485015869)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,2.746999979019165,0.7579999566078186)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.41499999165534973,0 C0.41499999165534973,0 0.41200000047683716,1.4170000553131104 0.41200000047683716,1.4170000553131104 C0.2879999876022339,1.4900000095367432 0.14800000190734863,1.5509999990463257 0,1.5989999771118164 C0,1.5989999771118164 0.003000000026077032,0.18199999630451202 0.003000000026077032,0.18199999630451202 C0.1509999930858612,0.1340000033378601 0.29100000858306885,0.0729999989271164 0.41499999165534973,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.3979997634887695,0.940000057220459)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.35100001096725464,0 C0.35100001096725464,0 0.3479999899864197,1.4170000553131104 0.3479999899864197,1.4170000553131104 C0.23600000143051147,1.4539999961853027 0.11999999731779099,1.4830000400543213 0,1.5049999952316284 C0,1.5049999952316284 0.004999999888241291,0.0860000029206276 0.004999999888241291,0.0860000029206276 C0.125,0.06499999761581421 0.2409999966621399,0.03700000047683716 0.35100001096725464,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,2.1630001068115234,1.0269999504089355)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.2409999966621399,0 C0.2409999966621399,0 0.23600000143051147,1.4190000295639038 0.23600000143051147,1.4190000295639038 C0.1589999943971634,1.4320000410079956 0.07999999821186066,1.4429999589920044 0,1.4509999752044678 C0,1.4509999752044678 0.004999999888241291,0.032999999821186066 0.004999999888241291,0.032999999821186066 C0.08500000089406967,0.02500000037252903 0.16300000250339508,0.014000000432133675 0.2409999966621399,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.959999918937683,1.059999942779541)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.2070000022649765,0 C0.2070000022649765,0 0.2029999941587448,1.4170000553131104 0.2029999941587448,1.4170000553131104 C0.13600000739097595,1.4229999780654907 0.0689999982714653,1.4290000200271606 0,1.4320000410079956 C0,1.4320000410079956 0.003000000026077032,0.014000000432133675 0.003000000026077032,0.014000000432133675 C0.07199999690055847,0.010999999940395355 0.14000000059604645,0.006000000052154064 0.2070000022649765,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.7690000534057617,1.0740000009536743)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.19300000369548798,0 C0.19300000369548798,0 0.1899999976158142,1.4170000553131104 0.1899999976158142,1.4170000553131104 C0.12600000202655792,1.4190000295639038 0.06400000303983688,1.4190000295639038 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.06700000166893005,0.0020000000949949026 0.13099999725818634,0.0020000000949949026 0.19300000369548798,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.587999939918518,1.065000057220459)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.18700000643730164,0.009999999776482582 C0.18700000643730164,0.009999999776482582 0.18199999630451202,1.4270000457763672 0.18199999630451202,1.4270000457763672 C0.12099999934434891,1.4249999523162842 0.061000000685453415,1.4220000505447388 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.06599999964237213,0.004999999888241291 0.12600000202655792,0.00800000037997961 0.18700000643730164,0.009999999776482582"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.409000039100647,1.0440000295639038)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.18400000035762787,0.020999999716877937 C0.18400000035762787,0.020999999716877937 0.17900000512599945,1.437999963760376 0.17900000512599945,1.437999963760376 C0.11999999731779099,1.4329999685287476 0.05900000035762787,1.4270000457763672 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.06400000303983688,0.008999999612569809 0.12300000339746475,0.01600000075995922 0.18400000035762787,0.020999999716877937"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.2259999513626099,1.0109999179840088)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.18700000643730164,0.03200000151991844 C0.18700000643730164,0.03200000151991844 0.18400000035762787,1.4490000009536743 0.18400000035762787,1.4490000009536743 C0.12200000137090683,1.440999984741211 0.061000000685453415,1.4299999475479126 0,1.4190000295639038 C0,1.4190000295639038 0.004999999888241291,0 0.004999999888241291,0 C0.06400000303983688,0.013000000268220901 0.12600000202655792,0.024000000208616257 0.18700000643730164,0.03200000151991844"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,1.0339999198913574,0.9649999737739563)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.19599999487400055,0.04600000008940697 C0.19599999487400055,0.04600000008940697 0.19200000166893005,1.465000033378601 0.19200000166893005,1.465000033378601 C0.12700000405311584,1.4509999752044678 0.06199999898672104,1.434999942779541 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.06499999761581421,0.017999999225139618 0.13099999725818634,0.032999999821186066 0.19599999487400055,0.04600000008940697"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0.8089999556541443,0.8890000581741333)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.2280000001192093,0.07699999958276749 C0.2280000001192093,0.07699999958276749 0.22499999403953552,1.49399995803833 0.22499999403953552,1.49399995803833 C0.1469999998807907,1.472000002861023 0.07199999690055847,1.4459999799728394 0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.07599999755620956,0.028999999165534973 0.1509999930858612,0.054999999701976776 0.2280000001192093,0.07699999958276749"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.8119999766349792,0.8889999985694885 C0.8119999766349792,0.8889999985694885 0.8090000152587891,2.308000087738037 0.8090000152587891,2.308000087738037 C0.7179999947547913,2.2709999084472656 0.6320000290870667,2.2309999465942383 0.5519999861717224,2.184999942779541 C0.18299999833106995,1.9730000495910645 -0.0020000000949949026,1.6950000524520874 0,1.4190000295639038 C0,1.4190000295639038 0.003000000026077032,0 0.003000000026077032,0 C0.003000000026077032,0.27799999713897705 0.1860000044107437,0.5540000200271606 0.5550000071525574,0.7680000066757202 C0.6359999775886536,0.8140000104904175 0.7229999899864197,0.8539999723434448 0.8119999766349792,0.8889999985694885"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,16.88399887084961,13.963998794555664)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g opacity={1} transform="matrix(1,0,0,1,0,0)">
            <path
              fill="rgb(218,166,92)"
              fillOpacity={1}
              d=" M20.243000030517578,0 C20.243000030517578,0 20.23900032043457,1.4170000553131104 20.23900032043457,1.4170000553131104 C20.23900032043457,1.4170000553131104 0,13.35200023651123 0,13.35200023651123 C0,13.35200023651123 0.004000000189989805,11.9350004196167 0.004000000189989805,11.9350004196167 C0.004000000189989805,11.9350004196167 20.243000030517578,0 20.243000030517578,0z"
            />
          </g>
        </g>
        <g
          transform="matrix(1,0,0,1,27.0049991607666,20.639999389648438)"
          opacity={1}
          style={{ display: "block" }}
        />
        <g
          clipPath="url(#__lottie_element_714)"
          transform="matrix(1,0,0,1,-0.055999755859375,21.434999465942383)"
          opacity={1}
          style={{ display: "block" }}
        >
          <g
            transform="matrix(1,0,0,1,0,0)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g opacity={1} transform="matrix(1,0,0,1,0,0)">
              <path
                fill="rgb(218,166,92)"
                fillOpacity={1}
                d=" M0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0,1.4809999465942383 0.9829999804496765,2.9670000076293945 2.9539999961853027,4.105000019073486 C4.835999965667725,5.176000118255615 7.317999839782715,5.757999897003174 9.954000473022461,5.747000217437744 C12.583999633789062,5.736000061035156 15.04800033569336,5.13100004196167 16.88800048828125,4.046000003814697 C16.88800048828125,4.046000003814697 16.882999420166016,5.4629998207092285 16.882999420166016,5.4629998207092285 C15.043999671936035,6.547999858856201 12.581000328063965,7.1539998054504395 9.949000358581543,7.164000034332275 C7.313000202178955,7.175000190734863 4.830999851226807,6.5929999351501465 2.9489998817443848,5.521999835968018 C0.9779999852180481,4.383999824523926 -0.004999999888241291,2.8980000019073486 0,1.4170000553131104z"
              />
            </g>
          </g>
          <g
            clipPath="url(#__lottie_element_1002)"
            transform="matrix(1,0,0,1,-0.055999755859375,-0.4179999828338623)"
            opacity={1}
            style={{ display: "block" }}
          >
            <g mask="url(#__lottie_element_1003)">
              <g
                clipPath="url(#__lottie_element_1006)"
                transform="matrix(1,0,0,1,-0.055999755859375,-0.4179999828338623)"
                opacity={1}
                style={{ display: "block" }}
              >
                <g
                  transform="matrix(1,0,0,1,14.632999420166016,4.045000076293945)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M2.255000114440918,0 C2.255000114440918,0 2.25,1.4170000553131104 2.25,1.4170000553131104 C1.5770000219345093,1.8140000104904175 0.8190000057220459,2.1480000019073486 0,2.4110000133514404 C0,2.4110000133514404 0.004999999888241291,0.9940000176429749 0.004999999888241291,0.9940000176429749 C0.8240000009536743,0.7310000061988831 1.5820000171661377,0.3970000147819519 2.255000114440918,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,12.812000274658203,5.039999961853027)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.8259999752044678,0 C1.8259999752044678,0 1.8209999799728394,1.4170000553131104 1.8209999799728394,1.4170000553131104 C1.2419999837875366,1.6039999723434448 0.6320000290870667,1.753999948501587 0,1.86899995803833 C0,1.86899995803833 0.003000000026077032,0.4519999921321869 0.003000000026077032,0.4519999921321869 C0.6349999904632568,0.3370000123977661 1.246999979019165,0.1850000023841858 1.8259999752044678,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,11.557000160217285,5.491000175476074)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.2580000162124634,0 C1.2580000162124634,0 1.253999948501587,1.4170000553131104 1.253999948501587,1.4170000553131104 C0.843999981880188,1.4900000095367432 0.4259999990463257,1.5479999780654907 0,1.590999960899353 C0,1.590999960899353 0.003000000026077032,0.17399999499320984 0.003000000026077032,0.17399999499320984 C0.42899999022483826,0.13099999725818634 0.8489999771118164,0.0729999989271164 1.2580000162124634,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,10.464999198913574,5.664999961853027)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.0959999561309814,0 C1.0959999561309814,0 1.093000054359436,1.4170000553131104 1.093000054359436,1.4170000553131104 C0.734000027179718,1.4520000219345093 0.36899998784065247,1.4780000448226929 0,1.4889999628067017 C0,1.4889999628067017 0.004999999888241291,0.07199999690055847 0.004999999888241291,0.07199999690055847 C0.37400001287460327,0.05900000035762787 0.7369999885559082,0.03500000014901161 1.0959999561309814,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,9.4399995803833,5.737000465393066)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.0290000438690186,0 C1.0290000438690186,0 1.024999976158142,1.4170000553131104 1.024999976158142,1.4170000553131104 C0.8539999723434448,1.4229999780654907 0.6830000281333923,1.4270000457763672 0.5090000033378601,1.4270000457763672 C0.33799999952316284,1.4290000200271606 0.16899999976158142,1.4270000457763672 0,1.4220000505447388 C0,1.4220000505447388 0.003000000026077032,0.004999999888241291 0.003000000026077032,0.004999999888241291 C0.1720000058412552,0.009999999776482582 0.34299999475479126,0.012000000104308128 0.5139999985694885,0.009999999776482582 C0.6859999895095825,0.009999999776482582 0.8579999804496765,0.006000000052154064 1.0290000438690186,0"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,8.46500015258789,5.688999652862549)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9779999852180481,0.05299999937415123 C0.9779999852180481,0.05299999937415123 0.9750000238418579,1.4700000286102295 0.9750000238418579,1.4700000286102295 C0.6460000276565552,1.4620000123977661 0.32100000977516174,1.444000005722046 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.32600000500679016,0.027000000700354576 0.6510000228881836,0.04500000178813934 0.9779999852180481,0.05299999937415123"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,7.513999938964844,5.5839996337890625)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9559999704360962,0.10499999672174454 C0.9559999704360962,0.10499999672174454 0.9509999752044678,1.5219999551773071 0.9509999752044678,1.5219999551773071 C0.6299999952316284,1.496000051498413 0.31299999356269836,1.4620000123977661 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.3160000145435333,0.04500000178813934 0.6340000033378601,0.07900000363588333 0.9559999704360962,0.10499999672174454"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,6.548999786376953,5.4170002937316895)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M0.9670000076293945,0.1679999977350235 C0.9670000076293945,0.1679999977350235 0.9639999866485596,1.5850000381469727 0.9639999866485596,1.5850000381469727 C0.6370000243186951,1.5390000343322754 0.3160000145435333,1.4819999933242798 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.3190000057220459,0.06499999761581421 0.6399999856948853,0.12200000137090683 0.9670000076293945,0.1679999977350235"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,5.525000095367432,5.165999889373779)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.027999997138977,0.25099998712539673 C1.027999997138977,0.25099998712539673 1.024999976158142,1.6679999828338623 1.024999976158142,1.6679999828338623 C0.675000011920929,1.5959999561309814 0.33399999141693115,1.5110000371932983 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0.3370000123977661,0.09399999678134918 0.6800000071525574,0.17900000512599945 1.027999997138977,0.25099998712539673"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,4.340000152587891,4.764999866485596)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M1.190999984741211,0.4009999930858612 C1.190999984741211,0.4009999930858612 1.1859999895095825,1.8179999589920044 1.1859999895095825,1.8179999589920044 C0.7770000100135803,1.7009999752044678 0.3799999952316284,1.5670000314712524 0,1.4170000553131104 C0,1.4170000553131104 0.003000000026077032,0 0.003000000026077032,0 C0.3840000033378601,0.15000000596046448 0.781000018119812,0.2849999964237213 1.190999984741211,0.4009999930858612"
                    />
                  </g>
                </g>
                <g
                  transform="matrix(1,0,0,1,0,0)"
                  opacity={1}
                  style={{ display: "block" }}
                >
                  <g opacity={1} transform="matrix(1,0,0,1,0,0)">
                    <path
                      fill="rgb(218,166,92)"
                      fillOpacity={1}
                      d=" M4.3420000076293945,4.764999866485596 C4.3420000076293945,4.764999866485596 4.339000225067139,6.183000087738037 4.339000225067139,6.183000087738037 C3.8469998836517334,5.989999771118164 3.382999897003174,5.769000053405762 2.9489998817443848,5.521999835968018 C0.9779999852180481,4.383999824523926 -0.004999999888241291,2.8980000019073486 0,1.4170000553131104 C0,1.4170000553131104 0.004999999888241291,0 0.004999999888241291,0 C0,1.4809999465942383 0.9829999804496765,2.9670000076293945 2.9539999961853027,4.105000019073486 C3.385999917984009,4.3520002365112305 3.8499999046325684,4.572000026702881 4.3420000076293945,4.764999866485596"
                    />
                  </g>
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,27.621999740600586,16.64299964904785)"
        opacity={1}
        style={{ display: "block" }}
      />
      <g
        transform="matrix(1,0,0,1,0.0039997100830078125,0)"
        opacity={1}
        style={{ display: "block" }}
      >
        <g opacity={1} transform="matrix(1,0,0,1,0,0)">
          <path
            fill="rgb(233,189,111)"
            fillOpacity={1}
            d=" M51.33000183105469,2.1659998893737793 C53.83599853515625,3.611999988555908 55.20000076293945,5.480999946594238 55.237998962402344,7.47599983215332 C55.275001525878906,9.487000465393066 53.957000732421875,11.383999824523926 51.525001525878906,12.817000389099121 C51.525001525878906,12.817000389099121 27.79800033569336,26.80900001525879 27.79800033569336,26.80900001525879 C27.08799934387207,27.229000091552734 25.920000076293945,27.231000900268555 25.191999435424805,26.81800079345703 C24.465999603271484,26.398000717163086 24.45599937438965,25.72800064086914 25.165000915527344,25.309999465942383 C25.165000915527344,25.309999465942383 48.89099884033203,11.319000244140625 48.89099884033203,11.319000244140625 C50.63100051879883,10.293000221252441 51.57899856567383,8.930999755859375 51.54999923706055,7.491000175476074 C51.5260009765625,6.063000202178955 50.54499816894531,4.7210001945495605 48.79399871826172,3.7109999656677246 C46.972999572753906,2.674999952316284 44.624000549316406,2.124000072479248 42.13399887084961,2.134000062942505 C39.645999908447266,2.1449999809265137 37.31800079345703,2.7170000076293945 35.57500076293945,3.743000030517578 C35.57500076293945,3.743000030517578 5.434999942779541,21.51799964904785 5.434999942779541,21.51799964904785 C3.068000078201294,22.916000366210938 3.0980000495910645,25.16900062561035 5.497000217437744,26.55299949645996 C7.886000156402588,27.910999298095703 11.944000244140625,27.893999099731445 14.25,26.534000396728516 C14.25,26.534000396728516 34.49100112915039,14.597999572753906 34.49100112915039,14.597999572753906 C35.04199981689453,14.27400016784668 35.35300064086914,13.82699966430664 35.345001220703125,13.371999740600586 C35.33399963378906,12.913999557495117 35.02000045776367,12.484999656677246 34.45500183105469,12.157999992370605 C33.270999908447266,11.484999656677246 31.37299919128418,11.491000175476074 30.222000122070312,12.170999526977539 C30.222000122070312,12.170999526977539 16.399999618530273,20.322999954223633 16.399999618530273,20.322999954223633 C15.687999725341797,20.743000030517578 14.524999618530273,20.746999740600586 13.79699993133545,20.333999633789062 C13.069000244140625,19.913999557495117 13.057999610900879,19.242000579833984 13.767000198364258,18.823999404907227 C13.767000198364258,18.823999404907227 27.591999053955078,10.67199993133545 27.591999053955078,10.67199993133545 C30.160999298095703,9.156000137329102 34.39099884033203,9.138999938964844 37.02299880981445,10.630999565124512 C38.308998107910156,11.375 39.00899887084961,12.333999633789062 39.027000427246094,13.357999801635742 C39.04600143432617,14.375 38.35200119018555,15.373000144958496 37.12200164794922,16.097999572753906 C37.12200164794922,16.097999572753906 16.884000778198242,28.033000946044922 16.884000778198242,28.033000946044922 C15.043999671936035,29.118000030517578 12.579000473022461,29.722999572753906 9.949000358581543,29.733999252319336 C7.313000202178955,29.7450008392334 4.831999778747559,29.163000106811523 2.950000047683716,28.091999053955078 C-0.9340000152587891,25.850000381469727 -0.9810000061988831,22.250999450683594 2.8010001182556152,20.020999908447266 C2.8010001182556152,20.020999908447266 32.94200134277344,2.24399995803833 32.94200134277344,2.24399995803833 C35.37099838256836,0.8090000152587891 38.62200164794922,0.013000000268220901 42.097999572753906,0 C45.569000244140625,-0.014000000432133675 48.85200119018555,0.7540000081062317 51.33000183105469,2.1659998893737793z"
          />
        </g>
      </g>
      <g
        transform="matrix(1,0,0,1,27.624000549316406,14.867000579833984)"
        opacity={1}
        style={{ display: "block" }}
      />
      <g
        transform="matrix(1,0,0,1,27.621999740600586,15.576000213623047)"
        opacity={1}
        style={{ display: "block" }}
      />
    </g>
  </g>
</svg>

)
