import React, { useEffect, useRef } from 'react';
import videojs from 'video.js';
import 'video.js/dist/video-js.css';

const VideoPlayer = ({ ...props }: HTMLVideoElement) => {
    const videoRef = useRef<HTMLVideoElement | null>(null);
    const playerRef = useRef<any>(null); // We use `any` for video.js player type

    useEffect(() => {
        if (videoRef.current && !playerRef.current) {
            // Initialize the video.js player
            playerRef.current = videojs(videoRef.current, {
                controls: true,
                preload: 'auto',
            });
        }

        return () => {
            // Dispose the player on component unmount
            if (playerRef.current) {
                playerRef.current.dispose();
                playerRef.current = null;
            }
        };
    }, []);

    return (
        <div data-vjs-player>
            <video
                ref={videoRef}
                className={"video-js " + props.className}
                src={props.src}
                playsInline
            ></video>
        </div>
    );
};

export default VideoPlayer;
