import { InputHTMLAttributes } from 'react'
import TextInput from './TextInput'
import FormElement from './FormElement'

type Props = InputHTMLAttributes<HTMLInputElement> & {
    label?: string
    error?: string
    labelClassName?:string
}

const FormInput = ({ label,labelClassName, error, ...props }: Props) => {
    return (
        <FormElement error={error} label={label} labelClassName={labelClassName}>
            <TextInput type={props.type} {...props} />
        </FormElement>
    )
}

export default FormInput
