import { Modal, PrimaryButton } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import SecondaryButton from '@/Trash/Comps/SecondaryButton'
import { User } from '@/types'
import { ID } from '@/types/models'
import { Teacher } from '@/types/models/teacher'
import { ButtonAdd, TeacherForm, TeacherTable } from '@/Ui'
import { useForm } from '@inertiajs/react'
import Item from 'antd/es/list/Item'
import { FormEventHandler, useState } from 'react'

type Props = {
    teachers: Teacher[]
}

const Teachers = ({ teachers }: Props) => {

    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')

    const [selectedItem, setSelectedItem] = useState<Teacher & User>()


    const handleAdd = () => {
        setModalOpen(true)
        setSelectedItem(undefined)
        setModelSection('form')
    }
    const handleUpdate = (item: Teacher) => {
        setModalOpen(true)
        setSelectedItem({ ...item, ...item.user })
        setModelSection('form')
    }
    const handleDelete = (item: Teacher) => {
        setModalOpen(true)
        setSelectedItem({ ...item, ...item.user })
        setModelSection('delete')
    }

    const form = useForm<Teacher & User>({
        id: 0,
        name: '',
        email: '',
        phone: '',
        password: '',
        first_name: '',
        last_name: '',
        bio: '',
        tags: [],
        image: undefined,
        user_id: 0,
        user: {
            id: 0,
            name: '',
            email: '',
            phone: '',
            password: '',
            first_name: '',
            last_name: '',
        }
    })

    const createTeacher: FormEventHandler = (e) => {
        e.preventDefault()
        form.post(route('admin.teacher.createOne'), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }
    const updateTeacher: FormEventHandler = (e) => {
        e.preventDefault()
        form.put(route('admin.teacher.updateOne', selectedItem?.id), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    const DeleteForm = ({ id, onClose, show }: { id: ID, onClose: CallableFunction, show: boolean }) => {

        const form = useForm()

        const submit: FormEventHandler = (e) => {
            e.preventDefault()
            form.delete(route('admin.material.deleteOne', { id }), {
                onSuccess: () => {
                    onClose()
                }
            })
        }

        return <div  >
            <p className="p-4 ">
                هل تريد حقا حذف هذا المعلم!
            </p>
            <div className="mt-5 items-center gap-3 flex ">
                <PrimaryButton className='bg-red-500' onClick={submit} >نعم</PrimaryButton>
                <SecondaryButton onClick={() => onClose()} >لا</SecondaryButton>
            </div>
        </div>
    }

    return (
        <DashboardLayout title='المعلمون' headChild={<ButtonAdd onClick={handleAdd} />}>
            <Modal show={modalOpen} onClose={() => setModalOpen(false)}>
                {modelSection === 'form' && <TeacherForm form={form} submit={selectedItem ? updateTeacher : createTeacher} />}
                {(modelSection === 'delete' && selectedItem) && <DeleteForm show={modalOpen} id={selectedItem?.id} onClose={close} />}
            </Modal>
            <TeacherTable teachers={teachers} onDelete={handleDelete} onEdit={handleUpdate} />
        </DashboardLayout>
    )
}

export default Teachers
