import StudentLayout from '@/Layouts/StudentLayout'
import { PageProps } from '@/types'
import { MaterialNote } from '@/types/models/material'

type Props = {
    notes: MaterialNote[]
}

const CourseNotes = ({ auth, notes }: PageProps<Props>) => {
  return (
    <StudentLayout title='المدكرات'>
        <div className="w-1/2 flex items-center gap-5 flex-col mx-auto rounded-xl mt-5 px-10 py-10 bg-indigo-950 text-center text-white">
            <div className="">
                <img src="https://img.icons8.com/?size=100&id=uLgT77pDPQOY&format=png&color=000000" alt="" />
            </div>
            <h1 className="font-semibold text-2xl">المدكرات</h1>
            <div className="mt-5">
                {notes.map((note,i)=> <div key={i} className="border mb-3 p-4 flex gap-3 items-center">
                    <img src={note.icon} alt={note.title} />
                    <h2 className='text-md' >
                        {note.title}
                    </h2>
                </div> )}
            </div>
        </div>
    </StudentLayout>
  )
}

export default CourseNotes
