import { ArrowDown, ArrowUp, Edit } from 'lucide-react'
import { ButtonHTMLAttributes } from 'react'

type Props = {
    status: boolean
}

const ButtonDelete = ({ status, ...props }: ButtonHTMLAttributes<HTMLButtonElement> & Props) => {
    return (
        <button
            {...props}
            type="button"
            className="h-6 w-6  justify-center text-[12px] font-medium text-center inline-flex items-center text-white bg-orange-700 rounded-lg hover:bg-orange-800 focus:ring-4 focus:outline-none focus:ring-orange-300 dark:bg-orange-600 dark:hover:bg-orange-700 dark:focus:ring-orange-800"
        >
            {status? <ArrowUp size={15} /> : <ArrowDown size={15} />}
        </button>

    )
}

export default ButtonDelete
