import { Dropdown } from '@/Components'
import { Link, usePage } from '@inertiajs/react'
import { Info, User } from 'lucide-react'
import React from 'react'

type Props = {}

const DashboardNav = (props: Props) => {

    const page = usePage()

    const auth = page.props.auth

    return (
        <div className="h-14 flex border-b px-4 py-6 items-center justify-between bg-gray-50 " >
                <Info />
            <Dropdown >
                <Dropdown.Trigger>
                    <div className="px-5 flex gap-3  cursor-pointer opacity-80 hover:opacity-100" >
                        <strong className='font-semibold text-xl '>
                            {auth.user.name}
                        </strong>
                        <User />
                    </div>
                </Dropdown.Trigger>

                <Dropdown.Content>
                    {/* <Dropdown.Link
                            href={route('profile.edit')}
                        >
                            Profile
                        </Dropdown.Link> */}
                    <Dropdown.Link
                        href={route('admin.logout')}
                        method="post"
                        as="button"
                    >
                        تسجيل الخروج
                    </Dropdown.Link>
                </Dropdown.Content>
            </Dropdown>
        </div>
    )
}

export default DashboardNav
