import { Link, usePage } from '@inertiajs/react'
import { ApplicationLogo } from '../../Components'
import { BrandLayoutConfigProps, NavLayoutConfigProps } from '@/types/models/layout'
import { UserTypeEnum } from '@/Enums/UserTypeEnum'

type Props = {
    data?: NavLayoutConfigProps
    brand?: BrandLayoutConfigProps

}

const PublicNav = ({ data, brand }: Props) => {

    if (!data) {
        return
    }

    const auth = usePage().props.auth

    return (
        <div className="h-14 flex px-4 py-8 items-center justify-between bg-black " style={{ background: data?.bg_color }}>
            {/* Logo Section */}
            <Link href={route('public.home')} >
                <ApplicationLogo
                    src={brand?.logo.light}
                    height={data?.logo.height}
                    width={data?.logo.width}
                    className={`h-[${data?.logo.height}px] object-contain p-4`}
                />
            </Link>

            {/* Menu Links */}
            <div className="flex gap-6 items-center">
                {(auth.user ? [
                    {
                        text: 'لوحة التحكم',
                        href: auth.user.type === UserTypeEnum.STUDENT ? route('student.home') :  route('admin.dashboard')
                    }
                ] : data?.menu).map((link, index) => (
                    <Link key={index} href={link.href} className="text-white hover:text-gray-100 hover:bg-black p-2">
                        {link.text}
                    </Link>
                ))}
            </div>
        </div>
    )
}

export default PublicNav

/**
 * ${data?.logo.mode === 'light' ? 'light-logo' : ''}
                    ${data?.logo.mode === 'dark' ? 'dark-logo' : ''}
 */
