import React, { useEffect, useState } from "react";
import { Select, Spin } from "antd";
import axios from "axios";
import { FormElement } from "@/Components";

const { Option } = Select;

interface Country {
    translations: { ara: {official: string} };
    cca2: string; // Country code
}

const CountrySelect: React.FC<{ onChange?: (value: string) => void }> = ({ onChange }) => {
    const [countries, setCountries] = useState<{ label: string; value: string }[]>([]);
    const [loading, setLoading] = useState<boolean>(true);

    useEffect(() => {
        const fetchCountries = async () => {
            try {
                const response = await axios.get<Country[]>("https://restcountries.com/v3.1/all");
                const formattedCountries = response.data
                    .map((country) => ({
                        label: country.translations.ara.official, // Label to display
                        value: country.cca2, // Value to store
                    }))
                    .sort((a, b) => a.label.localeCompare(b.label));

                setCountries(formattedCountries);
            } catch (error) {
                console.error("Error fetching countries:", error);
            } finally {
                setLoading(false);
            }
        };

        fetchCountries();
    }, []);

    return (
        <FormElement label="الدولة">
            <Select
                showSearch
                placeholder="إختر الدولة"
                loading={loading}
                disabled={loading}
                onChange={onChange}
                filterOption={(input, option) =>
                    option?.label.toLowerCase().includes(input.toLowerCase()) ?? false
                }
                options={countries} // Use the options prop instead of manually mapping
                style={{ width: "100%",height:'40px' }}

            />
        </FormElement>
    );
};

export default CountrySelect;
