import { FormCheckbox, FormInput, PrimaryButton } from '@/Components'
import { useFormProps } from '@/types/app'
import { Course } from '@/types/models/course'
import { Divider } from 'antd'
import React, { FormEventHandler } from 'react'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Course>
}

const CourseForm = ({form,submit}: Props) => {
    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات المنهج</Divider>
            <FormInput label='العنوان' name='title' value={form.data.title} onChange={e => form.setData('title', e.target.value)} error={form.errors.title} />
            <FormInput label='الوصف' name='description' value={form.data.description} onChange={e => form.setData('description', e.target.value)} error={form.errors.description} />
            <FormInput label='رقم المنهج' name='number' value={ form.data.number } onChange={e => form.setData('number', e.target.value)} error={form.errors.number} />
            <FormCheckbox label='نشط' name='is_active' checked={form.data.is_active} onChange={e => form.setData('is_active', e.target.checked)} error={form.errors.is_active} />
            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default CourseForm
