import { FormElement, FormInput, ImageOrUpload, PrimaryButton } from "@/Components"
import { useFormProps } from "@/types/app"
import { ID } from "@/types/models"
import { Course } from "@/types/models/course"
import { CourseNote } from "@/types/models/course-note"
import { CourseSection } from "@/types/models/course_section"
import { isEmpty } from "@/Utils"
import { Select } from "antd"
import { FormEventHandler, useEffect, useState } from "react"
import ReactQuill from 'react-quill';
import 'react-quill/dist/quill.snow.css';

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<CourseNote>
    courses: Course[]
}

const CourseNoteForm = ({ form, submit, courses }: Props) => {

    const [courseSelected, setCourseSelected] = useState<Course>(form.data.course as Course)
    const [courseSectionSelected, setCourseSectionSelected] = useState<ID>(form.data.course_section_id)
    const [value, setValue] = useState(form.data.content);


    useEffect(() => {
        if (!isEmpty(value)) form.setData('content', value)
    }, [value])

    useEffect(() => {
        if (courseSelected) form.setData('course_id', courseSelected.id)
    }, [courseSelected])

    useEffect(() => {
        if (courseSectionSelected) form.setData('course_section_id', courseSectionSelected)
    }, [courseSectionSelected])

    const onSelect = (selected: ID) => {
        if (selected) {
            const course = courses.find(m => m.id === selected)
            if (course) setCourseSelected(course)
        }
    }

    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <FormElement label='المنهج' error={form.errors.course_id}  >
                <Select className='w-full' onSelect={onSelect} value={courseSelected?.id}>
                    {courses.map(m => <Select.Option value={m.id} key={m.id} > {m.title} </Select.Option>)}
                </Select>
            </FormElement>
            {courseSelected && <FormElement label='قسم المنهج' error={form.errors.course_section_id}  >
                <Select className='w-full' onSelect={s => setCourseSectionSelected(s)} value={courseSectionSelected}>
                    {courseSelected.sections?.map(m => <Select.Option value={m.id} key={m.id} > {m.title} </Select.Option>)}
                </Select>
            </FormElement>}
            <FormInput label='النوع' name='type' value={form.data.type} onChange={e => form.setData('type', e.target.value)} error={form.errors.type} />
            <ImageOrUpload image={form.data.image} onSuccess={res => form.setData('image', res.file_path)} />

            <FormElement label='المذكرة' >
                <ReactQuill className="h-[200px] mb-5" theme="snow" value={value} onChange={setValue} />
            </FormElement>

            <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
        </form>
    )
}

export default CourseNoteForm
