import { FormInput, ImageOrUpload, PrimaryButton } from "@/Components"
import { useFormProps } from "@/types/app"
import { ExamTask } from "@/types/models/exam"
import { Divider } from "antd"
import { FormEventHandler, useEffect, useState } from "react"
import { ButtonCreate, ButtonDelete } from ".."
import { removeDuplicatesArr } from "@/Utils"

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<ExamTask>
}

const ExamTaskForm = ({ form, submit }: Props) => {

    const [choiceText, setChoiceText] = useState<string>('')
    const [choices, setChoices] = useState<string[]>(form.data.choices)

    const addChoice = () => {
        setChoices(removeDuplicatesArr([...choices, choiceText]))
    }

    useEffect(()=>{
        form.setData('choices',choices)
    },[choices])

    return (
        <form className='flex flex-col gap-3' onSubmit={submit}>
            <Divider orientation="left" >معلومات سؤال الإمتحان</Divider>
            <FormInput label="السؤال" value={form.data.question} onChange={e => form.setData('question', e.target.value)} error={form.errors.question} />
            <FormInput label="الإجابة الصحيحة" value={form.data.answer} onChange={e => form.setData('answer', e.target.value)} error={form.errors.answer} />
            <div className="flex items-end gap-3 p-2 bg-gray-50">
                <FormInput className="w-full flex-1" label="أضف خيارات الإجابة" onChange={e => setChoiceText(e.target.value)} />
                <ButtonCreate onClick={addChoice} />
            </div>
            {choices.map((m, i) => <div className="flex justify-between p-2 border rounded-md m-2 gap-2" key={i}>
                <span> {m}</span>
                <ButtonDelete onClick={() => setChoices(choices.filter((_, k) => k !== i))} />
            </div>)}
            <ImageOrUpload image={form.data.image} onSuccess={res => form.setData('image', res.file_path)} />
            <FormInput label="الوقت الذي تظهر فيه الإجابة أو الشرح من فيديو الشرح" value={form.data.video_time} onChange={e => form.setData('video_time', e.target.value)} error={form.errors.video_time} />
            <FormInput label="النقاط" value={form.data.points} onChange={e => form.setData('points', e.target.value)} error={form.errors.points} />

                    <PrimaryButton className='mt-5' >حفظ</PrimaryButton>

        </form>

    )
}

export default ExamTaskForm
