import { ensureHttpsUrl } from '@/Utils';
import { PrimaryButton } from '../../Components';
import { useLayout} from '../../Hooks';
import { APP_URL } from '@/Constants';


const SectionHero = () => {

    const data = useLayout('section_hero')

    if (!data) {
        return
    }

    return (
        <div className={`text-white flex flex-col  items-center md:flex-row lg:flex-row px-8 py-20 border-b border-e-red-50`} >
            <div className="  ">
                <h1 className='text-6xl mb-10 leading-relaxed font-bold' >{data.title} </h1>
                <h2 className='font-semibold text-3xl mb-10'>{data.sub_title} </h2>
                <PrimaryButton className='w-1/3 font-semibold text-[20px] py-4 text-center flex justify-center shadow-xl shadow-slate-500'>
                    {data.button}
                </PrimaryButton>
            </div>
            <div className="flex justify-center items-center w-full h-full ">
                <img height={250} src={ensureHttpsUrl('/media/images/gifs/anime2.gif',APP_URL)} alt="image1" />
            </div>
        </div>
    )
}

export default SectionHero
