<?php

use App\Http\Controllers\Core\LectureController;
use App\Http\Controllers\Core\LectureQuestionController;
use App\Http\Controllers\Core\LectureReviewController;
use App\Http\Controllers\Core\StudentController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')
    ->prefix('actions/student')
    ->group(function () {

        Route::controller(StudentController::class)->group(function () { {
                Route::post('/add-level/{id}', 'addLevel')->name('student.addLevel');
                Route::post('/profile/update', 'updateOne')->name('student.updateProfile');
            }
        });
        Route::controller(LectureController::class)->group(function () { {
                Route::post('/lecture/like/{id}', 'like')->name('lecture.like');
                Route::post('/lecture/dislike/{id}', 'dislike')->name('lecture.dislike');
            }
        });
        Route::controller(LectureQuestionController::class)->group(function () { {
                Route::post('/ask', 'createOne')->name('student.lecture.ask');
            }
        });
    });
