<?php

namespace App\Extensions\Controller;

use Closure;
use Illuminate\Http\Request;

trait CreateExtension
{
    // public function createOne(Request $request)
    // {
    //     return $this->create($request);
    // }
    protected $modelCreated = null;

    public function createMany(Request $request)
    {
        $data = $request->all();
        $response = [];
        foreach ($data as $item) {
            $response[] = $this->create($item);
        }
        return $response;
    }

    private function create(Request $request, $default = [], ?Closure $onFinish = null): bool
    {
        $model = $this->model;
        $model = new $model();
        $model->fill(array_merge($request->validated(), $default));
        $result =  $model->save();

        if($result){
            $this->modelCreated = $model;
        }

        if ($onFinish) {
            $onFinish($model);
        }
        return $result;
    }

    private function updateOrCreate(Request $request,$default = [],$attributes = [], ?Closure $onFinish = null): bool
    {

        $model = $this->model;
        $modelCreated =  $model::updateOrCreate($attributes,array_merge($request->validated(), $default));

        if($modelCreated){
            $this->modelCreated = $modelCreated;
        }else{
            return false;
        }

        if ($onFinish) {
            $onFinish($model);
        }

        return true;
    }
}
