<?php

namespace App\Extensions\Controller;

use App\Enums\ResponseTypeEnum;

trait ResponseExtension
{
    public function success($data = [],  $code = 200, $message = null,)
    {
        if ($this->responseType === ResponseTypeEnum::VIEW) {
            return view($this->view, $data);
        }

        return response()->json([
            'status' => 'success',
            'message' => $message,
            'data' => $data
        ], $code);
    }

    public function error($message = 'Error', $code = 400)
    {
        return response()->json([
            'status' => 'error',
            'message' => $message
        ], $code);
    }
}
