<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\Exam\CreateExamRequest;
use App\Http\Requests\Exam\UpdateExamRequest;
use Illuminate\Http\Request;

class ExamController extends CoreController
{
    use ModelExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function createOne(CreateExamRequest $request)
    {
        if($this->create($request)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.exams'), 'success', 'Exam created successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to create exam');
    }

    public function updateOne(UpdateExamRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.exams'), 'success', 'Exam updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update exam');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.exams'), 'success', 'Exam deleted successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to delete exam');
    }
}
