<?php

namespace App\Http\Controllers\Core;

use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\CoreController;
use App\Http\Requests\ExamTask\SetUpLayoutRequest;
use Illuminate\Http\Request;

class LayoutController extends CoreController
{

    use ModelExtension,  UpdateExtension;

    public function __construct() {
        $this->model = $this->resolveModelName();
    }

    public function updateOne(SetUpLayoutRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->redirectWithNotification(
               redirect()->route('admin.layout'), 'success', 'Layout updated successfully'
            );
        }

        return $this->redirectWithNotification(back(), 'error', 'Failed to update Layout');
    }
}
