<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\ModelGetExtension;
use App\Http\Controllers\RestApiController;
use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Requests\Course\CreateCourseRequest;
use App\Http\Requests\Course\UpdateCourseRequest;
use Illuminate\Http\Request;

class CourseController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct()
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: ['material','sections'])->get());
    }

    public function readOne($id)
    {
        return  $this->successResponse($this->model::with(relations:['material','sections'])->findOrFail($id));
    }

    public function createOne(CreateCourseRequest $request)
    {
        if($this->create($request)) {
            return $this->successResponse(
               $this->modelCreated, 'Course created successfully',201
            );
        }

        return $this->badRequestResponse( 'Failed to create Course');
    }

    public function updateOne(UpdateCourseRequest $request, $id)
    {
        if($this->update($request, $id)) {
            return $this->successResponse(
               $this->modelUpdated, 'Course updated successfully'
            );
        }

        return $this->badRequestResponse( 'Failed to update Course');
    }

    public function deleteOne($id)
    {
        if($this->delete($id)) {
            return $this->successResponse(
               null,  'Course deleted successfully'
            );
        }

        return $this->badRequestResponse(  'Failed to delete Course');
    }
}
