<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\Lecture\CreateLectureRequest;
use App\Http\Requests\Lecture\UpdateLectureRequest;
use App\Services\Model\LectureService;
use App\Services\Model\StudentService;

class MaterialNoteController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct(
        protected ?StudentService $studentService,
        protected LectureService $lectureService,
    ) {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
           'material'
        ])->get());
    }

    public function readOne($id)
    {
        return $this->successResponse($this->model::with(relations: [
           'material'
        ])->findOrFail($id));
    }

    public function createOne(CreateLectureRequest $request)
    {
        if ($this->create($request)) {
            return $this->successResponse(
                $this->modelCreated,
                'Lecture created successfully',
                201
            );
        }

        return $this->badRequestResponse('Failed to create Lecture');
    }

    public function updateOne(UpdateLectureRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->successResponse(
                $this->modelUpdated,
                'Lecture updated successfully'
            );
        }

        return $this->badRequestResponse('Failed to update Lecture');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->successResponse(
                null,
                'Lecture deleted successfully'
            );
        }

        return $this->badRequestResponse('Failed to delete Lecture');
    }
}
