<?php

namespace App\Http\Controllers\RestApi\V1;

use App\Extensions\Controller\CreateExtension;
use App\Extensions\Controller\DeleteExtension;
use App\Extensions\Controller\ModelExtension;
use App\Extensions\Controller\ModelGetExtension;
use App\Extensions\Controller\UpdateExtension;
use App\Http\Controllers\RestApiController;
use App\Http\Requests\Student\CreateStudentRequest;
use App\Http\Requests\Student\UpdateStudentRequest;
use App\Models\Level;
use App\Models\SubLevel;
use App\Services\Model\StudentService;
use Illuminate\Http\Request;

class StudentController extends RestApiController
{
    use ModelExtension, ModelGetExtension, DeleteExtension, CreateExtension, UpdateExtension;

    public function __construct(protected StudentService $studentService)
    {
        $this->model = $this->resolveModelName();
    }

    public function read()
    {
        return $this->successResponse($this->model::with(relations: [
            'user',
            'level',
            'subLevel',
            'studentProcess',
            'exams',
            'lectureQuestions',
        ])->get());
    }

    public function readOne($id)
    {
        return $this->successResponse($this->model::with(relations: [
            'user',
            'level',
            'subLevel',
            'studentProcess',
            'exams',
            'lectureQuestions',
        ])->findOrFail($id));
    }

    public function createOne(CreateStudentRequest $request)
    {
        if ($this->create($request)) {
            return $this->successResponse(
                $this->modelCreated,
                'Student created successfully',
                201
            );
        }

        return $this->badRequestResponse('Failed to create Student');
    }

    public function updateOne(UpdateStudentRequest $request, $id)
    {
        if ($this->update($request, $id)) {
            return $this->successResponse(
                $this->modelUpdated,
                'Student updated successfully'
            );
        }

        return $this->badRequestResponse('Failed to update Student');
    }

    public function deleteOne($id)
    {
        if ($this->delete($id)) {
            return $this->successResponse(
                null,
                'Student deleted successfully'
            );
        }

        return $this->badRequestResponse('Failed to delete Student');
    }

    public function addLevel(Request $request, $id)
    {

        $level = Level::findOrFail($id);
        $subLevel = SubLevel::findOrFail($request->input('sub'));

        if ($level && $this->studentService->changeLevel($level, $subLevel)) {
            return $this->successResponse(null, 'level added successfully');
        }

        return $this->badRequestResponse('failed to add level');
    }
}
