<?php

namespace App\Http\Requests\LectureQuestion;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLectureQuestionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'lecture_id' => 'nullable|exists:lectures,id',
            'student_id' => 'nullable|exists:students,id',
            'question' => 'nullable|string',
            'answer' => 'nullable|string',
        ];
    }
}
