<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseSection extends Model
{
    /** @use HasFactory<\Database\Factories\CourseSectionFactory> */
    use HasFactory;

    protected $fillable = [
        'course_id',
        'title',
        'description',
        'number',
        'is_active',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function lectures()
    {
        return $this->hasMany(Lecture::class);
    }

    public function scopeSortByNumber($query)
    {
        return $query->orderBy('number');
    }
}

