<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Layout extends Model
{
    /** @use HasFactory<\Database\Factories\LayoutFactory> */
    use HasFactory;

    protected $fillable = [
        'field',
        'config',
    ];

    protected function casts(): array
    {
        return [
            'config' => 'array',  // Assuming 'config' is a JSON field
            'field' => 'string',  // Assuming 'field' is a string
        ];
    }


    protected static function filterByUsingIn($value)
    {
        return static::query()
            ->whereJsonContains('config->using_in', $value)
            ->get();
    }
}
