<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LectureQuestion extends Model
{
    /** @use HasFactory<\Database\Factories\LectureQuestionFactory> */
    use HasFactory;

    protected $fillable = [
        'lecture_id',
        'student_id',
        'question',
        'answer',
    ];


    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
}
