<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentProcessCourse extends Model
{
    /** @use HasFactory<\Database\Factories\StudentProcessCourseFactory> */
    use HasFactory;

    protected $fillable = [
        'student_id',
        'material_id',
        'course_id',
        'teacher_id',
        'course_section_id',
        'lecture_id',
        'last_watch_time',
        'is_saved',
        'is_finishLecture',
        'is_finishExam',
        'is_pass_exam',
    ];

    protected $casts = [
        'last_watch_time' => 'string',
        'is_saved' => 'boolean',
        'is_finishLecture' => 'boolean',
        'is_finishExam' => 'boolean',
        'is_pass_exam' => 'boolean',
    ];

    // Relationships
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function material()
    {
        return $this->belongsTo(Material::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function teacher()
    {
        return $this->belongsTo(Teacher::class);
    }

    public function courseSection()
    {
        return $this->belongsTo(CourseSection::class);
    }

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }
}
