<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubLevel extends Model
{
    /** @use HasFactory<\Database\Factories\SubLevelFactory> */
    use HasFactory;

    protected $fillable = [
        'level_id',
        'title',
        'description',
    ];

    protected $casts = [
        'level_id' => 'integer',
    ];

    // Relationships
    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public function materials()
    {
        return $this->hasMany(Material::class);
    }

    public function students()
    {
        return $this->hasMany(Student::class);
    }
}
