<?php

namespace App\Providers;

use App\Contracts\OtpSenderInterface;
use App\Services\ThirdParty\FakeOtpSender;
use App\Services\ThirdParty\TwilioService;
use Illuminate\Support\ServiceProvider;

class OtpSenderProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(OtpSenderInterface::class, function ($app) {
            return app()->isLocal()? new  FakeOtpSender() : new TwilioService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
