<?php

namespace App\Providers;

use App\Models\Student;
use App\Services\Model\StudentService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;

class StudentProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(StudentService::class, function ($app) {
            $with = [
                'level.materials.courses.sections.lectures.video',
                'subLevel',
                'studentProcess',
                'exams',
                'lectureQuestions',
            ];

            $student = Student::with($with)->where(['user_id' => Auth::id()])->first();

            if ($student) {
                return new StudentService($student);
            }

            return null;
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
