<?php

namespace Database\Seeders;

use App\Models\Exam;
use App\Models\ExamTask;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ExamTaskSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Truncate the ExamTask table to remove old data
        ExamTask::truncate();

        $faker = Faker::create('ar_SA'); // Arabic locale for Faker

        // Iterate over each Exam and generate tasks
        Exam::each(function ($exam) use ($faker) {
            $tasks = [
                [
                    'exam_id' => $exam->id,
                    'question' => 'ما هي عاصمة الجزائر؟',
                    'choices' => ['الجزائر', 'تونس', 'طرابلس', 'الرباط'],
                    'answer' => 'الجزائر',
                    'image' => $faker->imageUrl(640, 480, 'education', true, 'exam task'),
                    'video_time' => $faker->numberBetween(1, 300) . 's',
                    'points' => 50,
                ],
                [
                    'exam_id' => $exam->id,
                    'question' => 'ما هو أكبر كوكب في المجموعة الشمسية؟',
                    'choices' => ['الأرض', 'زحل', 'المشتري', 'المريخ'],
                    'answer' => 'المشتري',
                    'image' => $faker->imageUrl(640, 480, 'space', true, 'exam task'),
                    'video_time' => $faker->numberBetween(1, 300) . 's',
                    'points' => 50,
                ],
                [
                    'exam_id' => $exam->id,
                    'question' => 'من هو مؤسس علم الجبر؟',
                    'choices' => ['الخوارزمي', 'ابن سينا', 'ابن الهيثم', 'الفرابي'],
                    'answer' => 'الخوارزمي',
                    'image' => $faker->imageUrl(640, 480, 'mathematics', true, 'exam task'),
                    'video_time' => $faker->numberBetween(1, 300) . 's',
                    'points' => 50,
                ],
            ];

            // Insert the generated tasks into the database
            foreach ($tasks as $task) {
                ExamTask::create($task);
            }
        });
    }
}
