<?php

namespace Database\Seeders;

use App\Models\Level;
use App\Models\Material;
use App\Models\SubLevel;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MaterialSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'title' => 'التربية الإسلامية',
                'description' => 'مادة تهتم بدراسة أصول الدين وتعاليمه وقيمه الأخلاقية.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=rRRmNzuBSYaF&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ],
            [
                'title' => 'الرياضيات',
                'description' => 'مادة تركز على دراسة الأرقام والعمليات الحسابية والهندسية.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=cyQQ5i8svboJ&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ],
            [
                'title' => 'التاريخ',
                'description' => 'مادة تدرس الأحداث التاريخية والشخصيات المهمة عبر العصور.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=eghpqErHSTMn&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ],
            [
                'title' => 'الكيمياء',
                'description' => 'مادة تهتم بدراسة العناصر والمركبات والتفاعلات الكيميائية.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=117205&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ],
            [
                'title' => 'الأحياء',
                'description' => 'مادة تهتم بدراسة الكائنات الحية ووظائفها الحيوية.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=13088&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ],
            [
                'title' => 'الجيولوجيا',
                'description' => 'مادة تركز على دراسة الصخور والمعادن وتكوين الأرض.',
                'cover_image' => 'https://img.icons8.com/?size=100&id=55207&format=png&color=000000',
                'level_id' => Level::first()?->id,
                'sub_level_id' => SubLevel::first()?->id,
            ]
        ];

        Material::each(fn($item) => $item->forceDelete());

        foreach ($data as $i => $item) {
            Material::create($item);
        }
    }
}
