<?php

namespace Database\Seeders;

use App\Models\Level;
use App\Models\SubLevel;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SubLevelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [

            [
                'title' => 'الصف العلمي',
                'description' => 'هنا وصف الصف',
                'level_id' => Level::first()?->id
            ],
            [
                'title' => 'الصف الأدبي',
                'description' => 'هنا وصف الصف',
                'level_id' => Level::first()?->id
            ]
        ];

        SubLevel::each(fn($item) => $item->forceDelete());

        foreach ($data as $i => $item) {
            SubLevel::create($item);
        }
    }
}
