import type { ElementProps, FloatingContext, ReferenceType } from '../types';
export declare const normalizeBubblesProp: (bubbles?: boolean | {
    escapeKey?: boolean;
    outsidePress?: boolean;
}) => {
    escapeKeyBubbles: boolean;
    outsidePressBubbles: boolean;
};
export interface DismissPayload {
    type: 'outsidePress' | 'referencePress' | 'escapeKey' | 'mouseLeave';
    data: {
        returnFocus: boolean | {
            preventScroll: boolean;
        };
    };
}
export interface Props {
    enabled?: boolean;
    escapeKey?: boolean;
    referencePress?: boolean;
    referencePressEvent?: 'pointerdown' | 'mousedown' | 'click';
    outsidePress?: boolean | ((event: MouseEvent) => boolean);
    outsidePressEvent?: 'pointerdown' | 'mousedown' | 'click';
    ancestorScroll?: boolean;
    bubbles?: boolean | {
        escapeKey?: boolean;
        outsidePress?: boolean;
    };
}
/**
 * Adds listeners that dismiss (close) the floating element.
 * @see https://floating-ui.com/docs/useDismiss
 */
export declare const useDismiss: <RT extends ReferenceType = ReferenceType>({ open, onOpenChange, events, nodeId, elements: { reference, domReference, floating }, dataRef, }: FloatingContext<RT>, { enabled, escapeKey, outsidePress: unstable_outsidePress, outsidePressEvent, referencePress, referencePressEvent, ancestorScroll, bubbles, }?: Props) => ElementProps;
