import type { ElementProps, FloatingContext, ReferenceType } from '../types';
export interface Props {
    enabled?: boolean;
    role?: 'tooltip' | 'dialog' | 'alertdialog' | 'menu' | 'listbox' | 'grid' | 'tree';
}
/**
 * Adds relevant screen reader props for a given element `role`.
 * @see https://floating-ui.com/docs/useRole
 */
export declare const useRole: <RT extends ReferenceType = ReferenceType>({ open }: FloatingContext<RT>, { enabled, role }?: Partial<Props>) => ElementProps;
