const defaultErrorTitles = {
  2: "Network Error",
  3: "Decode Error",
  4: "Source Not Supported",
  5: "Encryption Error"
};
const defaultErrorMessages = {
  2: "A network error caused the media download to fail.",
  3: "A media error caused playback to be aborted. The media could be corrupt or your browser does not support this format.",
  4: "An unsupported error occurred. The server or network failed, or your browser does not support this format.",
  5: "The media is encrypted and there are no keys to decrypt it."
};
const formatError = (error) => {
  var _a, _b;
  if (error.code === 1)
    return null;
  return {
    title: (_a = defaultErrorTitles[error.code]) != null ? _a : `Error ${error.code}`,
    message: (_b = defaultErrorMessages[error.code]) != null ? _b : error.message
  };
};
const tooltipLabels = {
  ENTER_AIRPLAY: "Start airplay",
  EXIT_AIRPLAY: "Stop airplay",
  AUDIO_TRACK_MENU: "Audio",
  CAPTIONS: "Captions",
  ENABLE_CAPTIONS: "Enable captions",
  DISABLE_CAPTIONS: "Disable captions",
  START_CAST: "Start casting",
  STOP_CAST: "Stop casting",
  ENTER_FULLSCREEN: "Enter fullscreen mode",
  EXIT_FULLSCREEN: "Exit fullscreen mode",
  MUTE: "Mute",
  UNMUTE: "Unmute",
  ENTER_PIP: "Enter picture in picture mode",
  EXIT_PIP: "Enter picture in picture mode",
  PLAY: "Play",
  PAUSE: "Pause",
  PLAYBACK_RATE: "Playback rate",
  RENDITIONS: "Quality",
  SEEK_BACKWARD: "Seek backward",
  SEEK_FORWARD: "Seek forward",
  SETTINGS: "Settings"
};
const nouns = {
  AUDIO_PLAYER: () => "audio player",
  VIDEO_PLAYER: () => "video player",
  VOLUME: () => "volume",
  SEEK: () => "seek",
  CLOSED_CAPTIONS: () => "closed captions",
  PLAYBACK_RATE: ({ playbackRate = 1 } = {}) => `current playback rate ${playbackRate}`,
  PLAYBACK_TIME: () => `playback time`,
  MEDIA_LOADING: () => `media loading`,
  SETTINGS: () => `settings`,
  AUDIO_TRACKS: () => `audio tracks`,
  QUALITY: () => `quality`
};
const verbs = {
  PLAY: () => "play",
  PAUSE: () => "pause",
  MUTE: () => "mute",
  UNMUTE: () => "unmute",
  ENTER_AIRPLAY: () => "start airplay",
  EXIT_AIRPLAY: () => "stop airplay",
  ENTER_CAST: () => "start casting",
  EXIT_CAST: () => "stop casting",
  ENTER_FULLSCREEN: () => "enter fullscreen mode",
  EXIT_FULLSCREEN: () => "exit fullscreen mode",
  ENTER_PIP: () => "enter picture in picture mode",
  EXIT_PIP: () => "exit picture in picture mode",
  SEEK_FORWARD_N_SECS: ({ seekOffset = 30 } = {}) => `seek forward ${seekOffset} seconds`,
  SEEK_BACK_N_SECS: ({ seekOffset = 30 } = {}) => `seek back ${seekOffset} seconds`,
  SEEK_LIVE: () => "seek to live",
  PLAYING_LIVE: () => "playing live"
};
var labels_default = {
  ...nouns,
  ...verbs
};
export {
  labels_default as default,
  formatError,
  nouns,
  tooltipLabels,
  verbs
};
