import { createConfigUtils } from './config-utils.mjs';
import { mergeClassList } from './merge-classlist.mjs';
import { twJoin } from './tw-join.mjs';

function createTailwindMerge() {
  for (var _len = arguments.length, createConfig = new Array(_len), _key = 0; _key < _len; _key++) {
    createConfig[_key] = arguments[_key];
  }

  var configUtils;
  var cacheGet;
  var cacheSet;
  var functionToCall = initTailwindMerge;

  function initTailwindMerge(classList) {
    var firstCreateConfig = createConfig[0],
        restCreateConfig = createConfig.slice(1);
    var config = restCreateConfig.reduce(function (previousConfig, createConfigCurrent) {
      return createConfigCurrent(previousConfig);
    }, firstCreateConfig());
    configUtils = createConfigUtils(config);
    cacheGet = configUtils.cache.get;
    cacheSet = configUtils.cache.set;
    functionToCall = tailwindMerge;
    return tailwindMerge(classList);
  }

  function tailwindMerge(classList) {
    var cachedResult = cacheGet(classList);

    if (cachedResult) {
      return cachedResult;
    }

    var result = mergeClassList(classList, configUtils);
    cacheSet(classList, result);
    return result;
  }

  return function callTailwindMerge() {
    return functionToCall(twJoin.apply(null, arguments));
  };
}

export { createTailwindMerge };
//# sourceMappingURL=create-tailwind-merge.mjs.map
