import React, { ReactNode } from 'react'
import InputLabel from './InputLabel'

type Props = {
    children?: ReactNode
    label?: string
    error?: string
    labelClassName?: string
    className?: string
}

const FormElement = ({ children, error, label, labelClassName,className }: Props) => {
    return (
        <div className={className}>
            <InputLabel className={'text-md my-3 ' + labelClassName} >{label ?? ''} </InputLabel>
            {children}
            {error && <p className='text-xs text-red-500 mt-3 '>{error} </p>}
        </div>
    )
}

export default FormElement
