import { Modal } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import { Exam, ExamTask } from '@/types/models/exam'
import { Lecture } from '@/types/models/lecture'
import { ButtonAdd, ButtonDelete, ExamForm } from '@/Ui'
import { Link, useForm } from '@inertiajs/react'
import { Card } from 'antd'
import { FormEventHandler, useState } from 'react'

type Props = {
    exams: Exam[]
    lectures: Lecture[]
}

const Exams = ({ exams, lectures }: Props) => {

    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')

    const [selectedExam, setSelectedExam] = useState<Exam>()


    const handleAddExam = () => {
        setModalOpen(true)
        setSelectedExam(undefined)
        setModelSection('form')
    }

    const examForm = useForm(selectedExam ?? { id: '', lecture_id: '' })

    const createExam: FormEventHandler = (e) => {
        e.preventDefault()
        examForm.post(route('admin.exam.createOne'), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }
    const updateExam: FormEventHandler = (e) => {
        e.preventDefault()
        examForm.put(route('admin.exam.updateOne', selectedExam?.id), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    return (
        <DashboardLayout title='الاختبارات' headChild={<ButtonAdd onClick={handleAddExam} />} >
            <Modal show={modalOpen} onClose={() => setModalOpen(false)}>
                {modelSection === 'form' && <ExamForm lectures={lectures} form={examForm} submit={selectedExam ? updateExam : createExam} />}
                {/* {(modelSection === 'delete' && selectedItem) && <DeleteForm show={modalOpen} id={selectedItem?.id} onClose={close} />} */}
            </Modal>
            {exams.map((item, i) => (
                <ExamCard data={item} />
            ))}
        </DashboardLayout>
    )
}

export default Exams


const ExamCard = ({ data }: { data: Exam }) => {
    return <Card className='mb-3' >
        <div className="flex">
            <Link href={route('admin.exams.detail', { id: data.id })} className="flex-1 ">
                <h3 className='mb-3 font-semibold' >إختبار {data.lecture?.title} </h3>
            </Link>
            <div className="flex">
                <ButtonDelete />
            </div>
        </div>
    </Card>
}
