import { FormElement, FormInput, ImageOrUpload } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import { Layout, LayoutConfig, NavLayoutConfigProps, PagePublicLayoutConfigProps } from '@/types/models/layout'
import { useForm } from '@inertiajs/react'
import { ColorPicker, Divider } from 'antd'
import React from 'react'

type Props = {
    layouts: Layout[]
}

const Layouts = ({ layouts }: Props) => {




    const PagePublicLayoutForm = () => {

        const pagePublicLayout = layouts.find(m => m.field === "page_public") as PagePublicLayoutConfigProps | undefined
        const form = useForm(pagePublicLayout)

        return (
            <form className='' >
                <div className="flex gap-5">
                    <Divider orientation='left'> إعدادات الصفحات العامة </Divider>
                    <FormElement label='لون الخط'>
                        <ColorPicker value={form.data.color} onChange={c => form.setData('color', c.toHexString())} />
                    </FormElement>
                    <FormElement label='لون الخلفية'>
                        <ColorPicker value={form.data.bg_color} onChange={c => form.setData('bg_color', c.toHexString())} />
                    </FormElement>
                </div>
                <ImageOrUpload image={form.data.bg} onSuccess={res => form.setData('bg', res.file_path)} />
            </form>)
    }

    const NavLayoutForm = () => {

        const pagePublicLayout = layouts.find(m => m.field === "nav_public") as NavLayoutConfigProps | undefined
        const form = useForm(pagePublicLayout)

        return (
            <form >
                <div className="flex gap-5">
                    <Divider orientation='left'> إعدادات  الترويسة </Divider>
                    <FormElement label='لون الخلفية'>
                        <ColorPicker value={form.data.bg_color} onChange={c => form.setData('bg_color', c.toHexString())} />
                    </FormElement>
                </div>
                <ImageOrUpload image={form.data.logo} onSuccess={res => form.setData('logo', res.file_path)} />

            </form>)
    }

    return (
        <DashboardLayout title='التخطيط'>

            <PagePublicLayoutForm />
            <NavLayoutForm />

        </DashboardLayout>
    )
}

export default Layouts
