import { Modal, PrimaryButton } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import SecondaryButton from '@/Trash/Comps/SecondaryButton'
import { ID } from '@/types/models'
import { Level } from '@/types/models/level'
import { SubLevel } from '@/types/models/sub_level'
import { ButtonAdd, ButtonCreate, ButtonDelete, ButtonEdit, ButtonOpenClose, LevelForm, SubLevelForm } from '@/Ui'
import { useForm } from '@inertiajs/react'
import { Divider } from 'antd'
import { Divide } from 'lucide-react'
import React, { FormEventHandler, useState } from 'react'

type Props = {
    levels: Level[],
}

const Levels = ({ levels }: Props) => {
    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')

    const [selectedLevel, setSelectedLevel] = useState<Level>()
    const [selectedSubLevel, setSelectedSubLevel] = useState<SubLevel>()

    const onClose = () => {
        setModalOpen(false)
        setModelSection('')
        setSelectedLevel(undefined)
        form.setData(defaultLevel)
    }

    /** @level */

    const handleAddLevel = () => {
        setModalOpen(true)
        setSelectedLevel(undefined)
        setModelSection('form')
    }
    const handleUpdateLevel = (item: Level) => {
        setModalOpen(true)
        setSelectedLevel(item)
        form.setData(item)
        setModelSection('form')
    }
    const handleDeleteLevel = (item: Level) => {
        setModalOpen(true)
        setSelectedLevel(item)
        setModelSection('delete')
    }

    const defaultLevel = {
        id: '',
        title: '',
        description: '',
    }
    const form = useForm(selectedLevel ? selectedLevel : defaultLevel)

    const closeModal = () => {
        setModalOpen(false)
    }

    const createLevel: FormEventHandler = (e) => {
        e.preventDefault()
        form.post(route('admin.level.createOne'), {
            onSuccess: () => {
                onClose()
            }
        })
    }
    const updateLevel: FormEventHandler = (e) => {
        e.preventDefault()
        form.put(route('admin.level.updateOne', { id: selectedLevel?.id }), {
            onSuccess: () => {
                onClose()
            }
        })
    }


    const LevelCard = ({ level, }: { level: Level }) => {

        const [open, setOpen] = useState(false)

        return (
            <>
                <div className="bg-white rounded-md p-6 border mb-2">
                    <div className="flex justify-between">

                        <div className="flex-1">
                            <h4 className='font-semibold mb-4'>{level.title} </h4>
                            <p>
                                {level.description}
                            </p>
                        </div>
                        <div className="flex flex-col gap-2">
                            <ButtonDelete onClick={() => handleDeleteLevel(level)} />
                            <ButtonEdit onClick={() => handleUpdateLevel(level)} />
                            <ButtonOpenClose status={open} onClick={() => setOpen(!open)} />
                        </div>
                    </div>
                </div>
                {open && <div className="bg-gray-100 p-6 border-r rounded-md  border-b border-l mb-3">
                    <div className="flex justify-between items-center border-b p-4">
                        <h5 className='font-semibold ' >الصف الفرعي</h5>
                        <div className="">
                            <ButtonCreate onClick={handleAddSubLevel} />
                        </div>
                    </div>
                    {level.sub_levels?.map((sub_level, i) => <div key={i} className="bg-white rounded-md my-2 border mb-4 p-4 flex justify-between">
                        <div className="flex-1">
                            <h4 className='font-semibold mb-4'>{sub_level.title} </h4>
                            <p>
                                {sub_level.description}
                            </p>
                        </div>
                        <div className="flex flex-col gap-2">
                            <ButtonDelete onClick={() => handleDeleteSubLevel(sub_level)} />
                            <ButtonEdit onClick={() => handleUpdateSubLevel(sub_level)} />
                        </div>
                    </div>)}
                </div>}
            </>
        )
    }


    const DeleteLevelForm = ({ item, onClose }: { item: Level, onClose: CallableFunction }) => {

        const form = useForm()

        const submit: FormEventHandler = (e) => {
            e.preventDefault()
            form.delete(route('admin.level.deleteOne', { id: item.id }), {
                onSuccess: () => {
                    onClose()
                }
            })
        }

        return <div>
            <p className="p-4 ">
                هل تريد حقا حذف هذا الصف!
            </p>
            <div className="mt-5 items-center gap-3 flex ">
                <PrimaryButton className='bg-red-500' onClick={submit} >نعم</PrimaryButton>
                <SecondaryButton onClick={() => onClose()} >لا</SecondaryButton>
            </div>
        </div>
    }

    /** @sub_level */

    const handleAddSubLevel = () => {
        setModalOpen(true)
        setSelectedSubLevel(undefined)
        formSubLevel.setData(defaultSubLevel)
        setModelSection('form_sublevel')
    }
    const handleUpdateSubLevel = (item: SubLevel) => {
        setModalOpen(true)
        setSelectedSubLevel(item)
        formSubLevel.setData(item)
        setModelSection('form_sublevel')
    }
    const handleDeleteSubLevel = (item: SubLevel) => {
        setModalOpen(true)
        setSelectedSubLevel(item)
        setModelSection('delete_sublevel')
    }

    const defaultSubLevel: SubLevel = {
        id: '',
        title: '',
        description: '',
        level_id: '' as ID
    }
    const formSubLevel = useForm(selectedSubLevel ? selectedSubLevel : defaultSubLevel)

    const createSubLevel: FormEventHandler = (e) => {
        e.preventDefault()
        formSubLevel.post(route('admin.subLevel.createOne'), {
            onSuccess: () => {
                onClose()
            }
        })
    }
    const updateSubLevel: FormEventHandler = (e) => {
        e.preventDefault()
        formSubLevel.put(route('admin.subLevel.updateOne', { id: selectedSubLevel?.id }), {
            onSuccess: () => {
                onClose()
            }
        })
    }

    const DeleteSubLevelForm = ({ item, onClose }: { item: Level, onClose: CallableFunction }) => {

        const form = useForm()

        const submit: FormEventHandler = (e) => {
            e.preventDefault()
            form.delete(route('admin.subLevel.deleteOne', { id: item.id }), {
                onSuccess: () => {
                    onClose()
                }
            })
        }

        return <div>
            <p className="p-4 ">
                هل تريد حقا حذف هذا الصف الفرعي!
            </p>
            <div className="mt-5 items-center gap-3 flex ">
                <PrimaryButton className='bg-red-500' onClick={submit} >نعم</PrimaryButton>
                <SecondaryButton onClick={() => onClose()} >لا</SecondaryButton>
            </div>
        </div>
    }


    return (
        <DashboardLayout title='الصفوف' headChild={<ButtonAdd onClick={handleAddLevel} />} >
            <Modal show={modalOpen} onClose={closeModal} >
                {modelSection === 'form' && <LevelForm form={form} submit={!selectedLevel ? createLevel : updateLevel} />}
                {modelSection === 'form_sublevel' && <SubLevelForm levels={levels} form={formSubLevel} submit={!selectedSubLevel ? createSubLevel : updateSubLevel} />}
                {(modelSection === 'delete' && selectedLevel) && <DeleteLevelForm item={selectedLevel} onClose={onClose} />}
                {(modelSection === 'delete_sublevel' && selectedSubLevel) && <DeleteSubLevelForm item={selectedSubLevel} onClose={onClose} />}
            </Modal>
            {levels.map((m, i) => <LevelCard key={i} level={m} />)}
        </DashboardLayout>
    )
}

export default Levels


