import { FormInput, Modal, PrimaryButton, SmallCard } from '@/Components'
import DashboardLayout from '@/Layouts/DashboardLayout'
import { PageProps } from '@/types'
import { Permission } from '@/types/models/role'
import { ButtonAdd, ButtonDelete } from '@/Ui'
import { useForm } from '@inertiajs/react'
import { FormEventHandler, useState } from 'react'

type Props = {
    permissions: Permission[]
}
const Permissions = ({ permissions }: PageProps<Props>) => {

    const [modalOpen, setModalOpen] = useState<boolean>(false)
    const [modelSection, setModelSection] = useState('')
    const [selectedPermission, setSelectedPermission] = useState<Permission>()

    const closeModal = () => {
        setModalOpen(false)
        setModelSection('')
    }

    const defaultPermission: Permission = {
        id: '',
        name: '',
    }
    const form = useForm(selectedPermission ?? defaultPermission)

    const handleAdd = () => {
        setModalOpen(true)
        setSelectedPermission(undefined)
        form.setData(defaultPermission)
        setModelSection('form')
    }

    const handleUpdate = (item: Permission) => {
        setModalOpen(true)
        setSelectedPermission(item)
        form.setData(item)
        setModelSection('form')
    }

    const create: FormEventHandler = (e) => {
        e.preventDefault()
        form.post(route('admin.permission.createOne'), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    const update: FormEventHandler = (e) => {
        e.preventDefault()
        form.put(route('admin.permission.updateOne', selectedPermission?.id), {
            onSuccess: () => {
                setModalOpen(false)
            }
        })
    }

    return (
        <DashboardLayout title='الصلاحيات' headChild={<ButtonAdd onClick={handleAdd} />}>
            <Modal show={modalOpen} onClose={closeModal} >
                {modelSection === 'form' && (
                    <form onSubmit={selectedPermission ? update : create} >
                        <FormInput label='الإسم' value={form.data.name} onChange={e => form.setData('name', e.target.value)} />
                        <PrimaryButton className='mt-5' >حفظ</PrimaryButton>
                    </form>
                )}
            </Modal>
            <div className="flex ">
                {permissions.map((item, i) =>
                    <SmallCard key={i}>
                        {item.name}
                        <ButtonDelete />
                    </SmallCard>)}
            </div>
        </DashboardLayout>
    )
}

export default Permissions
