import React from "react";
import { Link } from "@inertiajs/react";

const ErrorPage: React.FC<{ status: number }> = ({ status }) => {
  const getMessage = () => {
    switch (status) {
      case 404:
        return "Oops! Page not found.";
      case 500:
        return "Server error. Please try again later.";
      case 403:
        return "You don't have permission to access this page.";
      default:
        return "Something went wrong.";
    }
  };

  return (
    <div className="flex flex-col items-center justify-center h-screen text-center">
      <h1 className="text-6xl font-bold text-red-500">{status}</h1>
      <p className="text-xl mt-4">{getMessage()}</p>
      <Link href="/" className="mt-6 text-blue-600 underline">
        Go to Homepage
      </Link>
    </div>
  );
};

export default ErrorPage;
