import { FormInput, PrimaryButton } from '@/Components'
import PublicLayout from '@/Layouts/PublicLayout'
import { Link, useForm } from '@inertiajs/react'
import { FormEventHandler } from 'react'

const Login = () => {

    const { data, setData, errors, post } = useForm({
        phone: "",
    })

    const submit: FormEventHandler = e => {
        e.preventDefault()
        post(route('auth.student.login'));
    }

    return (
        <PublicLayout title='تسجيل الدخول' withNav={false} >
            <div className="mx-auto flex justify-center mt-20">
                <form onSubmit={submit} className="bg-[#111] rounded-md w-1/3 text-pink-50 p-8 flex flex-col gap-5">
                    <h1 className='text-center text-3xl mb-5 text-pink-50' >تسجيل الدخول</h1>
                    <FormInput dir='ltr' value={data.phone} onChange={e => setData('phone', e.target.value)} error={errors.phone} label='أدخل رقم الهاتف' name='phone' placeholder='رقم الهاتف' className='w-full bg-transparent text-white' />
                    <PrimaryButton className='w-full' >تسجيل</PrimaryButton>
                    <Link className='mt-5 text-center text-purple-300' href={route('public.register')}>
                        إنشاء حساب جديد
                    </Link>
                </form>
            </div>
        </PublicLayout>
    )
}

export default Login
