import StudentLayout from "@/Layouts/StudentLayout"
import { PageProps } from "@/types"
import { Course } from "@/types/models/course"
import { CourseSection } from "@/types/models/course_section"
import { Material } from "@/types/models/material"
import { Link } from "@inertiajs/react"
import { Select } from "antd"
import { Book, Dot, Minus, Notebook, Plus, Pointer } from "lucide-react"
import { useRef, useState } from "react"
import { motion } from 'framer-motion'; // Ensure you install framer-motion

type Props = {
    material: Material
}

const MaterialShow = ({ auth, material }: PageProps<Props>) => {

    const [course, setCourse] = useState<Course>()


    return (
        <StudentLayout title={material.title}>
            <div className="w-[90%] mx-auto text-white">
                <div className="flex gap-10 items-center">
                    <img src={material.cover_image} alt="" />
                    <div className="flex flex-col justify-between">
                        <h1 className='text-3xl font-semibold text-white'>
                            {material?.title}
                        </h1>
                        <p className='text-md mt-5 '>
                            {material?.description}
                        </p>
                    </div>
                </div>
                <div className="flex gap-5">
                    <Link className="w-full" href={route('student.materialNotes', { materialId: material?.id })}>
                        <div className="rounded-xl text-white gap-3  mt-20 p-10 w-full flex justify-center flex-col items-center bg-slate-950 ">
                            <Notebook className='text-gray-100' size={30} />
                            <strong className="font-semibold text-xl">المدكرات</strong>
                        </div>
                    </Link>
                    <div className="rounded-xl w-full text-white gap-3  mt-20 p-10  flex justify-center flex-col items-center bg-slate-950 ">
                        <Book className='text-gray-100' size={30} />
                        <strong className="font-semibold text-xl">بطاقات الحفظ</strong>
                    </div>
                </div>
                <div className="rounded-xl mt-5 px-10 py-10 bg-slate-950 min-h-screen">
                    <div className="flex flex-col items-center gap-5 justify-center">
                        <h2 className='text-3xl font-semibold text-white text-center'>هيكل المادة</h2>
                        <Select className="w-1/4 h-[40px]" onSelect={(value) => material.courses && setCourse(material.courses?.find((l) => l.id === value))}>
                            {material.courses?.map((course) => (
                                <Select.Option key={course.id} value={course.id}>
                                    {course.title}
                                </Select.Option>
                            ))}
                        </Select>
                    </div>
                    <div className="mt-10">
                        {course?.sections?.map((section, i) => <Section section={section} key={i} />)}
                    </div>
                </div>
            </div>
        </StudentLayout>
    )
}

export default MaterialShow


const Section = ({ section }: { section: CourseSection }) => {
    const [open, setOpen] = useState(false);
    const contentRef = useRef<HTMLUListElement>(null);

    return (
        <div className="bg-slate-800 rounded-2xl p-10 w-full mb-5 text-white hover:opacity-70">
            <div className="flex justify-between items-center">
                <p
                    onClick={() => setOpen(!open)}
                    className="text-white text-xl font-semibold cursor-pointer hover:opacity-70"
                >
                    {section.title}
                </p>
                <button onClick={() => setOpen(!open)}>
                    {open ? <Minus /> : <Plus />}
                </button>
            </div>
            <motion.div
                initial={{ height: 0, opacity: 0 }}
                animate={{
                    height: open ? contentRef.current?.scrollHeight || 0 : 0,
                    opacity: open ? 1 : 0,
                }}
                transition={{ duration: 0.3 }}
                className="overflow-hidden mt-5"
            >
                <ul className="transition-all duration-300" ref={contentRef}>
                    {section?.lectures?.map((lecture, k) => (
                        <li key={k} className="mb-3 flex">
                            <Dot className="text-purple-600" />
                            <Link href={route('student.courseLectures', { id: section.id, videoId: lecture.video_id })}>
                                <strong className="ml-2">{lecture.title}</strong>
                            </Link>
                        </li>
                    ))}
                </ul>
            </motion.div>
        </div>
    );
};


