import { FormInput, PrimaryButton } from '@/Components';
import { useUrlParams } from '@/Hooks';
import StudentLayout from '@/Layouts/StudentLayout'
import { PageProps, User as UserType } from '@/types';
import { ID } from '@/types/models';
import { Level } from '@/types/models/level';
import { Student } from '@/types/models/student';
import { CountrySelect, LevelSelect, SubLevelSelect } from '@/Ui';
import { useForm } from '@inertiajs/react';
import { Divider, Spin } from 'antd';
import { Loader, Loader2, Lock, Phone, Trash, User } from 'lucide-react';
import React, { useEffect, useState } from 'react'

type Props = {
    mustVerifyEmail: boolean; status?: string
    levels: Level[]
}

type ProfileProps = UserType & Student

const Profile = ({ mustVerifyEmail, status, auth, levels }: PageProps<Props>) => {
    return (
        <StudentLayout title='الملف الشخصي'>
            <div className=" bg-gray-200 rounded-md p-10">
                <ProfileInfo profile={{
                    ...{ id: auth.user.id },
                    ...auth.user,
                    ...auth.student
                }} levels={levels} />
            </div>
            <div className=" bg-gray-200 rounded-md p-10 mt-10">
                <UpdatePassword />
            </div>
            <div className=" bg-gray-200 rounded-md p-10 mt-10">
                <UpdatePhone phone={auth.user.phone} token={auth.user.api_token} />
            </div>
            <div className=" bg-gray-200 rounded-md p-10 mt-10">
                <RemoveAccount />
            </div>
        </StudentLayout>
    )
}

export default Profile

const ProfileInfo = ({ profile, levels }: { profile: ProfileProps, levels: Level[] }) => {
    const form = useForm(profile);

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        form.post(route('student.updateProfile')); // Adjust the endpoint as needed
    };

    return (
        <form className='' onSubmit={handleSubmit}>
            <h3 className="flex gap-2 font-semibold text-xl mb-5">
                <User /> الملف الشخصي
            </h3>
            <Divider orientation='center' >المعلومات القانونية</Divider>
            <div className="mb-10 grid gap-2 my-2 md:grid-cols-2 ">
                <FormInput
                    label="الاسم"
                    value={form.data.name}
                    onChange={e => form.setData('name', e.target.value)}
                    error={form.errors.name}
                />
                <FormInput
                    label="الاسم الأول"
                    value={form.data.first_name}
                    onChange={e => form.setData('first_name', e.target.value)}
                    error={form.errors.first_name}
                />
                <FormInput
                    label="الاسم الأخير"
                    value={form.data.last_name}
                    onChange={e => form.setData('last_name', e.target.value)}
                    error={form.errors.last_name}
                />
            </div>
            <Divider orientation='center' >وسائل التواصل</Divider>
            <div className="mb-10 grid gap-2 my-2 md:grid-cols-2 ">

                <FormInput
                    label="البريد الإلكتروني"
                    value={form.data.email}
                    onChange={e => form.setData('email', e.target.value)}
                    error={form.errors.email}
                />
            </div>
            <Divider orientation='center' >المنطقة الجغرافية</Divider>
            <div className="mb-10 grid gap-2 my-2 md:grid-cols-2 ">
                <CountrySelect />
                <FormInput
                    label="المدينة"
                    value={form.data.city}
                    onChange={e => form.setData('city', e.target.value)}
                    error={form.errors.city}
                />
            </div>
            <Divider orientation='center' >التعليم</Divider>
            <div className="mb-10 grid gap-2 my-2 md:grid-cols-2 ">
                <LevelSelect selected={form.data.level_id} levels={levels} onSelect={e => form.setData('level_id', e)} />
                {form.data.level?.sub_levels && <SubLevelSelect selected={form.data.level_id} levels={form.data.level?.sub_levels} onSelect={e => form.setData('sub_level_id', e)} />}
            </div>
            <PrimaryButton type="submit" className="mt-5">
                حفظ
            </PrimaryButton>
        </form>
    );
};


const UpdatePassword = () => {
    const { data, setData, post } = useForm({
        password: '',
        password_confirm: '',
    });

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        post('/profile-update'); // Adjust the endpoint as needed
    };

    return (
        <form className='' onSubmit={handleSubmit}>
            <h3 className="flex gap-2 font-semibold text-xl mb-5">
                <Lock /> تغيير كلمة المرور
            </h3>
            <div className="grid gap-2 my-2 md:grid-cols-2  ">
                <FormInput
                    label='كلمة المرور'
                    id="password"
                    type="password"
                    name="password"
                    value={data.password}
                    className="mt-1 block w-full"
                    autoComplete="current-password"
                    onChange={(e) => setData('password', e.target.value)}
                />
                <FormInput
                    label=' تأكيد كلمة المرور'
                    id="password_confirm"
                    type="password"
                    name="password_confirm"
                    value={data.password_confirm}
                    className="mt-1 block w-full"
                    autoComplete="current-password"
                    onChange={(e) => setData('password', e.target.value)}
                />
            </div>
            <PrimaryButton type="submit" className="mt-5">
                حفظ
            </PrimaryButton>
        </form>
    )
}


const UpdatePhone = ({ phone, token }: { phone: string, token: string }) => {

    const section = 'update-phone'

    const { status } = useUrlParams()

    const [operation, setOperation] = useState<'save' | 'otp'>('otp')
    const { data, setData, post, get, errors, processing } = useForm({
        token,
        phone,
        otp: '',
    });

    useEffect(() => {
        if (status && status === 'success') {
            setOperation('save')
            document.querySelector('#' + section)?.scroll()
        } else {
            setOperation('otp')
        }
    }, [status])

    const handleSubmit = (e: React.FormEvent) => {
        e.preventDefault();
        if (operation === 'otp') {
            get(route('auth.student.resend-otp', {
                route_redirect_to: 'student.profile',
                token,
                section
            }), {
                onSuccess: () => {
                    setOperation('save')
                }
            });
        }
        if (operation === 'save') {
            post(route('auth.student.changePhone'));
        }
    };

    return (
        <form id={section} className='' onSubmit={handleSubmit}>
            <h3 className="flex gap-2 font-semibold text-xl mb-5">
                <Phone />تغيير رقم الهاتف
            </h3>
            {processing && <Spin />}
            <div className="grid gap-2 my-2 md:grid-cols-2  ">
                {operation === 'otp' &&
                    <FormInput
                        label="رقم الهاتف"
                        value={data.phone}
                        onChange={e => setData('phone', e.target.value)}
                        error={errors.phone}
                    />
                }
                {operation === 'save' && <FormInput
                    label="رمز OTP"
                    value={data.otp}
                    onChange={e => setData('otp', e.target.value)}
                    error={errors.otp}
                />}
            </div>
            <PrimaryButton disabled={processing} type="submit" className="mt-5">
                {operation === 'save' ? 'حفظ' : 'إرسال الرمز'}
            </PrimaryButton>
        </form>
    )
}

const RemoveAccount = () => {

    return (
        <form>
            <h3 className="flex gap-2 font-semibold text-xl mb-5">
                <Trash /> حدف الحساب
            </h3>
            <p className='mb-5'>
                يمكنك تعطيل حسابك مؤقتا أو حدفه نهائيا
            </p>
            <div className="flex gap-3">
                <PrimaryButton className='bg-gray-900'>
                    تعطيل الحساب
                </PrimaryButton>
                <PrimaryButton className='bg-red-500'>
                    حدف الحساب
                </PrimaryButton>
            </div>
        </form>
    )
}
